/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.ide.swing;

import de.mn77.base.data.Lib_Array;
import de.mn77.base.data.Lib_Random;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.error.Err_Runtime;
import de.mn77.base.sys.MOut;
import de.mn77.base.version.Lib_Version;
import de.mn77.base.version.VersionData_ABC;
import de.mn77.lib.swing.DIALOG_TYPE;
import de.mn77.lib.swing.Lib_SwingDialog;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jmo_lang.ide.swing.action.EVENTS;
import org.jmo_lang.ide.swing.action.JayMo_Actions;
import org.jmo_lang.ide.swing.defs.FileEditor;
import org.jmo_lang.ide.swing.defs.ToolbarPanel;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.sys.JMo_Input;

public class App_IDE_Swing {
    public static final VersionData_ABC VERSION = new VersionData_ABC(0, 4, 0);
    public static final int DEFAULT_WIDTH = 970;
    public static final int DEFAULT_HEIGHT = 600;
    private final JFrame frame;
    private final ToolbarPanel panel;
    private final JayMo_Actions actions;

    public static void main(String[] args) {
        String[] args2 = App_IDE_Swing.args(args);
        if (args2 != null) {
            File initFile;
            File file = initFile = args2.length == 1 ? new File(args2[0]) : null;
            if (initFile != null && !initFile.exists()) {
                MOut.print("File does not exist: " + initFile.getAbsolutePath());
            } else {
                SwingUtilities.invokeLater(() -> new App_IDE_Swing(initFile).createAndShowGUI());
            }
        }
    }

    public App_IDE_Swing(File initFile) {
        this.styleUI();
        this.frame = new JFrame();
        this.actions = new JayMo_Actions(this, this.frame);
        this.panel = new ToolbarPanel(this.actions);
        try {
            Lib_Version.init(VERSION, false);
        }
        catch (Err_FileSys e) {
            Err.show(e);
        }
        this.initInputSource();
        this.updateTitle(null);
        if (initFile != null) {
            this.actions.open(initFile);
        }
    }

    public void dispose() {
        this.frame.dispose();
    }

    public void setStatus(String s) {
        this.panel.setStatus(s);
    }

    public void updateTitle(FileEditor editor) {
        String title = "JM\u00b0 - IDE Light";
        if (editor != null) {
            if (editor.getCurrentFile() != null) {
                title = String.valueOf(title) + " - " + editor.getCurrentFile().getAbsolutePath();
            }
            if (editor.hasUnsavedChanges()) {
                title = String.valueOf(title) + " *";
            }
        }
        this.frame.setTitle(title);
    }

    private void addKeyEvents(JayMo_Actions actions) {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(e -> {
            if (402 != e.getID()) {
                return false;
            }
            int key = e.getKeyCode();
            int mod = e.getModifiersEx();
            int CTRL = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
            int ALT = 512;
            int SHIFT = 64;
            if (key == 81 && mod == CTRL) {
                actions.perform(EVENTS.EXIT);
            } else if (key == 79 && mod == CTRL) {
                actions.perform(EVENTS.OPEN);
            } else if (key == 83 && mod == CTRL) {
                actions.perform(EVENTS.SAVE);
            } else if (key == 83 && mod == CTRL + 64) {
                actions.perform(EVENTS.SAVE_AS);
            } else if (key == 10 && mod == CTRL) {
                actions.perform(EVENTS.EXEC);
            } else if (key == 153 && mod == CTRL) {
                actions.perform(EVENTS.EXEC);
            } else if (key == 112 && mod == 0) {
                actions.perform(EVENTS.INFO);
            } else if (key == 115 && mod == 0) {
                actions.perform(EVENTS.SLIDER);
            } else if (key == 120 && mod == 0) {
                actions.perform(EVENTS.EXEC);
            } else if (key == 121 && mod == 0) {
                actions.perform(EVENTS.STOP);
            } else if (key == 122 && mod == 0 || key == 10 && mod == 512) {
                boolean isMax = this.frame.getExtendedState() == 6;
                this.frame.setExtendedState(isMax ? 0 : 6);
            } else if (key == 123 && mod == 0) {
                actions.perform(EVENTS.WEB);
            } else if (key == 70 && mod == CTRL) {
                actions.perform(EVENTS.FIND);
            } else if (e.getKeyCode() == 72 && mod == CTRL) {
                Lib_SwingDialog.okay(this.frame, DIALOG_TYPE.INFO, "Find & Replace", "Replace-Feature is comming soon.");
            } else if (key == 65 && mod == CTRL + 64) {
                actions.perform(EVENTS.SELECT_NONE);
            } else {
                return false;
            }
            return true;
        });
    }

    private void createAndShowGUI() {
        this.frame.setDefaultCloseOperation(3);
        this.frame.add(this.panel);
        this.frame.pack();
        this.frame.setSize(970, 600);
        this.frame.setVisible(true);
        ImageIcon img = new ImageIcon(this.getClass().getClassLoader().getResource("jar/logo/jmo256.png"));
        this.frame.setIconImage(img.getImage());
        this.frame.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                App_IDE_Swing.this.actions.actionPerformed(new ActionEvent(this, Lib_Random.getInt(), EVENTS.EXIT.name()));
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        this.addKeyEvents(this.actions);
        this.panel.setFocus();
    }

    private static String[] args(String[] args) {
        block9: {
            int i = 0;
            if (i >= args.length) break block9;
            String s = args[i].trim();
            if (!s.startsWith("-")) {
                String[] args2 = Lib_Array.cutFrom(args, i);
                if (args2.length > 1) {
                    throw new Err_Runtime("Invalid amount of arguments", new Object[0]);
                }
                return args2;
            }
            switch (s) {
                case "--version": {
                    String format = "%1.%2.%3%D";
                    MOut.print("JM\u00b0-IDE  " + VERSION.toFormat("%1.%2.%3%D"));
                    return null;
                }
            }
            throw new Err_Runtime("Unknown argument for JM\u00b0-IDE", s);
        }
        return new String[0];
    }

    private void initInputSource() {
        JMo_Input.setSource(type -> {
            String message = "Please input";
            if (type == Str.class) {
                message = String.valueOf(message) + " a string";
            } else if (type == Int.class) {
                message = String.valueOf(message) + " a integer";
            } else if (type == Dec.class) {
                message = String.valueOf(message) + " a decimal number";
            } else if (type == Bool.class) {
                message = String.valueOf(message) + " true or false";
            }
            return Lib_SwingDialog.input(this.frame, "Input", message, null);
        });
    }

    private void styleUI() {
    }
}

