/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.ide.demo;

import de.mn77.base.data.group.Group4;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.event.Procedure;
import de.mn77.base.sys.Sys;
import de.mn77.base.thread.A_ParallelProcess;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jmo_lang.core.App;
import org.jmo_lang.error.ErrorBaseDebug;
import org.jmo_lang.ide.demo.defs.DemoMainPanel;
import org.jmo_lang.parser.Parser_App;

public class JMoSwingDemo {
    private App runningApp = null;
    private Thread runningThread = null;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new JMoSwingDemo().createAndShowGUI());
    }

    private void createAndShowGUI() {
        Parser_App parser = new Parser_App();
        String version = "JM\u00b0  " + parser.getVersionString(false, true);
        JFrame frame = new JFrame(version);
        frame.setDefaultCloseOperation(3);
        DemoMainPanel panel = new DemoMainPanel(g -> this.execute(parser, (Group4<String, JTextArea, JTextField, Procedure>)g), () -> this.reset());
        frame.add(panel);
        frame.pack();
        frame.setSize(1100, 500);
        frame.setVisible(true);
        ImageIcon img = new ImageIcon(this.getClass().getClassLoader().getResource("jar/logo/jmo256.png"));
        frame.setIconImage(img.getImage());
        int CTRL = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(e -> {
            if (402 != e.getID()) {
                return false;
            }
            if (e.getKeyCode() == 81 && e.getModifiersEx() == CTRL) {
                frame.dispose();
            }
            if (e.getKeyCode() == 10 && e.getModifiersEx() == CTRL) {
                panel.execute();
            }
            return false;
        });
    }

    private void execute(final Parser_App parser, final Group4<String, JTextArea, JTextField, Procedure> g) {
        final String sourcecode = (String)g.o1;
        if (this.runningThread != null) {
            return;
        }
        this.runningThread = new A_ParallelProcess(){

            @Override
            protected void process() {
                block5: {
                    if (JMoSwingDemo.this.runningApp != null) {
                        return;
                    }
                    App app = null;
                    try {
                        app = parser.parseText(">strictWebstart");
                        parser.parseText(app, sourcecode);
                        JMoSwingDemo.this.runningApp = app;
                        ((JTextArea)g.o2).setText("");
                        ((JTextField)g.o3).setText("");
                        app.setOutputRedirection(s -> {
                            ((JTextArea)group4.o2).append((String)s);
                            ((JTextArea)group4.o2).setCaretPosition(((JTextArea)group4.o2).getText().length());
                        });
                        app.setNoHardExit();
                        String result = app.exec(null);
                        if (!app.toBeTerminated()) {
                            ((JTextField)g.o3).setText(result);
                        }
                    }
                    catch (Err_FileSys e) {
                        ((JTextArea)g.o2).setText(e.toString());
                        Err.show(e);
                    }
                    catch (ErrorBaseDebug ce) {
                        if (app == null || app.toBeTerminated()) break block5;
                        ((JTextArea)g.o2).setText(ce.toInfo());
                        Err.show(ce);
                    }
                }
            }

            @Override
            protected void onFinished() {
                ((Procedure)g.o4).execute();
                JMoSwingDemo.this.runningApp = null;
                JMoSwingDemo.this.runningThread = null;
            }
        };
    }

    private void reset() {
        if (this.runningApp != null) {
            this.runningApp.terminate();
        }
        Sys.sleep(100);
        if (this.runningThread != null) {
            this.runningThread.interrupt();
        }
        Sys.sleep(100);
        try {
            if (this.runningThread != null) {
                this.runningThread.stop();
            }
        }
        catch (ThreadDeath threadDeath) {
            // empty catch block
        }
    }
}

