/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.core;

import de.mn77.base.data.search.SearchArray;
import org.jmo_lang.api.SandBox;
import org.jmo_lang.core.App;
import org.jmo_lang.core.Block;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.Type;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ErrorBaseDebug;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Cycle;
import org.jmo_lang.object.JMo_Group;
import org.jmo_lang.object.JMo_Random;
import org.jmo_lang.object.JMo_Range;
import org.jmo_lang.object.JMo_RegEx;
import org.jmo_lang.object.JMo_Use;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.classic.JMo_Break;
import org.jmo_lang.object.classic.JMo_Count;
import org.jmo_lang.object.classic.JMo_Each;
import org.jmo_lang.object.classic.JMo_Echo;
import org.jmo_lang.object.classic.JMo_EchoErr;
import org.jmo_lang.object.classic.JMo_Exit;
import org.jmo_lang.object.classic.JMo_For;
import org.jmo_lang.object.classic.JMo_If;
import org.jmo_lang.object.classic.JMo_IfNot;
import org.jmo_lang.object.classic.JMo_Loop;
import org.jmo_lang.object.classic.JMo_Next;
import org.jmo_lang.object.classic.JMo_Print;
import org.jmo_lang.object.classic.JMo_PrintErr;
import org.jmo_lang.object.classic.JMo_Repeat;
import org.jmo_lang.object.classic.JMo_Return;
import org.jmo_lang.object.classic.JMo_Try;
import org.jmo_lang.object.classic.JMo_Which;
import org.jmo_lang.object.classic.JMo_While;
import org.jmo_lang.object.filesys.JMo_Dir;
import org.jmo_lang.object.filesys.JMo_File;
import org.jmo_lang.object.filesys.JMo_Path;
import org.jmo_lang.object.filesys.JMo_RandomAccessFile;
import org.jmo_lang.object.immute.JMo_Type;
import org.jmo_lang.object.immute.datetime.JMo_Date;
import org.jmo_lang.object.immute.datetime.JMo_DateTime;
import org.jmo_lang.object.immute.datetime.JMo_Time;
import org.jmo_lang.object.pseudo.JMo_Error;
import org.jmo_lang.object.pseudo.NonAtomic;
import org.jmo_lang.object.pseudo.NonAtomicJava;
import org.jmo_lang.object.pseudo.NonAtomicSelf;
import org.jmo_lang.object.struct.JMo_ByteArray;
import org.jmo_lang.object.struct.JMo_FunctionMap;
import org.jmo_lang.object.struct.JMo_KeyValue;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.object.struct.JMo_Makro;
import org.jmo_lang.object.struct.JMo_Map;
import org.jmo_lang.object.struct.JMo_Set;
import org.jmo_lang.object.struct.JMo_Table;
import org.jmo_lang.object.struct.JMo_Tree;
import org.jmo_lang.object.struct.JMo_TreeNode;
import org.jmo_lang.object.sys.JMo_Cmd;
import org.jmo_lang.object.sys.JMo_Input;
import org.jmo_lang.object.sys.JMo_Java;
import org.jmo_lang.object.sys.JMo_Sys;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.BLOCKED;
import org.jmo_lang.tools.ClassFinder;
import org.jmo_lang.tools.Lib_Prefix;

public class ObjectManager {
    private static final String JAVA = "Java";

    public static I_Object createNew(App app, Block current, String name, Call[] args, DebugInfo debugInfo) {
        boolean nameWithPrefix = Lib_Prefix.isNameWithPrefix(name);
        if (name.charAt(0) == 'J' && name.startsWith(JAVA)) {
            if (nameWithPrefix) {
                String javaclass = Lib_Prefix.cutJava(name);
                Call[] pars2 = new Call[]{new Call(current, new Str(javaclass), debugInfo), new Call(current, args == null ? new JMo_List() : new JMo_List(args), debugInfo)};
                return ObjectManager.iJava(app, pars2, debugInfo);
            }
            if (name.length() == JAVA.length()) {
                return ObjectManager.iJava(app, args, debugInfo);
            }
        }
        return ObjectManager.createNew(app, name, nameWithPrefix, args, debugInfo, true);
    }

    private static I_Object createNew(App app, String name, boolean withPrefix, Call[] args, DebugInfo debugInfo, boolean throwError) {
        Class<? extends I_Object> c;
        int n;
        if (!withPrefix) {
            String r;
            String[] stringArray = ATOMIC.ATOMIC_TYPENAMES;
            n = ATOMIC.ATOMIC_TYPENAMES.length;
            int n2 = 0;
            while (n2 < n) {
                r = stringArray[n2];
                if (name.equals(r)) {
                    throw ObjectManager.errorAtomic(name, debugInfo);
                }
                ++n2;
            }
            stringArray = ATOMIC.ABSTRACT_TYPES;
            n = ATOMIC.ABSTRACT_TYPES.length;
            n2 = 0;
            while (n2 < n) {
                r = stringArray[n2];
                if (name.equals(r)) {
                    throw ObjectManager.errorAtomic(name, debugInfo);
                }
                ++n2;
            }
        }
        if ((c = ObjectManager.iGetStaticType(app, name, debugInfo)) != null) {
            return new NonAtomic(c, args);
        }
        String[] stringArray = BLOCKED.TYPE_NAME;
        int n3 = BLOCKED.TYPE_NAME.length;
        n = 0;
        while (n < n3) {
            String block = stringArray[n];
            if (block.equals(name)) {
                throw new ParseError("Invalid type", "Type is private or forbidden: " + name, debugInfo);
            }
            ++n;
        }
        Class<?> c2 = ObjectManager.searchJavaJMoClass(name);
        if (c2 != null) {
            if (I_Object.class.isAssignableFrom(c2)) {
                return new NonAtomic(c2, args);
            }
            return new NonAtomic(SandBox.class, c2, args);
        }
        Type t = app.getType().getType(name);
        if (t != null) {
            return new NonAtomicSelf(t, args);
        }
        if (throwError) {
            throw new ParseError("Unknown type", name, debugInfo);
        }
        return null;
    }

    private static I_Object iJava(App app, Call[] args, DebugInfo debugInfo) {
        app.strict.checkSave(debugInfo, JAVA);
        return new NonAtomicJava(args);
    }

    public static Class<?> searchJavaJMoClass(String search) {
        return ClassFinder.getInstance().searchJMoClass("JMo_" + search);
    }

    private static Class<? extends I_Object> iGetStaticType(App app, String name, DebugInfo debug) {
        switch (name) {
            case "Break": {
                return JMo_Break.class;
            }
            case "Count": {
                return JMo_Count.class;
            }
            case "Each": {
                return JMo_Each.class;
            }
            case "Echo": {
                return JMo_Echo.class;
            }
            case "EchoErr": {
                return JMo_EchoErr.class;
            }
            case "Exit": {
                return JMo_Exit.class;
            }
            case "For": {
                return JMo_For.class;
            }
            case "If": {
                return JMo_If.class;
            }
            case "IfNot": {
                return JMo_IfNot.class;
            }
            case "Loop": {
                return JMo_Loop.class;
            }
            case "Next": {
                return JMo_Next.class;
            }
            case "Print": {
                return JMo_Print.class;
            }
            case "PrintErr": {
                return JMo_PrintErr.class;
            }
            case "Repeat": {
                return JMo_Repeat.class;
            }
            case "Return": {
                return JMo_Return.class;
            }
            case "Try": {
                return JMo_Try.class;
            }
            case "Which": {
                return JMo_Which.class;
            }
            case "While": {
                return JMo_While.class;
            }
            case "Cycle": {
                app.strict.checkSave(debug, "Cycle");
                return JMo_Cycle.class;
            }
            case "Group": {
                return JMo_Group.class;
            }
            case "Random": {
                return JMo_Random.class;
            }
            case "Range": {
                return JMo_Range.class;
            }
            case "RegEx": 
            case "Regex": {
                return JMo_RegEx.class;
            }
            case "Use": {
                return JMo_Use.class;
            }
            case "Type": {
                return JMo_Type.class;
            }
            case "Date": {
                return JMo_Date.class;
            }
            case "DateTime": {
                return JMo_DateTime.class;
            }
            case "Time": {
                return JMo_Time.class;
            }
            case "Dir": {
                app.strict.checkSave(debug, "Dir");
                return JMo_Dir.class;
            }
            case "File": {
                app.strict.checkSave(debug, "File");
                return JMo_File.class;
            }
            case "Path": {
                app.strict.checkSave(debug, "Path");
                return JMo_Path.class;
            }
            case "RandomAccessFile": {
                app.strict.checkSave(debug, "RandomAccessFile");
                return JMo_RandomAccessFile.class;
            }
            case "ByteArray": {
                return JMo_ByteArray.class;
            }
            case "FunctionMap": {
                return JMo_FunctionMap.class;
            }
            case "KeyValue": {
                return JMo_KeyValue.class;
            }
            case "List": {
                return JMo_List.class;
            }
            case "Makro": {
                return JMo_Makro.class;
            }
            case "Map": {
                return JMo_Map.class;
            }
            case "Set": {
                return JMo_Set.class;
            }
            case "Table": {
                return JMo_Table.class;
            }
            case "Tree": {
                return JMo_Tree.class;
            }
            case "TreeNode": {
                return JMo_TreeNode.class;
            }
            case "Error": {
                return JMo_Error.class;
            }
            case "Cmd": {
                app.strict.checkSave(debug, "Cmd");
                return JMo_Cmd.class;
            }
            case "Input": {
                app.strict.checkSave(debug, "Input");
                return JMo_Input.class;
            }
            case "Java": {
                app.strict.checkSave(debug, JAVA);
                return JMo_Java.class;
            }
            case "Sys": {
                return JMo_Sys.class;
            }
        }
        return null;
    }

    private static ErrorBaseDebug errorAtomic(String type, DebugInfo debugInfo) {
        return new ParseError("Atomic types cannot created via typename!", type, debugInfo);
    }

    public static boolean isTypeKnown(CallRuntime cr, String type) {
        if (SearchArray.knows(ATOMIC.ATOMIC_TYPENAMES, type, true) || SearchArray.knows(ATOMIC.ABSTRACT_TYPES, type, true)) {
            return true;
        }
        Type t = cr.getApp().getType().getType(type);
        if (t != null) {
            return true;
        }
        if (type.startsWith("Java_")) {
            String javaType = Lib_Prefix.cutJava(type);
            Class<?> c3 = ClassFinder.getInstance().searchJavaClass(javaType);
            if (c3 != null) {
                return true;
            }
        }
        return ObjectManager.searchJavaJMoClass(type) != null;
    }
}

