/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.swing;

import de.mn77.base.sys.Sys;
import de.mn77.lib.swing.DIALOG_TYPE;
import java.awt.Component;
import java.io.File;
import java.util.function.Consumer;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class Lib_SwingDialog {
    public static void open(Component parent, String startDir, FileFilter filter, Consumer<File> action) {
        Lib_SwingDialog.iFileDialog(parent, startDir, action, true, filter);
    }

    public static void save(Component parent, String startDir, FileFilter filter, Consumer<File> action) {
        Lib_SwingDialog.iFileDialog(parent, startDir, action, false, filter);
    }

    private static void iFileDialog(Component parent, String startDir, Consumer<File> action, boolean open_save, FileFilter filter) {
        int result;
        if (startDir == null) {
            startDir = Sys.getPathHome();
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(new File(startDir));
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileFilter(filter);
        int n = result = open_save ? fileChooser.showOpenDialog(parent) : fileChooser.showSaveDialog(parent);
        if (result == 0) {
            action.accept(fileChooser.getSelectedFile());
        }
    }

    public static void yesOrNo(Component parent, DIALOG_TYPE type, String title, String message, Consumer<Boolean> action) {
        boolean buttons = false;
        int dialogResult = JOptionPane.showConfirmDialog(parent, message, title, 0, type.type);
        action.accept(dialogResult == 0);
    }

    public static void okay(Component parent, DIALOG_TYPE type, String title, String message) {
        int buttons = -1;
        JOptionPane.showConfirmDialog(parent, message, title, -1, type.type);
    }

    public static String input(Component parent, String title, String message, String preset) {
        return (String)JOptionPane.showInputDialog(parent, message, title, 3, null, null, preset);
    }
}

