/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import org.jmo_lang.core.Block;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ErrorBaseDebug;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.pseudo.JMo_Error;
import org.jmo_lang.tools.Lib_Error;

public class Lib_Try {
    public static ObjectCallResult errTry(CallRuntime cr, I_Object o) {
        return cr.argCount() > 0 ? Lib_Try.errTryArg(cr, o) : (cr.getCallBlock() == null ? Lib_Try.errTryStream(cr, o) : Lib_Try.errTryBlock(cr, o));
    }

    public static ObjectCallResult errTryArg(CallRuntime cr, I_Object o) {
        I_Object result = o;
        try {
            result = cr.args(o, I_Object.class)[0];
        }
        catch (CodeError | ParseError e) {
            if (cr.getApp().strict.getLazyErrors()) {
                result = new JMo_Error(e);
            }
            throw e;
        }
        catch (ErrorBaseDebug t) {
            result = new JMo_Error(t);
        }
        return new ObjectCallResult(result, false);
    }

    public static ObjectCallResult errTryBlock(CallRuntime cr, I_Object o) {
        cr.args();
        cr.blockNecessary();
        Call stream = cr.getStream();
        Block block = cr.getCallBlock();
        I_Object result = o;
        if (block != null) {
            try {
                result = block.exec(cr, result);
            }
            catch (ReturnException e) {
                return new ObjectCallResult(e.get(), true);
            }
            catch (CodeError | ParseError e) {
                if (cr.getApp().strict.getLazyErrors()) {
                    result = new JMo_Error(e);
                }
                throw e;
            }
            catch (ErrorBaseDebug t) {
                result = new JMo_Error(t);
            }
        }
        if (stream != null) {
            result = cr.execInit(stream, result);
        }
        return new ObjectCallResult(result, true);
    }

    public static ObjectCallResult errTryStream(CallRuntime cr, I_Object o) {
        cr.args();
        Call stream = cr.getStream();
        I_Object result = o;
        try {
            result = cr.execInit(stream, result);
        }
        catch (CodeError | ParseError e) {
            if (cr.getApp().strict.getLazyErrors()) {
                result = new JMo_Error(e);
            }
            throw e;
        }
        catch (ErrorBaseDebug t) {
            result = new JMo_Error(t);
        }
        return new ObjectCallResult(result, true);
    }

    public static ObjectCallResult errTryUse(CallRuntime cr, I_Object o) {
        boolean showMessage = cr.getApp().isDebug();
        Lib_Error.ifArgs(cr.argCount(), 1, (Integer)1, "Invalid amount of arguments", cr.getDebugInfo());
        Call stream = cr.getStream();
        I_Object result = o;
        try {
            result = cr.execInit(stream, result);
        }
        catch (CodeError | ParseError e) {
            if (cr.getApp().strict.getLazyErrors()) {
                if (showMessage) {
                    new JMo_Error(e).show(cr.copyNil());
                }
                result = cr.argEach(o, 0, new JMo_Error(e), I_Object.class);
            }
            throw e;
        }
        catch (ErrorBaseDebug t) {
            if (showMessage) {
                new JMo_Error(t).show(cr.copyNil());
            }
            result = cr.argEach(o, 0, new JMo_Error(t), I_Object.class);
        }
        return new ObjectCallResult(result, true);
    }

    public static ObjectCallResult errTryCatch(CallRuntime cr, I_Object o) {
        cr.args();
        cr.blockNecessary();
        Call stream = cr.getStream();
        Block block = cr.getCallBlock();
        I_Object result = o;
        if (block != null) {
            try {
                result = block.exec(cr, result);
            }
            catch (ReturnException e) {
                return new ObjectCallResult(e.get(), true);
            }
            catch (CodeError | ParseError e) {
                if (cr.getApp().strict.getLazyErrors()) {
                    result = new JMo_Error(e);
                }
                throw e;
            }
            catch (ErrorBaseDebug t) {
                result = new JMo_Error(t);
            }
        }
        if (stream != null && result instanceof JMo_Error) {
            result = cr.execInit(stream, result);
        }
        return new ObjectCallResult(result, true);
    }
}

