/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.parser.Parser_Script;
import org.jmo_lang.tools.BLOCKED;

public class Lib_Prefix {
    public static String addPrefix(String typename, Parser_Script parser) {
        if (typename.charAt(0) == '_' && parser != null) {
            String currentPrefix = parser.getCurrentPrefix();
            if (currentPrefix == null) {
                throw new ParseError("No prefix set", "For using a type with leading '_', the flag '>prefix' must be set!", parser.getDebugInfo());
            }
            return String.valueOf(currentPrefix) + typename;
        }
        return typename;
    }

    public static boolean isNameWithPrefix(String name) {
        int i = 0;
        while (i < name.length()) {
            if (name.charAt(i) == '_') {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String cutJava(String name) {
        return name.substring(5);
    }

    public static void checkPrefix(String prefix, DebugInfo debug) {
        boolean first = true;
        Object[] objectArray = prefix.toCharArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = objectArray[n2];
            if (first && (c < 'A' || c > 'Z')) {
                throw new ParseError("Invalid prefix!", "A prefix must start with a capital letter: " + prefix, debug);
            }
            first = false;
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                if (c == '_') {
                    throw new ParseError("Invalid prefix!", "A prefix can't contain a underline char. Got: " + prefix, debug);
                }
                throw new ParseError("Invalid prefix!", "Invalid chars in prefix. Got: " + prefix, debug);
            }
            ++n2;
        }
        objectArray = BLOCKED.PREFIX;
        n = BLOCKED.PREFIX.length;
        n2 = 0;
        while (n2 < n) {
            char f = objectArray[n2];
            if (prefix.toLowerCase().equals(f)) {
                throw new ParseError("Invalid prefix!", "The prefix name '" + prefix + "' is currently prohibited.", debug);
            }
            ++n2;
        }
    }
}

