/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser.obj;

import de.mn77.base.data.group.Group2;
import de.mn77.base.data.group.Group3;
import org.jmo_lang.core.Block;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_Number;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Byte;
import org.jmo_lang.object.atom.JMo_Float;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.JMo_Short;
import org.jmo_lang.parser.Parser_Script;
import org.jmo_lang.parser.obj.I_ParseObject;
import org.jmo_lang.tools.Lib_Parser;

public class ParseObj_Number
implements I_ParseObject {
    @Override
    public boolean hits(char c0, Block current, String s) {
        return c0 == '-' || c0 == '+' || c0 >= '0' && c0 <= '9';
    }

    @Override
    public Group2<I_Object, String> parse(Parser_Script parser, Block current, String s) {
        Group3<String, String, Boolean> srd = this.iScan(parser, s);
        String nr = (String)srd.o1;
        String rem = (String)srd.o2;
        boolean hasDot = (Boolean)srd.o3;
        int typeChar = hasDot ? 100 : 105;
        A_Number obj = null;
        try {
            if (rem.length() == 0) {
                obj = hasDot ? new Dec(Double.parseDouble(nr)) : new Int(Integer.parseInt(nr));
                return new Group2<I_Object, String>(obj, rem);
            }
            typeChar = rem.charAt(0);
            switch (typeChar) {
                case 98: {
                    if (hasDot) {
                        throw this.iDecToIntError(parser, nr);
                    }
                    obj = new JMo_Byte(Byte.parseByte(nr));
                    rem = rem.substring(1);
                    break;
                }
                case 115: {
                    if (hasDot) {
                        throw this.iDecToIntError(parser, nr);
                    }
                    obj = new JMo_Short(Short.parseShort(nr));
                    rem = rem.substring(1);
                    break;
                }
                case 105: {
                    if (hasDot) {
                        throw this.iDecToIntError(parser, nr);
                    }
                    obj = new Int(Integer.parseInt(nr));
                    rem = rem.substring(1);
                    break;
                }
                case 108: {
                    if (hasDot) {
                        throw this.iDecToIntError(parser, nr);
                    }
                    obj = new JMo_Long(Long.parseLong(nr));
                    rem = rem.substring(1);
                    break;
                }
                case 102: {
                    obj = new JMo_Float(Float.parseFloat(nr));
                    rem = rem.substring(1);
                    break;
                }
                case 100: {
                    obj = new Dec(Double.parseDouble(nr));
                    rem = rem.substring(1);
                    break;
                }
                default: {
                    obj = hasDot ? new Dec(Double.parseDouble(nr)) : new Int(Integer.parseInt(nr));
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            int typeIdx = "bsilfd".indexOf(typeChar);
            String type = typeIdx == -1 ? "Int" : (new String[]{"Byte", "Short", "Int", "Long", "Float", "Dec"})[typeIdx];
            throw new ParseError("Parsing of number failed", "Invalid or out of range for type <" + type + ">: " + nr, parser.getDebugInfo());
        }
        return new Group2<I_Object, String>(obj, rem);
    }

    private ParseError iDecToIntError(Parser_Script parser, String nr) {
        throw new ParseError("Invalid number", "A integer number has no dot, but got: " + nr, parser.getDebugInfo());
    }

    private Group3<String, String, Boolean> iScan(Parser_Script parser, String nr) {
        String s = nr;
        int len = s.length();
        int c = 32;
        boolean hasUnderline = false;
        boolean hasDot = false;
        boolean afterExp = false;
        boolean afterDot = false;
        int i = 1;
        while (i < len) {
            c = s.charAt(i);
            if (c == 46) {
                if (hasDot) {
                    s = s.substring(0, i);
                    len = s.length();
                    break;
                }
                hasDot = true;
                afterDot = true;
            } else if (c == 95) {
                hasUnderline = true;
            } else if (!(afterDot || c != 101 && c != 69)) {
                afterExp = true;
                hasDot = true;
            } else if (afterExp && (c == 45 || c == 43)) {
                afterExp = false;
            } else {
                afterExp = false;
                afterDot = false;
                if (c < 48 || c > 57) {
                    s = s.substring(0, i);
                    len = s.length();
                    break;
                }
            }
            ++i;
        }
        if (hasDot && s.charAt(s.length() - 1) == '.') {
            hasDot = false;
            s = s.substring(0, s.length() - 1);
            --len;
        }
        if (hasUnderline) {
            s = Lib_Parser.removeUnderlines(s, parser.getDebugInfo());
        }
        return new Group3<String, String, Boolean>(s, nr.substring(len), hasDot);
    }
}

