/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.struct;

import de.mn77.base.data.Lib_Array;
import de.mn77.base.data.constant.position.H_POSITION;
import de.mn77.base.data.constant.position.POSITION;
import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.base.data.form.FormString;
import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.base.error.Err;
import java.util.ArrayList;
import java.util.Collection;
import org.jmo_lang.core.ArgCallBuffer;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.I_AutoBlockDo;
import org.jmo_lang.core.I_AutoBlockList;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.LoopHandle;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.A_Number;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.magic.con.MagicPosition;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.struct.A_Sequence;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.object.struct.JMo_Map;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Exec;
import org.jmo_lang.tools.Lib_Sequence;
import org.jmo_lang.tools.Lib_Type;

public class JMo_Table
extends A_Sequence
implements I_AutoBlockDo,
I_AutoBlockList {
    private I_Table<I_Object> tab;
    private final ArgCallBuffer width;
    private final ArgCallBuffer rows;
    private final ArgCallBuffer fill;
    private ArrayList<I_Object> titles = null;

    public JMo_Table(Call width) {
        this.width = new ArgCallBuffer(1, width);
        this.rows = null;
        this.fill = null;
    }

    public JMo_Table(Call width, Call rows, Call fill) {
        this.width = new ArgCallBuffer(1, width);
        this.rows = new ArgCallBuffer(2, rows);
        this.fill = new ArgCallBuffer(3, fill);
    }

    public JMo_Table(I_Table<I_Object> init_tab) {
        this.tab = init_tab;
        this.width = null;
        this.rows = null;
        this.fill = null;
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.width != null) {
            int w;
            this.width.init(cr, this, A_IntNumber.class);
            if (this.tab != null) {
                Err.invalid(this.tab);
            }
            if ((w = Lib_Convert.getIntValue(cr, this.width.get())) < 1) {
                throw new ExecError(cr, "Invalid table width", "Minimum amount of columns is 1, but got " + w);
            }
            this.tab = new MTable<I_Object>(w);
            if (this.rows != null) {
                int r = Lib_Convert.getIntValue(cr, this.rows.init(cr, this, A_IntNumber.class));
                I_Object f = this.fill.init(cr, this, null);
                int ir = 1;
                while (ir <= r) {
                    MList<I_Object> l = new MList<I_Object>();
                    int iw = 1;
                    while (iw <= w) {
                        l.add(f);
                        ++iw;
                    }
                    this.tab.add((I_Sequence<I_Object>)l);
                    ++ir;
                }
            }
        }
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "getRow": {
                return A_Object.stdResult(this.getRow(cr, false));
            }
            case "getMap": 
            case "getRowMap": {
                return A_Object.stdResult(this.getRow(cr, true));
            }
            case "getCol": 
            case "getColumn": {
                return A_Object.stdResult(this.getColumn(cr));
            }
            case "setTitles": {
                this.iSetTitles(cr);
                return A_Object.stdResult(this);
            }
            case "firstRowTitles": {
                this.iSetFirstRowTitles(cr);
                return A_Object.stdResult(this);
            }
            case "getTitles": {
                return this.iGetTitles(cr);
            }
            case "+": 
            case "add": {
                return A_Object.stdResult(this.add(cr));
            }
            case "addRow": 
            case "addRows": {
                return A_Object.stdResult(this.addRows(cr));
            }
            case "concat": 
            case "++": {
                return A_Object.stdResult(this.concat(cr));
            }
            case "addAll": {
                return A_Object.stdResult(this.addAll(cr));
            }
            case "each": {
                return this.each(cr, false);
            }
            case "eachMap": {
                return this.each(cr, true);
            }
            case "search": {
                return A_Object.stdResult(this.search(cr));
            }
            case "searchFirst": {
                return A_Object.stdResult(this.searchFirst(cr));
            }
            case "width": {
                cr.args();
                return A_Object.stdResult(new Int(this.tab.getWidth()));
            }
            case "sort": {
                return A_Object.stdResult(this.sort(cr));
            }
            case "reverse": {
                return A_Object.stdResult(this.reverse(cr));
            }
            case "rotate": {
                return A_Object.stdResult(this.rotate(cr));
            }
            case "columns": {
                return A_Object.stdResult(this.columns(cr));
            }
            case "rows": {
                return A_Object.stdResult(this.rows(cr));
            }
            case "deleteRow": 
            case "deleteRows": {
                return A_Object.stdResult(this.iDelete(cr));
            }
        }
        return null;
    }

    private ObjectCallResult iGetTitles(CallRuntime cr) {
        return A_Object.stdResult(new JMo_List((ArrayList)this.titles.clone()));
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.each((CallRuntime)cr, (boolean)false).obj;
    }

    @Override
    public ArrayList<I_Object> autoBlockToList(CallRuntime cr) {
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        for (I_Sequence i_Sequence : this.tab) {
            ArrayList<I_Object> row = new ArrayList<I_Object>();
            for (I_Object si : i_Sequence) {
                row.add(si);
            }
            result.add(new JMo_List(row));
        }
        return result;
    }

    public I_Table<I_Object> getInternalObject() {
        return this.tab;
    }

    public ArrayList<I_Object> getInternalColNames() {
        return this.titles;
    }

    @Override
    public String toStringExt(CallRuntime cr) {
        return this.toText(cr, true);
    }

    @Override
    public String toString() {
        return this.toText(null, false);
    }

    @Override
    protected JMo_Table copy(CallRuntime cr) {
        return new JMo_Table((I_Table<I_Object>)this.tab.copy());
    }

    @Override
    protected int sequenceSize() {
        return this.tab.size();
    }

    @Override
    protected boolean sequenceEmpty() {
        return this.tab.isEmpty();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof JMo_Table) {
            I_Table<I_Object> other = ((JMo_Table)obj).tab;
            if (this.tab.size() != other.size() || this.tab.getWidth() != other.getWidth()) {
                return false;
            }
            int y = 1;
            while (y <= this.tab.size()) {
                int x = 1;
                while (x <= this.tab.getWidth()) {
                    if (!this.tab.get(x, y).equals(other.get(x, y))) {
                        return false;
                    }
                    ++x;
                }
                ++y;
            }
            ArrayList<I_Object> otherTitles = ((JMo_Table)obj).titles;
            if (this.titles == null) {
                return otherTitles == null;
            }
            if (otherTitles == null || this.titles.size() != otherTitles.size()) {
                return false;
            }
            int i = 0;
            while (i < this.titles.size()) {
                if (!this.titles.get(i).equals(otherTitles.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equalsLazy(Object obj) {
        return this.equals(obj);
    }

    @Override
    protected I_Object first(CallRuntime cr) {
        cr.args();
        return this.tab.size() == 0 ? Nil.NIL : this.rowToList((I_Sequence)this.tab.get(1));
    }

    @Override
    protected I_Object last(CallRuntime cr) {
        cr.args();
        int len = this.tab.size();
        return len == 0 ? Nil.NIL : this.rowToList((I_Sequence)this.tab.get(len));
    }

    @Override
    protected I_Object sequenceGetPull(CallRuntime cr, boolean lazy) {
        if (cr.argCount() == 1) {
            return this.getRow(cr, false);
        }
        I_Object[] xy = cr.argsVar(this, 2, 2);
        if (xy.length > 2) {
            return this.sequenceDeepGet(cr, xy, 0, lazy);
        }
        int iRow = Lib_Convert.getIntValue(cr, xy[0]);
        int iCol = Lib_Convert.getIntValue(cr, xy[1]);
        if (lazy && (iCol > this.tab.getWidth() || iRow > this.tab.size())) {
            return Nil.NIL;
        }
        Lib_Error.ifNotBetween(cr, 1, this.tab.getWidth(), iCol, "column");
        Lib_Error.ifNotBetween(cr, 1, this.tab.size(), iRow, "row");
        return this.tab.get(iCol, iRow);
    }

    @Override
    protected void sequenceSetPut(CallRuntime cr, boolean lazy) {
        I_Object[] orc = cr.argsVar(this, 2, 2);
        if (orc.length > 3) {
            this.sequenceDeepSet(cr, orc, 1, orc[0], lazy);
            return;
        }
        int row = Lib_Convert.getIntValue(cr, orc[1]);
        int col = Lib_Convert.getIntValue(cr, orc[2]);
        if (lazy) {
            while (this.tab.size() < row) {
                MList newRow = new MList();
                int i = 1;
                while (i <= this.tab.getWidth()) {
                    newRow.add(Nil.NIL);
                    ++i;
                }
                this.tab.add(newRow);
            }
            if (col > this.tab.getWidth()) {
                throw new ExecError(cr, "Can't add columns to Table", "Table has a fixed width, so I can't add/access column " + col);
            }
        }
        this.tab.set(col, row, orc[0]);
    }

    @Override
    public I_Object sequenceDeepGet(CallRuntime cr, I_Object[] keys, int offset, boolean lazy) {
        A_IntNumber oi = (A_IntNumber)cr.argType(keys[offset], A_IntNumber.class);
        int i = Lib_Convert.getIntValue(cr, oi);
        int pos = Lib_Sequence.realPos(cr, i, this.tab.size(), lazy);
        if (pos == -1 || pos > this.tab.size()) {
            if (lazy) {
                return Nil.NIL;
            }
            Lib_Error.ifNotBetween(cr, 1, this.tab.size(), pos, "position in list");
        }
        if (offset == keys.length - 1) {
            I_Sequence it = (I_Sequence)this.tab.get(pos);
            return this.rowToList(it);
        }
        I_Sequence it = (I_Sequence)this.tab.get(pos);
        I_Object deeper = this.rowToList(it);
        if (!(deeper instanceof A_Sequence)) {
            throw new ExecError(cr, "Invalid type of item.", "Item " + (offset + 1) + " isn't a sequence, so I can't go into it!");
        }
        A_Sequence deeper2 = (A_Sequence)deeper;
        return deeper2.sequenceDeepGet(cr, keys, offset + 1, lazy);
    }

    @Override
    public void sequenceDeepSet(CallRuntime cr, I_Object[] keys, int offset, I_Object value, boolean lazy) {
        A_IntNumber oiy = (A_IntNumber)cr.argType(keys[offset], A_IntNumber.class);
        int wantedY = Lib_Convert.getIntValue(cr, oiy);
        int posY = Lib_Sequence.realPos(cr, wantedY, this.tab.size(), lazy);
        if (lazy) {
            while ((posY = Lib_Sequence.realPos(cr, wantedY, this.tab.size(), lazy)) == -1) {
                MList<Nil> emptyRow = new MList<Nil>();
                int i = 1;
                while (i <= this.tab.getWidth()) {
                    emptyRow.add(Nil.NIL);
                    ++i;
                }
                this.tab.add((I_Sequence<I_Object>)emptyRow);
            }
        }
        Lib_Error.ifNotBetween(cr, 1, this.tab.size(), posY, "row");
        if (keys.length - offset == 1) {
            if (!Lib_Type.typeIs(cr, value, JMo_List.class)) {
                throw new ExecError(cr, "Invalid type of value", "Value must be a List");
            }
            JMo_List valueList = (JMo_List)value;
            Collection valueArrayList = valueList.getInternalCollection();
            Lib_Error.ifNot(cr, this.tab.getWidth(), ((ArrayList)valueArrayList).size(), "row-size");
            int col = 1;
            while (col <= this.tab.getWidth()) {
                this.tab.set(col, posY, (I_Object)((ArrayList)valueArrayList).get(col - 1));
                ++col;
            }
            return;
        }
        A_IntNumber oix = (A_IntNumber)cr.argType(keys[offset + 1], A_IntNumber.class);
        int wantedX = Lib_Convert.getIntValue(cr, oix);
        int posX = Lib_Sequence.realPos(cr, wantedX, this.tab.size(), lazy);
        Lib_Error.ifNotBetween(cr, 1, this.tab.getWidth(), wantedX, "column");
        if (offset == keys.length - 2) {
            this.tab.set(posX, posY, value);
        } else {
            I_Object deeper = this.tab.get(posX, posY);
            if (deeper == Nil.NIL && lazy) {
                deeper = new JMo_List();
                this.tab.set(posX, posY, deeper);
            }
            if (!(deeper instanceof A_Sequence)) {
                throw new ExecError(cr, "Invalid type of item.", "Item " + (offset + 1) + " isn't a sequence, so I can't go into it!");
            }
            A_Sequence deeper2 = (A_Sequence)deeper;
            deeper2.sequenceDeepSet(cr, keys, offset + 2, value, lazy);
        }
    }

    @Override
    protected I_Object sequenceSelectGet(CallRuntime cr, I_Object key, boolean lazy) {
        int oi = Lib_Convert.getIntValue(cr, key);
        int pos = Lib_Sequence.realPos(cr, oi, this.tab.size(), lazy);
        return pos == -1 ? Nil.NIL : this.rowToList(this.tab.getRow(pos));
    }

    private String toText(CallRuntime cr, boolean debug) {
        if (this.tab == null) {
            return "Table";
        }
        boolean[][] right = new boolean[this.tab.getWidth()][this.tab.size()];
        MTable<String> otab = new MTable<String>(this.tab.getWidth());
        int y = 0;
        for (I_Sequence i_Sequence : this.tab) {
            String[] sa = new String[i_Sequence.size()];
            int x = 0;
            while (x < sa.length) {
                I_Object o = (I_Object)i_Sequence.get(x + 1);
                right[x][y] = o instanceof A_Number;
                sa[x] = o == null ? "null" : (debug ? o.toStringExt(cr) : o.toString());
                ++x;
            }
            otab.add(sa);
            ++y;
        }
        int[] nArray = new int[this.tab.getWidth()];
        int spalte = 1;
        while (spalte <= this.tab.getWidth()) {
            int max = 0;
            int zeile = 1;
            while (zeile <= this.tab.size()) {
                max = Math.max(max, ((String)otab.get(spalte, zeile)).length());
                ++zeile;
            }
            nArray[spalte - 1] = max;
            ++spalte;
        }
        StringBuilder sb = new StringBuilder();
        y = 0;
        for (I_Sequence zeile : otab) {
            int spalte2 = 1;
            while (spalte2 <= this.tab.getWidth()) {
                String o = (String)zeile.get(spalte2);
                H_POSITION.H pos = right[spalte2 - 1][y] ? POSITION_H.RIGHT : POSITION_H.LEFT;
                sb.append(FormString.width(nArray[spalte2 - 1], ' ', o, pos, false));
                if (spalte2 != this.tab.getWidth()) {
                    sb.append('|');
                }
                ++spalte2;
            }
            if (++y >= this.tab.size()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    private JMo_Table add(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        if (args.length != this.tab.getWidth()) {
            throw new ExecError(cr, "Invalid amount of items to add.", "Width of table is " + this.tab.getWidth() + ", but got " + cr.argCount() + " items.");
        }
        this.tab.add((I_Object[])args);
        return this;
    }

    private JMo_Table addRows(CallRuntime cr) {
        I_Object[] args;
        I_Object[] i_ObjectArray = args = cr.argsVar(this, 1, 1);
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            JMo_List pl = (JMo_List)cr.argType(arg, JMo_List.class);
            Collection list = pl.getInternalCollection();
            if (((ArrayList)list).size() != this.tab.getWidth()) {
                throw new ExecError(cr, "Invalid size of row", "Table width is " + this.tab.getWidth() + ", but should add a row with " + ((ArrayList)list).size() + " items.");
            }
            I_Object[] row = ((ArrayList)list).toArray(new I_Object[((ArrayList)list).size()]);
            this.tab.add((I_Object[])row);
            ++n2;
        }
        return this;
    }

    private JMo_Table concat(CallRuntime cr) {
        JMo_Table tab2 = (JMo_Table)cr.args(this, JMo_Table.class)[0];
        MTable<I_Object> newTab = new MTable<I_Object>(this.tab.getWidth());
        this.tab.forEach(a -> newTab.add((I_Sequence<I_Object>)a));
        tab2.getInternalObject().forEach(a -> newTab.add((I_Sequence<I_Object>)a));
        return new JMo_Table(newTab);
    }

    private JMo_Table addAll(CallRuntime cr) {
        JMo_Table tab2 = (JMo_Table)cr.args(this, JMo_Table.class)[0];
        tab2.getInternalObject().forEach(a -> this.tab.add((I_Sequence<I_Object>)a));
        return this;
    }

    private ObjectCallResult each(CallRuntime crOld, boolean map) {
        crOld.args();
        if (crOld.getStream() == null && crOld.getCallBlock() == null) {
            Err.impossible("No block, no stream, what should I do?");
        }
        LoopHandle handle = new LoopHandle(this);
        CallRuntime crNew = crOld.copyLoop(handle);
        I_Object result = Nil.NIL;
        for (I_Sequence i_Sequence : this.tab) {
            handle.startLap();
            I_Object itO = map ? this.rowToMap(i_Sequence) : this.rowToList(i_Sequence);
            result = Lib_Exec.execBlockStream(crNew, itO);
            result = Lib_Exec.loopResult(result);
            if (!(result instanceof Return)) continue;
            return ((Return)result).getLoopResult();
        }
        return new ObjectCallResult(result, true);
    }

    private I_Object getRow(CallRuntime cr, boolean map) {
        I_Object y = cr.args(this, A_IntNumber.class)[0];
        int iy = Lib_Convert.getIntValue(cr, y);
        Lib_Error.ifNotBetween(cr, 1, this.tab.size(), iy, "row");
        I_Sequence it = (I_Sequence)this.tab.get(iy);
        return map ? this.rowToMap(it) : this.rowToList(it);
    }

    private I_Object getColumn(CallRuntime cr) {
        I_Object x = cr.args(this, A_IntNumber.class)[0];
        int ix = Lib_Convert.getIntValue(cr, x);
        Lib_Error.ifNotBetween(cr, 1, this.tab.getWidth(), ix, "column");
        return this.rowToList(this.tab.getCol(ix));
    }

    private I_Object rowToList(I_Sequence<I_Object> it) {
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        for (I_Object item : it) {
            al.add(item);
        }
        return new JMo_List(al);
    }

    private I_Object rowToMap(I_Sequence<I_Object> it) {
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        for (I_Object item : it) {
            al.add(item);
        }
        if (this.titles != null) {
            return new JMo_Map(this.titles, al);
        }
        ArrayList<I_Object> t2 = new ArrayList<I_Object>();
        int col = 1;
        while (col <= this.tab.getWidth()) {
            t2.add(new Int(col));
            ++col;
        }
        return new JMo_Map(t2, al);
    }

    private JMo_Table search(CallRuntime cr) {
        I_AtomicValue searcho = (I_AtomicValue)cr.args(this, I_AtomicValue.class)[0];
        String search = Lib_Convert.getStringValue(cr, searcho);
        MTable<I_Object> res = new MTable<I_Object>(this.tab.getWidth());
        int y = 1;
        while (y <= this.tab.size()) {
            boolean add = false;
            int x = 1;
            while (x <= this.tab.getWidth()) {
                I_Object o = this.tab.get(x, y);
                String s = Lib_Convert.getStringValue(cr, o);
                if (s.equals(search)) {
                    add = true;
                    break;
                }
                ++x;
            }
            if (add) {
                I_Sequence row = (I_Sequence)this.tab.get(y);
                res.add(row);
            }
            ++y;
        }
        return new JMo_Table(res);
    }

    private I_Object searchFirst(CallRuntime cr) {
        I_AtomicValue searcho = (I_AtomicValue)cr.args(this, I_AtomicValue.class)[0];
        String search = Lib_Convert.getStringValue(cr, searcho);
        int y = 1;
        while (y <= this.tab.size()) {
            int x = 1;
            while (x <= this.tab.getWidth()) {
                I_Object o = this.tab.get(x, y);
                String s = Lib_Convert.getStringValue(cr, o);
                if (s.equals(search)) {
                    I_Sequence row = (I_Sequence)this.tab.get(y);
                    ArrayList<I_Object> row2 = new ArrayList<I_Object>();
                    for (I_Object item : row) {
                        row2.add(item);
                    }
                    return new JMo_List(row2);
                }
                ++x;
            }
            ++y;
        }
        return Nil.NIL;
    }

    private I_Object sort(CallRuntime cr) {
        int tabWidth;
        I_Object[] args = cr.argsVar(this, 0, 0);
        int parLen = args.length;
        if (parLen > (tabWidth = this.tab.getWidth())) {
            throw new ExecError(cr, "Too much parameters", "This table has only " + tabWidth + " colums. Got " + parLen + " columns to sort.");
        }
        int[] colOrder = new int[parLen];
        int i = 0;
        while (i < parLen) {
            colOrder[i] = Lib_Convert.getIntValue(cr, cr.argType(args[i], A_IntNumber.class));
            ++i;
        }
        int[] nArray = colOrder;
        int n = colOrder.length;
        int n2 = 0;
        while (n2 < n) {
            i = nArray[n2];
            Lib_Error.ifNotBetween(cr, 1, this.tab.getWidth(), Math.abs(i), "column");
            ++n2;
        }
        this.tab.sort(colOrder);
        return this;
    }

    private I_Object reverse(CallRuntime cr) {
        cr.args();
        int size = this.tab.size();
        int[] order = new int[size];
        int i = 0;
        while (i < size) {
            order[i] = size - i;
            ++i;
        }
        this.tab.sortLike(order);
        return this;
    }

    private I_Object rotate(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 0, 1);
        MTable<I_Object> newTab = new MTable<I_Object>(this.tab.size());
        POSITION_H dir = POSITION_H.RIGHT;
        if (args.length == 1) {
            POSITION p = ((MagicPosition)cr.argType(args[0], MagicPosition.class)).get();
            if (p != POSITION.LEFT && p != POSITION.RIGHT) {
                throw new ExecError(cr, "Invalid direction", "The table can only rotate to _LEFT and _RIGHT.");
            }
            dir = (POSITION_H)((Object)p);
        }
        if (dir == POSITION_H.LEFT) {
            int col = this.tab.getWidth();
            while (col >= 1) {
                newTab.add((I_Sequence<I_Object>)this.tab.getCol(col));
                --col;
            }
        } else {
            int col = 1;
            while (col <= this.tab.getWidth()) {
                I_List<I_Object> row = this.tab.getCol(col);
                row.reverse();
                newTab.add((I_Sequence<I_Object>)row);
                ++col;
            }
        }
        return new JMo_Table(newTab);
    }

    private JMo_Table columns(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        int parLen = args.length;
        int[] parsi = new int[parLen];
        int i = 0;
        while (i < parLen) {
            parsi[i] = Lib_Convert.getIntValue(cr, cr.argType(args[i], A_IntNumber.class));
            ++i;
        }
        MTable<I_Object> newTab = new MTable<I_Object>(parLen);
        int row = 1;
        while (row <= this.tab.size()) {
            I_Object[] items = new I_Object[parLen];
            int i2 = 0;
            while (i2 < parLen) {
                items[i2] = this.tab.get(parsi[i2], row);
                ++i2;
            }
            newTab.add((I_Object[])items);
            ++row;
        }
        return new JMo_Table(newTab);
    }

    private JMo_Table rows(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        MTable<I_Object> newTab = new MTable<I_Object>(this.tab.getWidth());
        I_Object[] i_ObjectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            int parRow = Lib_Convert.getIntValue(cr, cr.argType(arg, A_IntNumber.class));
            newTab.add((I_Sequence<I_Object>)this.tab.getRow(parRow));
            ++n2;
        }
        return new JMo_Table(newTab);
    }

    private JMo_Table iDelete(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        int len = args.length;
        int[] rows = new int[len];
        int i = 0;
        while (i < len) {
            rows[i] = Lib_Convert.getIntValue(cr, args[i]);
            ++i;
        }
        Integer duplicate = Lib_Array.getNextDuplicate(rows);
        if (duplicate != null) {
            throw new ExecError(cr, "Duplicated row position", "Same row can't removed twice: " + duplicate);
        }
        Lib_Array.sortGnome(rows, true);
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            Lib_Error.ifNotBetween(cr, 1, this.tab.size(), row, "row");
            this.tab.remove(row);
            ++n2;
        }
        return this;
    }

    private void iSetTitles(CallRuntime cr) {
        JMo_List arg = (JMo_List)cr.args(this, JMo_List.class)[0];
        this.setTitles(cr, (ArrayList<I_Object>)arg.getInternalCollection());
    }

    private void iSetFirstRowTitles(CallRuntime cr) {
        cr.args();
        if (this.tab.size() == 0) {
            throw new ExecError(cr, "Invalid amount of rows", "The table must contain at least one row to be set as titles.");
        }
        I_List<I_Object> row1 = this.tab.remove(1);
        ArrayList<I_Object> headers = new ArrayList<I_Object>(row1.size());
        headers.addAll(row1);
        this.setTitles(cr, headers);
    }

    public void setTitles(CallRuntime cr, ArrayList<I_Object> titles) {
        if (titles.size() != this.tab.getWidth()) {
            throw new ExecError(cr, "Invalid amount of titles for table", "Column count is " + this.tab.getWidth() + ", but got " + titles.size() + " titles.");
        }
        this.titles = titles;
    }

    @Override
    protected void sequenceSet(CallRuntime cr, I_Object key, I_Object value, boolean lazy) {
        Collection cols = ((JMo_List)cr.argType(value, JMo_List.class)).getInternalCollection();
        int row = Lib_Convert.getIntValue(cr, key);
        if (lazy) {
            while (this.tab.size() < row) {
                MList newRow = new MList();
                int i = 1;
                while (i <= this.tab.getWidth()) {
                    newRow.add(Nil.NIL);
                    ++i;
                }
                this.tab.add(newRow);
            }
        }
        Lib_Error.ifNotBetween(cr, 1, this.tab.size(), row, "row");
        Lib_Error.ifNotBetween(cr, 1, this.tab.getWidth(), ((ArrayList)cols).size(), "columns");
        int col = 1;
        while (col <= this.tab.getWidth()) {
            this.tab.set(col, row, (I_Object)((ArrayList)cols).get(col - 1));
            ++col;
        }
    }

    @Override
    protected Collection<? extends I_Object> getInternalCollection() {
        throw Err.impossible(new Object[0]);
    }
}

