/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.struct;

import de.mn77.base.error.Err;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import org.jmo_lang.core.ArgCallBuffer;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.LoopHandle;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.I_Integer;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Byte;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.JMo_Short;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.struct.A_Sequence;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Exec;
import org.jmo_lang.tools.Lib_Sequence;

public class JMo_ByteArray
extends A_Sequence {
    private byte[] data;
    private final ArgCallBuffer arg1;

    public JMo_ByteArray(byte[] ba) {
        this.data = ba;
        this.arg1 = null;
    }

    public JMo_ByteArray(int size) {
        this.data = new byte[size];
        this.arg1 = null;
    }

    public JMo_ByteArray(Call arg) {
        this.arg1 = new ArgCallBuffer(1, arg);
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.arg1 != null) {
            I_Object a1 = this.arg1.init(cr, this, A_IntNumber.class);
            int size = Lib_Convert.getIntValue(cr, a1);
            this.data = new byte[size];
        }
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "toList": {
                return A_Object.stdResult(this.toList(cr));
            }
            case "toByte": {
                return A_Object.stdResult(this.toIntNumber(cr, 1));
            }
            case "toShort": {
                return A_Object.stdResult(this.toIntNumber(cr, 2));
            }
            case "toInt": {
                return A_Object.stdResult(this.toIntNumber(cr, 4));
            }
            case "toLong": {
                return A_Object.stdResult(this.toIntNumber(cr, 8));
            }
            case "toStrUTF8": {
                return A_Object.stdResult(this.toStr(cr, StandardCharsets.UTF_8));
            }
            case "toStrUTF16": {
                return A_Object.stdResult(this.toStr(cr, StandardCharsets.UTF_16));
            }
            case "toStrASCII": {
                return A_Object.stdResult(this.toStr(cr, StandardCharsets.US_ASCII));
            }
            case "fill": {
                this.iFill(cr);
                return A_Object.stdResult(this);
            }
            case "cut": {
                return A_Object.stdResult(this.cut(cr));
            }
            case "area": {
                return A_Object.stdResult(this.area(cr));
            }
            case "left": {
                return A_Object.stdResult(this.left(cr));
            }
            case "right": {
                return A_Object.stdResult(this.right(cr));
            }
            case "start": {
                return A_Object.stdResult(this.startPos(cr));
            }
            case "end": {
                return A_Object.stdResult(this.endPos(cr));
            }
            case "expandLeft": {
                return A_Object.stdResult(this.iExpand(cr, false));
            }
            case "expandRight": {
                return A_Object.stdResult(this.iExpand(cr, true));
            }
            case "append": 
            case "+": 
            case "add": {
                return A_Object.stdResult(this.add(cr));
            }
            case "delete": 
            case "-": {
                return A_Object.stdResult(this.removePos(cr));
            }
            case "insert": {
                return A_Object.stdResult(this.insert(cr));
            }
            case "begin": {
                return A_Object.stdResult(this.begin(cr));
            }
            case "concat": 
            case "++": {
                return A_Object.stdResult(this.concat(cr));
            }
            case "has": 
            case "knows": {
                return A_Object.stdResult(this.knows(cr));
            }
            case "search": 
            case "searchFirst": {
                return A_Object.stdResult(this.search(cr, true));
            }
            case "searchLast": {
                return A_Object.stdResult(this.search(cr, false));
            }
            case "each": {
                return this.each(cr);
            }
        }
        return null;
    }

    private I_Object iExpand(CallRuntime cr, boolean right) {
        Int arg = (Int)cr.args(this, Int.class)[0];
        int toAdd = arg.getValue();
        Lib_Error.ifTooSmall(cr, 1L, toAdd);
        byte[] baNew = new byte[this.data.length + toAdd];
        int destPos = right ? 0 : toAdd;
        System.arraycopy(this.data, 0, baNew, destPos, this.data.length);
        return new JMo_ByteArray(baNew);
    }

    private JMo_ByteArray add(CallRuntime cr) {
        I_Object[] oa = cr.argsVar(this, 1, 0);
        byte[] baNew = new byte[this.data.length + oa.length];
        System.arraycopy(this.data, 0, baNew, 0, this.data.length);
        int i = 0;
        while (i < oa.length) {
            byte b;
            baNew[this.data.length + i] = b = ((JMo_Byte)cr.argType(oa[i], JMo_Byte.class)).getValue().byteValue();
            ++i;
        }
        return new JMo_ByteArray(baNew);
    }

    private JMo_ByteArray removePos(CallRuntime cr) {
        Int o = (Int)cr.args(this, Int.class)[0];
        int oi = Lib_Convert.getIntValue(cr, o);
        Lib_Error.ifNotBetween(cr, 1, this.data.length, oi, "position");
        byte[] baNew = new byte[this.data.length - 1];
        if (oi > 1) {
            System.arraycopy(this.data, 0, baNew, 0, oi - 1);
        }
        if (oi < this.data.length) {
            System.arraycopy(this.data, oi, baNew, oi - 1, this.data.length - oi);
        }
        return new JMo_ByteArray(baNew);
    }

    private JMo_ByteArray insert(CallRuntime cr) {
        I_Object[] oa = cr.args(this, JMo_Byte.class, A_IntNumber.class);
        int pos = Lib_Convert.getIntValue(cr, oa[1]);
        byte val = ((JMo_Byte)oa[0]).getValue();
        int len = this.data.length;
        Lib_Error.ifIs(cr, 0, pos, "position");
        Lib_Error.ifOutOfBounds(cr, len + 1, pos, "position");
        if (pos < 0) {
            pos = Lib_Sequence.realPos(cr, pos, len, false) + 1;
        }
        byte[] baNew = new byte[len + 1];
        baNew[pos - 1] = val;
        if (pos > 1) {
            System.arraycopy(this.data, 0, baNew, 0, pos - 1);
        }
        if (pos <= this.data.length) {
            System.arraycopy(this.data, pos - 1, baNew, pos, this.data.length - pos + 1);
        }
        return new JMo_ByteArray(baNew);
    }

    private JMo_ByteArray begin(CallRuntime cr) {
        byte b = ((JMo_Byte)cr.args(this, JMo_Byte.class)[0]).getValue();
        int len = this.data.length;
        byte[] baNew = new byte[len + 1];
        baNew[0] = b;
        System.arraycopy(this.data, 0, baNew, 1, len);
        return new JMo_ByteArray(baNew);
    }

    private JMo_ByteArray concat(CallRuntime cr) {
        byte[] data2 = ((JMo_ByteArray)cr.args((I_Object)this, new Class[]{JMo_ByteArray.class})[0]).data;
        byte[] baNew = new byte[this.data.length + data2.length];
        System.arraycopy(this.data, 0, baNew, 0, this.data.length);
        System.arraycopy(data2, 0, baNew, this.data.length, data2.length);
        return new JMo_ByteArray(baNew);
    }

    public Bool knows(CallRuntime cr) {
        byte b = ((JMo_Byte)cr.args(this, JMo_Byte.class)[0]).getValue();
        byte[] byArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            byte lo = byArray[n2];
            if (lo == b) {
                return Bool.TRUE;
            }
            ++n2;
        }
        return Bool.FALSE;
    }

    public I_Atomic search(CallRuntime cr, boolean first) {
        byte search = ((JMo_Byte)cr.args(this, JMo_Byte.class)[0]).getValue();
        if (first) {
            int i = 0;
            while (i < this.data.length) {
                if (this.data[i] == search) {
                    return new Int(i + 1);
                }
                ++i;
            }
        } else {
            int i = this.data.length - 1;
            while (i >= 0) {
                if (this.data[i] == search) {
                    return new Int(i + 1);
                }
                --i;
            }
        }
        return Nil.NIL;
    }

    private void iFill(CallRuntime cr) {
        JMo_Byte arg = (JMo_Byte)cr.args(this, JMo_Byte.class)[0];
        byte b = Lib_Convert.getByteValue(cr, arg);
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = b;
            ++i;
        }
    }

    private JMo_ByteArray startPos(CallRuntime cr) {
        I_Object arg = cr.args(this, Int.class)[0];
        int start = ((Int)arg).getValue();
        int end = this.data.length;
        Lib_Error.ifNotBetween(cr, 1, end, start, "position");
        return this.iCutCopy(cr, start, end);
    }

    private JMo_ByteArray endPos(CallRuntime cr) {
        I_Object arg = cr.args(this, Int.class)[0];
        int end = ((Int)arg).getValue();
        Lib_Error.ifNotBetween(cr, 1, this.data.length, end, "position");
        return this.iCutCopy(cr, 1, end);
    }

    private JMo_ByteArray cut(CallRuntime cr) {
        I_Object[] oa = cr.args(this, Int.class, Int.class);
        int start = ((Int)oa[0]).getValue();
        int len = ((Int)oa[1]).getValue();
        Lib_Error.ifEmpty(cr, this.data.length, "List");
        Lib_Error.ifNotBetween(cr, 1, this.data.length, start, "start");
        if (len == 0) {
            return new JMo_ByteArray(new byte[0]);
        }
        if (len > this.data.length) {
            len = this.data.length - start + 1;
        }
        return this.iCutCopy(cr, start, Math.min(this.data.length, start + len - 1));
    }

    private JMo_ByteArray area(CallRuntime cr) {
        I_Object[] oa = cr.args(this, Int.class, Int.class);
        int start = ((Int)oa[0]).getValue();
        int end = ((Int)oa[1]).getValue();
        int size = this.data.length;
        Lib_Error.ifEmpty(cr, this.data.length, "ByteArray");
        Lib_Error.ifNotBetween(cr, 1, Math.min(end, size), start, "start");
        Lib_Error.ifNotBetween(cr, Math.max(1, start), size, end, "end");
        return this.iCutCopy(cr, start, Math.min(this.data.length, end));
    }

    private JMo_ByteArray left(CallRuntime cr) {
        I_Object o = cr.args(this, Int.class)[0];
        int left = ((Int)o).getValue();
        Lib_Error.ifNotBetween(cr, 1, this.data.length, left, "length");
        return this.iCutCopy(cr, 1, Math.min(left, this.data.length));
    }

    private JMo_ByteArray right(CallRuntime cr) {
        I_Object o = cr.args(this, Int.class)[0];
        int right = ((Int)o).getValue();
        Lib_Error.ifNotBetween(cr, 1, this.data.length, right, "length");
        return this.iCutCopy(cr, Math.max(1, this.data.length - right + 1), this.data.length);
    }

    private ObjectCallResult each(CallRuntime crOld) {
        crOld.args();
        if (crOld.getStream() == null && crOld.getCallBlock() == null) {
            throw new CodeError(crOld, "No Stream or Block for 'each'", null);
        }
        LoopHandle handle = new LoopHandle(this);
        CallRuntime crNew = crOld.copyLoop(handle);
        I_Object result = this;
        byte[] byArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            byte it = byArray[n2];
            handle.startLap();
            result = Lib_Exec.execBlockStream(crNew, new JMo_Byte(it));
            result = Lib_Exec.loopResult(result);
            if (result instanceof Return) {
                return ((Return)result).getLoopResult();
            }
            ++n2;
        }
        return new ObjectCallResult(result, true);
    }

    private JMo_List toList(CallRuntime cr) {
        cr.args();
        ArrayList<I_Object> list = new ArrayList<I_Object>();
        byte[] byArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            list.add(new JMo_Byte(element));
            ++n2;
        }
        return new JMo_List(list);
    }

    private A_IntNumber toIntNumber(CallRuntime cr, int bytes) {
        cr.args();
        Lib_Error.ifNot(cr, bytes, this.data.length, "length");
        switch (bytes) {
            case 1: {
                return new JMo_Byte(this.data[0]);
            }
            case 2: {
                short vs = this.data[1];
                vs = (short)(vs + (this.data[0] << 8));
                return new JMo_Short(vs);
            }
            case 4: {
                int vi = this.data[3];
                vi += this.data[2] << 8;
                vi += this.data[1] << 16;
                return new Int(vi += this.data[0] << 24);
            }
            case 8: {
                int vl = this.data[7];
                vl += this.data[6] << 8;
                vl += this.data[5] << 16;
                vl += this.data[4] << 24;
                vl += this.data[3] << 32;
                vl += this.data[2] << 40;
                vl += this.data[1] << 48;
                return new JMo_Long(vl += this.data[0] << 56);
            }
        }
        throw Err.impossible(bytes);
    }

    public byte[] getValue() {
        return this.data;
    }

    private Str toStr(CallRuntime cr, Charset cs) {
        cr.args();
        return new Str(new String(this.data, cs));
    }

    @Override
    public String toString() {
        return "ByteArray(" + this.data.length + ")";
    }

    @Override
    public String toStringExt(CallRuntime cr) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.toString());
        sb.append('[');
        byte[] byArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            sb.append(element);
            sb.append(",");
            ++n2;
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(']');
        return sb.toString();
    }

    @Override
    protected int sequenceSize() {
        return this.data.length;
    }

    @Override
    protected boolean sequenceEmpty() {
        return this.data.length == 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof JMo_ByteArray) {
            byte[] other = ((JMo_ByteArray)obj).data;
            if (this.data.length != other.length) {
                return false;
            }
            int i = 0;
            while (i < this.data.length) {
                if (this.data[i] != other[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equalsLazy(Object obj) {
        return this.equals(obj);
    }

    @Override
    protected I_Object first(CallRuntime cr) {
        return new JMo_Byte(this.data[0]);
    }

    @Override
    protected I_Object last(CallRuntime cr) {
        return new JMo_Byte(this.data[this.data.length - 1]);
    }

    @Override
    protected A_Sequence copy(CallRuntime cr) {
        int len = this.data.length;
        byte[] copy = new byte[len];
        System.arraycopy(this.data, 0, copy, 0, len);
        return new JMo_ByteArray(copy);
    }

    @Override
    protected I_Object sequenceGetPull(CallRuntime cr, boolean lazy) {
        I_Object[] oa = cr.argsVar(this, 1, 0);
        if (oa.length == 1) {
            I_AtomicValue oav = (I_AtomicValue)cr.argType(oa[0], I_AtomicValue.class);
            int oi = Lib_Convert.getIntValue(cr, oav);
            int pos = Lib_Sequence.realPos(cr, oi, this.data.length, lazy);
            return pos == -1 ? Nil.NIL : new JMo_Byte(this.data[pos - 1]);
        }
        return this.sequenceDeepGet(cr, oa, 0, lazy);
    }

    @Override
    protected void sequenceSet(CallRuntime cr, I_Object posObj, I_Object obj, boolean lazy) {
        int posWanted = Lib_Convert.getIntValue(cr, posObj);
        cr.argType(obj, JMo_Byte.class);
        byte value = Lib_Convert.getByteValue(cr, obj);
        if (lazy && Math.abs(posWanted) > this.data.length) {
            throw new ExecError(cr, "Fixed ByteArray can't expanded!", "");
        }
        int posReal = Lib_Sequence.realPos(cr, posWanted, this.data.length, lazy);
        Lib_Error.ifNotBetween(cr, 1, this.data.length, posReal, "position");
        this.data[posReal - 1] = value;
    }

    @Override
    protected void sequenceSetPut(CallRuntime cr, boolean lazy) {
        I_Object[] oa = cr.args(this, JMo_Byte.class, I_Integer.class);
        this.sequenceSet(cr, oa[1], oa[0], lazy);
    }

    @Override
    protected I_Object sequenceSelectGet(CallRuntime cr, I_Object key, boolean lazy) {
        int oi = Lib_Convert.getIntValue(cr, key);
        int pos = Lib_Sequence.realPos(cr, oi, this.data.length, lazy);
        return pos == -1 ? Nil.NIL : new JMo_Byte(this.data[pos - 1]);
    }

    @Override
    public I_Object sequenceDeepGet(CallRuntime cr, I_Object[] keys, int offset, boolean lazy) {
        throw Err.invalid(keys, offset, lazy);
    }

    @Override
    public void sequenceDeepSet(CallRuntime cr, I_Object[] keys, int offset, I_Object value, boolean lazy) {
        throw Err.invalid(keys, offset, value, lazy);
    }

    @Override
    protected Collection<? extends I_Object> getInternalCollection() {
        throw Err.invalid(new Object[0]);
    }

    private JMo_ByteArray iCutCopy(CallRuntime cr, int start, int end) {
        Lib_Error.ifTooSmall(cr, start, end);
        int newLen = end - start + 1;
        byte[] result = new byte[newLen];
        System.arraycopy(this.data, start - 1, result, 0, newLen);
        return new JMo_ByteArray(result);
    }
}

