/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import java.nio.ByteBuffer;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.LoopHandle;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.A_Number;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.I_Integer;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.struct.JMo_ByteArray;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.Lib_AtomConv;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Exec;
import org.jmo_lang.tools.Lib_Type;

public class JMo_Long
extends A_IntNumber
implements I_Integer,
I_Atomic {
    private final long value;

    public JMo_Long(long val) {
        this.value = val;
    }

    @Override
    protected ObjectCallResult call5(CallRuntime cr, String method) {
        return null;
    }

    @Override
    public I_AtomicValue convertTo(CallRuntime cr, ATOMIC to) {
        return Lib_AtomConv.convert(cr, ATOMIC.LONG, to, this, this.getValue());
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    @Override
    public int getIntValue(CallRuntime cr) {
        if (this.value < Integer.MIN_VALUE && this.value > Integer.MAX_VALUE) {
            throw new ExecError(cr, "Value out of Integer-Range", "" + this.value);
        }
        return (int)this.value;
    }

    @Override
    public String toStringExt(CallRuntime cr) {
        return "" + this.value + 'l';
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    protected A_Number number_op(CallRuntime cr, A_Number.NOP0 op) {
        switch (op) {
            case NEG: {
                return new JMo_Long(this.value ^ 0xFFFFFFFFFFFFFFFFL);
            }
            case ABS: {
                return new JMo_Long(Math.abs(this.value));
            }
        }
        throw new CodeError(cr, "Unknown type or function", String.valueOf(this.value) + " " + (Object)((Object)op));
    }

    @Override
    protected A_Number number_op(CallRuntime cr, A_Number.NOP01 op, I_Object[] args) {
        if (args.length == 0) {
            switch (op) {
                case INC: {
                    return new JMo_Long(this.value + 1L);
                }
                case DEC: {
                    return new JMo_Long(this.value - 1L);
                }
                case POW: {
                    return new JMo_Long(this.value * this.value);
                }
                case SQR: {
                    return new Dec(Math.sqrt(this.value));
                }
            }
        }
        A_Number arg = (A_Number)cr.argType(args[0], A_Number.class);
        double pard = Lib_Convert.getDoubleValue(cr, arg);
        long parl = Lib_Convert.getLongValue(cr, arg);
        switch (op) {
            case INC: {
                return new JMo_Long(this.value + parl);
            }
            case DEC: {
                return new JMo_Long(this.value - parl);
            }
            case POW: {
                if (arg instanceof A_IntNumber) {
                    return new JMo_Long(Math.round(Math.pow(this.value, parl)));
                }
                return new Dec(Math.pow(this.value, pard));
            }
            case SQR: {
                return new Dec(Math.exp(Math.log(this.value) / pard));
            }
        }
        throw new CodeError(cr, "Unknown type or function", String.valueOf(this.value) + " " + (Object)((Object)op) + " " + pard);
    }

    @Override
    protected A_Number number_op(CallRuntime cr, A_Number.NOP1 op, A_Number paro) {
        long val = this.value;
        if (paro instanceof A_IntNumber) {
            long arg = Lib_Convert.getLongValue(cr, paro);
            switch (op) {
                case ADD: {
                    return new JMo_Long(this.value + arg);
                }
                case SUB: {
                    return new JMo_Long(this.value - arg);
                }
                case MUL: {
                    return new JMo_Long(this.value * arg);
                }
                case DIV: {
                    if (arg == 0L) {
                        throw new ExecError(cr, "Division by zero", this.value + "/" + arg);
                    }
                    return new Dec((double)this.value / (double)arg);
                }
                case MOD: {
                    return new JMo_Long(this.value % arg);
                }
                case LOG: {
                    return new Dec(Math.log(this.value) / Math.log(arg));
                }
            }
        } else {
            double arg = Lib_Convert.getDoubleValue(cr, paro);
            switch (op) {
                case ADD: {
                    return new Dec((double)val + arg);
                }
                case SUB: {
                    return new Dec((double)val - arg);
                }
                case MUL: {
                    return new Dec((double)val * arg);
                }
                case DIV: {
                    if (arg == 0.0) {
                        throw new ExecError(cr, "Division by zero", val + "/" + arg);
                    }
                    return new Dec((double)val / arg);
                }
                case MOD: {
                    return new Dec((double)val % arg);
                }
                case LOG: {
                    return new Dec(Math.log(this.value) / Math.log(arg));
                }
            }
        }
        throw new CodeError(cr, "Unknown type or function", String.valueOf(this.value) + " " + (Object)((Object)op) + " " + Lib_Type.getName(paro));
    }

    @Override
    protected final ObjectCallResult times(CallRuntime crOld, boolean reverse) {
        crOld.args();
        Lib_Exec.checkLoopWithout(crOld);
        long value = this.getValue();
        LoopHandle handle = new LoopHandle(this, reverse ? "timesDown" : "timesUp");
        CallRuntime crNew = crOld.copyLoop(handle);
        I_Object result = this;
        if (reverse) {
            long i = value;
            while (i >= 1L) {
                handle.startLap();
                result = Lib_Exec.execBlockStream(crNew, new JMo_Long(i));
                result = Lib_Exec.loopResult(result);
                if (result instanceof Return) {
                    return ((Return)result).getLoopResult();
                }
                --i;
            }
        } else {
            long i = 1L;
            while (i <= value) {
                handle.startLap();
                result = Lib_Exec.execBlockStream(crNew, new JMo_Long(i));
                result = Lib_Exec.loopResult(result);
                if (result instanceof Return) {
                    return ((Return)result).getLoopResult();
                }
                ++i;
            }
        }
        return new ObjectCallResult(result, true);
    }

    @Override
    protected I_Object toBytes(CallRuntime cr) {
        byte[] bytes = ByteBuffer.allocate(8).putLong(this.value).array();
        return new JMo_ByteArray(bytes);
    }
}

