/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import de.mn77.base.data.Lib_Math;
import de.mn77.base.data.Lib_String;
import de.mn77.base.data.form.FormNumber;
import de.mn77.base.error.Err;
import org.jmo_lang.core.COMPARE;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_Atomic;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.I_Integer;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.Lib_AtomConv;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Type;

public abstract class A_Number
extends A_Atomic {
    @Override
    protected final ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "+": 
            case "add": {
                return A_Object.stdResult(this.ar(cr, NOP1.ADD, true));
            }
            case "-": 
            case "sub": {
                return A_Object.stdResult(this.ar(cr, NOP1.SUB, new boolean[0]));
            }
            case "*": 
            case "mul": {
                return A_Object.stdResult(this.ar(cr, NOP1.MUL, true));
            }
            case "/": 
            case "div": {
                return A_Object.stdResult(this.ar(cr, NOP1.DIV, new boolean[0]));
            }
            case "/~": 
            case "divFloor": 
            case "floorDiv": {
                return A_Object.stdResult(this.divFloor(cr));
            }
            case "%": 
            case "mod": {
                return A_Object.stdResult(this.ar(cr, NOP1.MOD, new boolean[0]));
            }
            case "log": {
                return A_Object.stdResult(this.ar(cr, NOP1.LOG, new boolean[0]));
            }
            case "++": 
            case "inc": {
                return A_Object.stdResult(this.ar(cr, NOP01.INC));
            }
            case "--": 
            case "dec": {
                return A_Object.stdResult(this.ar(cr, NOP01.DEC));
            }
            case "!": 
            case "neg": 
            case "not": {
                return A_Object.stdResult(this.ar(cr, NOP0.NEG));
            }
            case "abs": {
                return A_Object.stdResult(this.ar(cr, NOP0.ABS));
            }
            case "**": 
            case "pow": {
                return A_Object.stdResult(this.ar(cr, NOP01.POW));
            }
            case "//": 
            case "sqrt": {
                return A_Object.stdResult(this.ar(cr, NOP01.SQR));
            }
            case "roundDown": 
            case "~": 
            case "floor": {
                return A_Object.stdResult(this.floor(cr));
            }
            case "ceil": 
            case "roof": 
            case "roundUp": {
                return A_Object.stdResult(this.roof(cr));
            }
            case "\u2248": 
            case "round": {
                return A_Object.stdResult(this.round(cr));
            }
            case "style": {
                return A_Object.stdResult(this.style(cr));
            }
            case "width": {
                return A_Object.stdResult(this.width(cr));
            }
            case "limit": {
                return A_Object.stdResult(this.limit(cr));
            }
        }
        return this.call4(cr, method);
    }

    private I_Object divFloor(CallRuntime cr) {
        I_AtomicValue val = (I_AtomicValue)this.ar(cr, NOP1.DIV, new boolean[0]);
        int i = ((Int)(val = val.convertTo(cr, ATOMIC.INT))).getValue();
        return i >= 0 ? val : new Int(i - 1);
    }

    protected abstract ObjectCallResult call4(CallRuntime var1, String var2);

    protected abstract A_Number number_op(CallRuntime var1, NOP0 var2);

    protected abstract A_Number number_op(CallRuntime var1, NOP01 var2, I_Object[] var3);

    protected abstract A_Number number_op(CallRuntime var1, NOP1 var2, A_Number var3);

    @Override
    protected final Bool comparsion(CallRuntime cr, COMPARE m) {
        I_Object paro = cr.argsExt(this, new Class[][]{{Bool.class, A_Number.class}})[0];
        double value = ((Number)this.getValue()).doubleValue();
        double arg = Lib_Convert.getDoubleValue(cr, paro);
        switch (m) {
            case G: {
                return Bool.getObject(value > arg);
            }
            case L: {
                return Bool.getObject(value < arg);
            }
            case GE: {
                return Bool.getObject(value >= arg);
            }
            case LE: {
                return Bool.getObject(value <= arg);
            }
        }
        throw Err.impossible(new Object[]{m});
    }

    @Override
    public final Integer compareTo3(I_AtomicValue o) {
        if (!(o instanceof A_Number)) {
            return null;
        }
        Double value = ((Number)this.getValue()).doubleValue();
        double arg = Lib_Convert.getDoubleValue(null, o);
        return value.compareTo(arg);
    }

    @Override
    protected Int length(CallRuntime cr) {
        String s = "" + this.getValue();
        return new Int(s.length());
    }

    private final I_AtomicValue number_opStr(CallRuntime cr, NOP1 op, A_Atomic p) {
        String arg = Lib_Convert.getStringValue(cr, p);
        if (op == NOP1.ADD) {
            return new Str(this.getValue() + arg);
        }
        if (op == NOP1.MUL) {
            if (this.getValue() instanceof Double || this.getValue() instanceof Float) {
                throw new CodeError(cr, "Invalid type to multiply a <Char> or <Str>", "Got " + Lib_Type.getTypeString(this) + ", please use <Int>");
            }
            String s = Lib_String.sequence(arg, ((Number)this.getValue()).longValue());
            return new Str(s);
        }
        throw new CodeError(cr, "Unknown type or function", this.getValue() + " " + (Object)((Object)op) + " " + Lib_Type.getName(p));
    }

    private I_AtomicValue ar(CallRuntime cr, NOP0 op) {
        cr.args();
        return this.number_op(cr, op);
    }

    private I_AtomicValue ar(CallRuntime cr, NOP01 op) {
        I_Object[] args = cr.argsFlex(this, 0, 1);
        return this.number_op(cr, op, args);
    }

    private I_Object ar(CallRuntime cr, NOP1 op, boolean ... strPossible) {
        if (strPossible.length > 0 && strPossible[0]) {
            A_Atomic para = (A_Atomic)cr.args(this, A_Atomic.class)[0];
            if (para instanceof A_Number) {
                return this.number_op(cr, op, (A_Number)para);
            }
            if (para instanceof Bool) {
                return this.number_op(cr, op, new Int(Lib_Convert.getIntValue(cr, para)));
            }
            if (para instanceof Nil) {
                if (!(this instanceof I_Integer)) {
                    throw new CodeError(cr, "Invalid number for arithmetic Nil", "Only integer numbers are possible, but got: " + this.toString());
                }
                return Nil.arithmetic(cr, op, (Integer)this.getValue());
            }
            return this.number_opStr(cr, op, para);
        }
        A_Number parn = (A_Number)cr.args(this, A_Number.class)[0];
        return this.number_op(cr, op, parn);
    }

    private Str style(CallRuntime cr) {
        Str o = (Str)cr.args(this, Str.class)[0];
        String format = o.getValue();
        String number = this.getValue().toString();
        String result = "";
        int nPos = number.length() - 1;
        int fPos = format.length() - 1;
        while (fPos >= 0) {
            char f = format.charAt(fPos);
            if (fPos > 0 && format.charAt(fPos - 1) == '~') {
                result = String.valueOf(f) + result;
                --fPos;
            } else {
                switch (f) {
                    case '0': {
                        result = nPos >= 0 ? String.valueOf(number.charAt(nPos)) + result : "0" + result;
                        --nPos;
                        break;
                    }
                    case '#': {
                        result = nPos >= 0 ? String.valueOf(number.charAt(nPos)) + result : " " + result;
                        --nPos;
                        break;
                    }
                    case '?': {
                        if (nPos >= 0) {
                            result = String.valueOf(number.charAt(nPos)) + result;
                        }
                        --nPos;
                        break;
                    }
                    default: {
                        result = String.valueOf(f) + result;
                    }
                }
            }
            --fPos;
        }
        if (nPos >= 0) {
            result = String.valueOf(number.substring(0, nPos + 1)) + result;
        }
        return new Str(result);
    }

    private A_Number limit(CallRuntime cr) {
        double max;
        Class[] classArray = new Class[]{A_Number.class, A_Number.class};
        I_Object[] args = cr.args(this, classArray);
        double min = Lib_Convert.getDoubleValue(cr, args[0]);
        if (min > (max = Lib_Convert.getDoubleValue(cr, args[1]))) {
            throw new ExecError(cr, "Min. is greater than max.!", "Min.: " + min + "  Max.: " + max);
        }
        double d = ((Number)this.getValue()).doubleValue();
        if (d > max) {
            d = max;
        }
        if (d < min) {
            d = min;
        }
        return (A_Number)Lib_AtomConv.convert(cr, this.getClass(), (I_Object)new Dec(d));
    }

    private Str width(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int width = Lib_Convert.getIntValue(cr, arg);
        Number raw = (Number)this.getValue();
        String form = FormNumber.right(width, raw.longValue());
        return new Str(form);
    }

    private Int floor(CallRuntime cr) {
        cr.args();
        double value = ((Number)this.getValue()).doubleValue();
        return new Int((int)Math.floor(value));
    }

    private Int roof(CallRuntime cr) {
        cr.args();
        double value = ((Number)this.getValue()).doubleValue();
        return new Int((int)Math.ceil(value));
    }

    private I_AtomicValue round(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 0, 1);
        double value = ((Number)this.getValue()).doubleValue();
        switch (args.length) {
            case 0: {
                return new Int((int)Math.round(value));
            }
            case 1: {
                int i = Lib_Convert.getIntValue(cr, args[0]);
                if (i < 0 || i > 10) {
                    throw new CodeError(cr, "Invalid argument", "Got " + i + ", allowed = 0-10");
                }
                return new Dec(Lib_Math.round(value, i));
            }
        }
        throw Err.impossible(new Object[0]);
    }

    protected static enum NOP0 {
        NEG,
        ABS;

    }

    protected static enum NOP01 {
        INC,
        DEC,
        POW,
        SQR;

    }

    protected static enum NOP1 {
        ADD,
        SUB,
        MUL,
        DIV,
        MOD,
        LOG;

    }
}

