/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object;

import de.mn77.base.data.Lib_Random;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import de.mn77.base.thread.A_Thread;
import java.util.ArrayList;
import org.jmo_lang.core.Block;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.core.runtime.Instance;
import org.jmo_lang.error.AssertError;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.LoopHandle;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.immute.JMo_Type;
import org.jmo_lang.object.passthrough.Const;
import org.jmo_lang.object.passthrough.I_PassThrough;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.ConstLet;
import org.jmo_lang.object.pseudo.FuncLet;
import org.jmo_lang.object.pseudo.JMo_Error;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.pseudo.VarLet;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.object.sys.JMo_Java;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Exec;
import org.jmo_lang.tools.Lib_Output;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_Try;
import org.jmo_lang.tools.Lib_Type;

public abstract class A_Object
implements I_Object {
    private boolean init = false;

    @Override
    public void initOnce(CallRuntime cr) {
        if (this.init) {
            return;
        }
        this.init = true;
        this.init(cr);
    }

    public abstract void init(CallRuntime var1);

    public void setAlreadyInit() {
        this.init = true;
    }

    @Override
    public final ObjectCallResult call(CallRuntime cr) {
        String m2;
        char c0;
        String method = cr.call.method;
        if (this instanceof I_Atomic && method == null) {
            return new ObjectCallResult(this, false);
        }
        boolean pass = this instanceof I_PassThrough;
        ObjectCallResult result = null;
        ObjectCallResult objectCallResult = result = pass ? this.call2(cr, method) : this.iCall(cr, method);
        if (!pass && result == null && cr.getStrict().isValid_AutoProperty() && (c0 = method.charAt(0)) >= 'a' && c0 <= 'z' && (result = this.iCall(cr, m2 = "get" + Character.toUpperCase(c0) + method.substring(1))) == null && cr.argCount() > 0) {
            String m3 = "set" + Character.toUpperCase(c0) + method.substring(1);
            result = this.iCall(cr, m3);
        }
        if (result == null) {
            String typename = this instanceof JMo_Java ? this.toString() : this.getType(cr).toString();
            char c02 = method.charAt(0);
            if (c02 >= 'A' && c02 <= 'Z' || c02 == '_' && method.length() > 1 && Character.isUpperCase(method.charAt(1))) {
                throw new CodeError(cr, "Misplaced new object", "Maybe missing comma before: '" + method + "'");
            }
            throw new CodeError(cr, "Unknown function", String.valueOf(typename) + "." + method);
        }
        if (result.obj == null) {
            Err.todo("Result-Object is null", cr.getDebugInfo());
        }
        result.obj.initOnce(cr);
        return result;
    }

    private ObjectCallResult iCall(CallRuntime cr, String method) {
        switch (method) {
            case "isEqually": 
            case "equally": 
            case "compares": 
            case "==~": {
                return A_Object.stdResult(this.isEqual(cr, COMPARSION.LAZY, false));
            }
            case "equals": 
            case "==": 
            case "isEqual": {
                return A_Object.stdResult(this.isEqual(cr, COMPARSION.NORMAL, false));
            }
            case "isSame": 
            case "===": 
            case "same": {
                return A_Object.stdResult(this.isEqual(cr, COMPARSION.STRICT, false));
            }
            case "diffly": 
            case "isDiffly": 
            case "!=~": {
                return A_Object.stdResult(this.isEqual(cr, COMPARSION.LAZY, true));
            }
            case "isDifferent": 
            case "!=": 
            case "<>": 
            case "differs": {
                return A_Object.stdResult(this.isEqual(cr, COMPARSION.NORMAL, true));
            }
            case "!==": 
            case "other": 
            case "isOther": {
                return A_Object.stdResult(this.isEqual(cr, COMPARSION.STRICT, true));
            }
            case "getType": 
            case "type": {
                cr.args();
                return A_Object.stdResult(this.getType(cr));
            }
            case "types": 
            case "getTypes": {
                cr.args();
                return A_Object.stdResult(this.types(cr));
            }
            case "isType": {
                return A_Object.stdResult(this.isType(cr));
            }
            case "assertType": {
                return A_Object.stdResult(this.assertType(cr));
            }
            case "assert": 
            case "assertIf": {
                return A_Object.stdResult(this.assertIf(cr));
            }
            case "assertIs": {
                return A_Object.stdResult(this.assertIs(cr));
            }
            case "isError": {
                return A_Object.stdResult(this.isError(cr));
            }
            case "isNil": {
                return A_Object.stdResult(this.isNil(cr));
            }
            case "isNotNil": {
                return A_Object.stdResult(this.isNotNil(cr));
            }
            case "replaceNil": {
                return A_Object.stdResult(this.replaceNil(cr));
            }
            case "ifExec": {
                return A_Object.stdResult(this.ifExec(cr));
            }
            case "ifNil": {
                return this.ifNil(cr, false);
            }
            case "ifNotNil": {
                return this.ifNil(cr, true);
            }
            case "use": {
                return this.use(cr);
            }
            case "nilUse": {
                return this.nilUse(cr);
            }
            case "typeUse": {
                return this.typeUse(cr);
            }
            case "which": {
                return A_Object.stdResult(this.which(cr));
            }
            case "toStr": {
                return A_Object.stdResult(this.iToStr(cr));
            }
            case "toStrExt": {
                return A_Object.stdResult(this.iToStrExt(cr));
            }
            case "toStrFull": {
                return A_Object.stdResult(this.iToStrFull(cr));
            }
            case "print": {
                return A_Object.stdResult(this.print(cr, true));
            }
            case "echo": {
                return A_Object.stdResult(this.print(cr, false));
            }
            case "debug": {
                return A_Object.stdResult(this.debug(cr));
            }
            case "printErr": {
                return A_Object.stdResult(this.iPrintErr(cr, true));
            }
            case "echoErr": {
                return A_Object.stdResult(this.iPrintErr(cr, false));
            }
            case "while": {
                return this.iWhile(cr, method);
            }
            case "repeat": {
                return this.iRepeat(cr, method);
            }
            case "proc": {
                return A_Object.stdResult(this.procTee(cr, false));
            }
            case "tee": {
                return A_Object.stdResult(this.procTee(cr, true));
            }
            case "pass": {
                return new ObjectCallResult(this.pass(cr), true);
            }
            case "try": {
                return Lib_Try.errTry(cr, this);
            }
            case "tryUse": {
                return Lib_Try.errTryUse(cr, this);
            }
            case "tryBlockCatch": 
            case "tryCatch": {
                return Lib_Try.errTryCatch(cr, this);
            }
            case "catch": {
                return this.errCatch(cr);
            }
            case "mem": {
                return this.mem_let(cr, false);
            }
            case "convertMem": {
                return this.mem_let(cr, true);
            }
            case "toVarLet": 
            case "toVarlet": {
                return A_Object.stdResult(this.toVarLet(cr));
            }
            case "sync": {
                return this.sync(cr);
            }
            case "async": {
                return this.async(cr);
            }
            case "\u00b6": {
                return this.endMultiCall(cr);
            }
            case "%=>": 
            case "*=>": 
            case "+=>": 
            case "-=>": 
            case "/=>": {
                return this.iCalcLetRight(cr, method);
            }
            case "=>": {
                return this.iLetRight(cr, false);
            }
            case "~=>": {
                return this.iLetRight(cr, true);
            }
        }
        return this.call2(cr, method);
    }

    @Override
    public abstract String toString();

    protected abstract ObjectCallResult call2(CallRuntime var1, String var2);

    public I_Object print(CallRuntime cr, boolean newline) {
        I_Object[] args = cr.argsFlex(this, 0, 1);
        if (args != null && args.length == 1) {
            Lib_Output.out(cr, args[0], newline);
        } else {
            Lib_Output.out(cr, this, newline);
        }
        return this;
    }

    public I_Object debug(CallRuntime cr) {
        if (!cr.getApp().isDebug()) {
            return this;
        }
        I_Object[] args = cr.argsVar(this, 0, 0);
        StringBuilder sb = new StringBuilder();
        I_Object file = cr.getDebugInfo().getFile();
        if (file != Nil.NIL) {
            sb.append(file.toString());
        }
        sb.append(":");
        sb.append(cr.getDebugInfo().getLine().toString());
        sb.append(" | ");
        sb.append(Lib_Type.toStringExtWithType(cr, this));
        if (args != null && args.length > 0) {
            sb.append(" | ");
            boolean first = true;
            I_Object[] i_ObjectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                I_Object arg = i_ObjectArray[n2];
                if (!first) {
                    sb.append(",");
                }
                sb.append(arg.toString());
                first = false;
                ++n2;
            }
        }
        Lib_Output.out(cr.getApp(), sb.toString(), true);
        return this;
    }

    @Override
    public final int compareTo(CallRuntime cr, I_Object o) {
        if (o.hashCode() == this.hashCode() || this.equals(o)) {
            return 0;
        }
        Integer result = this.compareTo2(o);
        if (result == null) {
            throw new CodeError(cr, "Not comparable", String.valueOf(this.toString()) + " <---> " + o.toString());
        }
        return result;
    }

    protected Integer compareTo2(I_Object o) {
        return null;
    }

    @Override
    public void describe(CallRuntime cr, int left) {
        String space = Lib_Parser.space(left);
        MOut.print(String.valueOf(space) + this.toStringExt(cr));
    }

    @Override
    public final JMo_Type getType(CallRuntime cr) {
        Class<?> cl = this.getClass();
        String name = Lib_Type.getName(cl, this);
        return new JMo_Type(name, cr);
    }

    @Override
    public final String getTypeName() {
        Class<?> cl = this.getClass();
        return Lib_Type.getName(cl, this);
    }

    @Override
    public final String[] getTypeNames() {
        return Lib_Type.getTypeNames(this);
    }

    public static ObjectCallResult stdResult(I_Object result) {
        return new ObjectCallResult(result, false);
    }

    private I_Object isEqual(CallRuntime cr, COMPARSION comparsion, boolean not) {
        boolean result;
        I_Object arg = cr.args(this, I_Object.class)[0];
        boolean bl = comparsion == COMPARSION.NORMAL ? this.equals(arg) : (result = comparsion == COMPARSION.LAZY ? this.equalsLazy(arg) : this.equalsStrict(arg));
        if (not) {
            result = !result;
        }
        return Bool.getObject(result);
    }

    @Override
    public boolean equalsLazy(Object obj) {
        return this.equals(obj);
    }

    @Override
    public boolean equalsStrict(Object obj) {
        return this == obj;
    }

    @Override
    public String toStringFull(CallRuntime cr) {
        return String.valueOf(this.getTypeName()) + "(" + this.toString() + ")";
    }

    private ObjectCallResult async(final CallRuntime cr) {
        cr.getStrict().checkSave(cr, ".sync");
        final A_Object this2 = this;
        cr.getApp().registerFork();
        A_Thread t = new A_Thread(){

            @Override
            public void task() {
                cr.args(this2, new Class[0]);
                Call stream = cr.getStream();
                Block block = cr.getCallBlock();
                if (stream == null && block == null) {
                    throw new CodeError(cr, "Invalid call", "No argument, no stream, no block, for 'times' ... what to do?");
                }
                I_Object it = this2;
                if (block != null) {
                    try {
                        block.exec(cr, it);
                    }
                    catch (ReturnException e) {
                        Return temp = e.get();
                        temp.getResult();
                        switch (temp.getLevel()) {
                            case BREAK: {
                                return;
                            }
                        }
                        throw new CodeError(cr, "Invalid exit for block", "Got " + (Object)((Object)temp.getLevel()) + ", need " + (Object)((Object)Return.LEVEL.BREAK));
                    }
                }
                if (stream != null) {
                    cr.execInit(stream, it);
                }
                cr.getApp().checkExit(true);
            }
        };
        t.start();
        return new ObjectCallResult(Nil.NIL, true);
    }

    private ObjectCallResult endMultiCall(CallRuntime cr) {
        Int multiCallKey = (Int)cr.args(this, Int.class)[0];
        cr.vce.useMultiCall().add(multiCallKey.getValue(), this);
        return new ObjectCallResult(this, true);
    }

    protected ObjectCallResult errCatch(CallRuntime cr) {
        cr.args();
        Call stream = cr.getStream();
        Block block = cr.getCallBlock();
        I_Object result = this;
        if (this instanceof JMo_Error) {
            if (block != null) {
                try {
                    result = block.exec(cr, result);
                }
                catch (ReturnException e) {
                    return new ObjectCallResult(e.get(), true);
                }
            }
            if (stream != null) {
                result = cr.execInit(stream, result);
            }
        }
        return new ObjectCallResult(result, true);
    }

    private Str iToStr(CallRuntime cr) {
        cr.args();
        if (this instanceof Instance) {
            return new Str(((Instance)this).toStrString(cr));
        }
        return new Str(this.toString());
    }

    private Str iToStrExt(CallRuntime cr) {
        cr.args();
        return new Str(this.toStringExt(cr));
    }

    private Str iToStrFull(CallRuntime cr) {
        cr.args();
        return new Str(this.toStringFull(cr));
    }

    private I_Object replaceNil(CallRuntime cr) {
        I_Object o = cr.args(this, I_Object.class)[0];
        return this == Nil.NIL ? o : this;
    }

    private Bool isNil(CallRuntime cr) {
        cr.args();
        return Bool.getObject(this == Nil.NIL);
    }

    private Bool isError(CallRuntime cr) {
        cr.args();
        return Bool.getObject(this instanceof JMo_Error);
    }

    private Bool isNotNil(CallRuntime cr) {
        cr.args();
        return Bool.getObject(this != Nil.NIL);
    }

    private ObjectCallResult ifNil(CallRuntime cr, boolean not) {
        boolean check;
        cr.args();
        Call stream = cr.getStream();
        Block block = cr.getCallBlock();
        if (stream == null && block == null) {
            return new ObjectCallResult(this, true);
        }
        boolean bl = check = this == Nil.NIL;
        if (not) {
            check = !check;
        }
        I_Object res = Bool.getObject(check);
        res = Lib_Exec.execIf(cr, check, res, false);
        return new ObjectCallResult(res, true);
    }

    private ObjectCallResult use(CallRuntime cr) {
        Lib_Error.ifArgs(cr.argCount(), 2, (Integer)3, cr, this);
        I_Object result = null;
        if (cr.argCount() == 3) {
            Bool b = (Bool)cr.argsOneAdvance(this, 0, Bool.class);
            boolean hit = Lib_Convert.getBoolValue(cr, b);
            result = cr.argsOneAdvance(this, hit ? 1 : 2, I_Object.class);
        } else {
            if (!Lib_Type.typeIs(cr, this, Bool.class)) {
                throw new ExecError(cr, "Invalid type of current object", "If current object isn't a 'Bool' value, use 3 arguments 'use(Bool, Object, Object)'");
            }
            result = ((Bool)this).getValue() != false ? cr.argsOneAdvance(this, 0, I_Object.class) : cr.argsOneAdvance(this, 1, I_Object.class);
        }
        CallRuntime crNew = cr.copyPass();
        result = Lib_Exec.execBlockStream(crNew, result);
        return new ObjectCallResult(result, true);
    }

    private ObjectCallResult nilUse(CallRuntime cr) {
        Lib_Error.ifArgs(cr.argCount(), 2, (Integer)2, cr, this);
        I_Object result = cr.argsOneAdvance(this, this == Nil.NIL ? 0 : 1, I_Object.class);
        CallRuntime crNew = cr.copyPass();
        result = Lib_Exec.execBlockStream(crNew, result);
        return new ObjectCallResult(result, true);
    }

    private ObjectCallResult typeUse(CallRuntime cr) {
        Lib_Error.ifArgs(cr.argCount(), 3, (Integer)3, cr, this);
        I_Object typeNeeded = cr.argsOneAdvance(this, 0, Str.class);
        String typeNeeded2 = Lib_Convert.getStringValue(cr, typeNeeded);
        Lib_Type.checkValidity(typeNeeded2, cr);
        boolean hit = Lib_Type.isInstanceOf(this, typeNeeded2);
        I_Object result = cr.argsOneAdvance(this, hit ? 1 : 2, I_Object.class);
        CallRuntime crNew = cr.copyPass();
        result = Lib_Exec.execBlockStream(crNew, result);
        return new ObjectCallResult(result, true);
    }

    private I_Object which(CallRuntime cr) {
        int parIdx = 0;
        while (parIdx < cr.argCount()) {
            Bool b1 = (Bool)cr.argsOneAdvance(this, parIdx, Bool.class);
            if (b1 == Bool.TRUE) {
                return new Int(parIdx + 1);
            }
            ++parIdx;
        }
        return Nil.NIL;
    }

    private I_Object ifExec(CallRuntime cr) {
        if (this instanceof FuncLet) {
            return ((FuncLet)this).exec(cr);
        }
        return this;
    }

    private ObjectCallResult mem_let(CallRuntime cr, boolean convert) {
        I_Object[] args = cr.getArgs(this);
        if (args.length != 1) {
            throw new CodeError(cr, "Invalid amount of arguments", "Got " + args.length + " arguments, expected only one <Var>");
        }
        I_Object arg = cr.argType(args[0], VarLet.class);
        Var var = ((VarLet)arg).getVar();
        var.let(cr, cr, this, convert);
        return new ObjectCallResult(convert ? var : this, false);
    }

    private I_Object procTee(CallRuntime cr, boolean tee) {
        I_Object result = null;
        if (cr.argCount() == 2) {
            VarLet v = (VarLet)cr.argsOneAdvance(this, 0, VarLet.class);
            v.getVar().let(cr, cr, this);
            result = cr.argsOneAdvance(this, 1, I_Object.class);
        } else {
            result = cr.args(this, I_Object.class)[0];
        }
        if (result instanceof FuncLet) {
            result = ((FuncLet)result).eachExec(cr, this);
        }
        return tee ? this : result;
    }

    protected I_Object pass(CallRuntime crOld) {
        crOld.args();
        CallRuntime crNew = crOld.copyPass();
        return Lib_Exec.execBlockStream(crNew, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectCallResult sync(CallRuntime cr) {
        cr.getStrict().checkSave(cr, ".sync");
        A_Object a_Object = this;
        synchronized (a_Object) {
            A_Object it;
            I_Object[] args = cr.argsFlex(this, 0, 1);
            Call stream = cr.getStream();
            Block block = cr.getCallBlock();
            int parlen = args.length;
            if (parlen == 0 && stream == null && block == null) {
                throw new CodeError(cr, "Invalid call", "No argument, no stream, no block, for 'times' ... what to do?");
            }
            I_Object res = this;
            I_Object i_Object = it = parlen == 0 ? this : args[0];
            if (block != null) {
                try {
                    res = block.exec(cr, it);
                }
                catch (ReturnException e) {
                    Return temp = e.get();
                    res = temp.getResult();
                    switch (temp.getLevel()) {
                        case BREAK: {
                            return temp.getLoopResult();
                        }
                    }
                    throw new CodeError(cr, "Invalid exit for block", "Got " + (Object)((Object)temp.getLevel()) + ", need " + (Object)((Object)Return.LEVEL.BREAK));
                }
            }
            if (stream != null) {
                res = cr.execInit(stream, it);
            }
            return new ObjectCallResult(res, true);
        }
    }

    private JMo_List types(CallRuntime cr) {
        String[] types = Lib_Type.getTypeNames(this);
        ArrayList<I_Object> list = new ArrayList<I_Object>(types.length);
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            list.add(new JMo_Type(type, cr));
            ++n2;
        }
        return new JMo_List(list);
    }

    private Bool isType(CallRuntime cr) {
        I_Object arg = cr.argsExt(this, new Class[][]{{Str.class, JMo_Type.class}})[0];
        if (arg instanceof Str) {
            String s = Lib_Convert.getStringValue(cr, arg);
            Lib_Type.checkValidity(s, cr);
            return Bool.getObject(Lib_Type.isInstanceOf(this, s));
        }
        String s = ((JMo_Type)arg).getName();
        return Bool.getObject(Lib_Type.isInstanceOf(this, s));
    }

    private I_Object assertType(CallRuntime cr) {
        I_Object arg = cr.argsExt(this, new Class[][]{{Str.class, JMo_Type.class}})[0];
        String s = arg instanceof Str ? Lib_Convert.getStringValue(cr, arg) : ((JMo_Type)arg).getName();
        Lib_Type.checkValidity(s, cr);
        if (Lib_Type.isInstanceOf(this, s)) {
            return this;
        }
        throw new AssertError(cr, "Invalid type of current object!", "Type should be <" + s + ">, but is " + this.getType(cr).toString());
    }

    private I_Object assertIf(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        boolean b = Lib_Convert.getBoolValue(cr, cr.argType(args[0], Bool.class));
        if (b) {
            return this;
        }
        String message = args.length == 2 ? Lib_Convert.getStringValue(cr, args[1]) : "Invalid assertion, current object is: " + this.toString();
        throw new AssertError(cr, "Assert-Error!", message);
    }

    private I_Object assertIs(CallRuntime cr) {
        I_Object arg = cr.args(this, I_Object.class)[0];
        if (this.equals(arg)) {
            return this;
        }
        throw new AssertError(cr, "Assert-Error!", "Current object should be '" + arg.toString() + "' but is: " + this.toString());
    }

    private I_Object toVarLet(CallRuntime cr) {
        Var tmpVar = new Var("handle_" + Lib_Random.getString(10, true, true, true, ""));
        tmpVar.let(cr, cr, this);
        return new VarLet(tmpVar);
    }

    private ObjectCallResult iWhile(CallRuntime crOld, String method) {
        boolean varlet = false;
        if (crOld.argCount() == 0) {
            varlet = true;
            if (!(this instanceof VarLet)) {
                throw new ExecError(crOld, "Invalid condition for 'while'!", "Got no arguments and current object isn't a VarLet.");
            }
        }
        if (crOld.getStream() == null && crOld.getCallBlock() == null) {
            return new ObjectCallResult(this, true);
        }
        LoopHandle handle = new LoopHandle(this);
        CallRuntime crNew = crOld.copyLoop(handle);
        I_Object result = this;
        boolean b = false;
        I_Object check = Nil.NIL;
        check = varlet ? ((VarLet)this).getVar().get(crOld) : crOld.copyEach(method).argsEach(this, 0, new I_Object[]{result}, Bool.class);
        b = Lib_Convert.getBoolValue(crNew, check);
        while (b) {
            handle.startLap();
            result = Lib_Exec.execBlockStream(crNew, result);
            result = Lib_Exec.loopResult(result);
            if (result instanceof Return) {
                return ((Return)result).getLoopResult();
            }
            check = varlet ? ((VarLet)this).getVar().get(crOld) : crOld.copyEach(method).argsEach(this, 0, new I_Object[]{result}, Bool.class);
            b = Lib_Convert.getBoolValue(crNew, check);
        }
        return new ObjectCallResult(result, true);
    }

    private ObjectCallResult iRepeat(CallRuntime crOld, String method) {
        if (crOld.getStream() == null && crOld.getCallBlock() == null) {
            return new ObjectCallResult(this, true);
        }
        boolean varlet = false;
        if (crOld.argCount() == 0) {
            varlet = true;
            if (!(this instanceof VarLet)) {
                throw new ExecError(crOld, "Invalid condition for 'while'!", "Got no arguments and current object isn't a VarLet.");
            }
        }
        LoopHandle handle = new LoopHandle(this);
        CallRuntime crNew = crOld.copyLoop(handle);
        I_Object result = this;
        I_Object check = Nil.NIL;
        check = varlet ? ((VarLet)this).getVar().get(crOld) : crOld.copyEach(method).argsEach(this, 0, new I_Object[]{result}, Bool.class);
        boolean b = Lib_Convert.getBoolValue(crNew, check);
        do {
            handle.startLap();
            result = Lib_Exec.execBlockStream(crNew, result);
            result = Lib_Exec.loopResult(result);
            if (!(result instanceof Return)) continue;
            return ((Return)result).getLoopResult();
        } while (b = Lib_Convert.getBoolValue(crNew, check = varlet ? ((VarLet)this).getVar().get(crOld) : crOld.copyEach(method).argsEach(this, 0, new I_Object[]{result}, Bool.class)));
        return new ObjectCallResult(result, true);
    }

    private ObjectCallResult iCalcLetRight(CallRuntime cr, String method) {
        I_Object[] args = cr.getArgs(this);
        Lib_Error.ifArgs(cr.argCount(), 1, (Integer)1, cr, this);
        if (!(args[0] instanceof Var)) {
            cr.argType(args[0], Var.class);
        }
        Var v = (Var)args[0];
        method = method.substring(0, 2);
        Call thisCall = new Call(cr.getSurrBlock(), this, cr.getDebugInfo());
        Call callx = new Call(cr.getSurrBlock(), v, method, new Call[]{thisCall}, cr.getDebugInfo());
        CallRuntime cr2 = cr.copyCall(callx, false);
        I_Object newObject = v.call2((CallRuntime)cr2, (String)method).obj;
        CallRuntime crNew = cr.copyPass();
        I_Object result = Lib_Exec.execBlockStream(crNew, newObject);
        return new ObjectCallResult(result, true);
    }

    private ObjectCallResult iLetRight(CallRuntime cr, boolean convert) {
        I_Object[] args = cr.getArgs(this);
        Lib_Error.ifArgs(cr.argCount(), 1, (Integer)1, cr, this);
        I_Object arg = cr.argTypeExt(args[0], VarLet.class, ConstLet.class);
        A_Object newObject = null;
        if (arg instanceof VarLet) {
            Var v = ((VarLet)arg).getVar();
            v.let(cr, cr, this, convert);
            newObject = convert ? v.get(cr) : this;
        } else {
            Const c = ((ConstLet)arg).getConst();
            c.set(cr, cr, this);
            newObject = this;
        }
        CallRuntime crNew = cr.copyPass();
        I_Object result = Lib_Exec.execBlockStream(crNew, newObject);
        return new ObjectCallResult(result, true);
    }

    private final I_Object iPrintErr(CallRuntime cr, boolean newline) {
        I_Object[] args = cr.argsFlex(this, 0, 1);
        if (args != null && args.length == 1) {
            Lib_Output.stdErr(cr, args[0], newline);
        } else {
            Lib_Output.stdErr(cr, this, newline);
        }
        return this;
    }

    private static enum COMPARSION {
        STRICT,
        NORMAL,
        LAZY;

    }
}

