/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.lib.udp;

import de.mn77.lib.udp.UDP;
import de.mn77.lib.udp.UDP_Packet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.jmo_lang.core.ArgCallBuffer;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ExtError;
import org.jmo_lang.object.A_EventObject;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_Chars;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Byte;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.pseudo.JMo_Error;
import org.jmo_lang.object.struct.JMo_FunctionMap;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.tools.Lib_Convert;

public class JMo_UdpService
extends A_EventObject {
    private UDP udp = null;
    private final ArgCallBuffer par_port;

    public JMo_UdpService(Call port) {
        this.par_port = new ArgCallBuffer(1, port);
    }

    @Override
    public void init(CallRuntime cr) {
        int port = Lib_Convert.getIntValue(cr, this.par_port.init(cr, this, A_IntNumber.class));
        try {
            this.udp = new UDP(port);
        }
        catch (IOException e) {
            throw new ExtError(cr, "TCP-Network error", e.getMessage());
        }
        this.udp.onRecieve(paket -> {
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<I_Object> objects = new ArrayList<I_Object>();
            keys.add("host");
            objects.add(new Str(paket.getAddress().getHostAddress()));
            keys.add("port");
            objects.add(new Int(paket.getPort()));
            keys.add("bytes");
            objects.add(this.iToByteList(paket.getData()));
            keys.add("string");
            objects.add(new Str(paket.getString()));
            JMo_FunctionMap con = new JMo_FunctionMap(cr, keys, objects);
            this.eventRun(cr, "@recieve", con);
        });
        this.udp.onError(ioe -> {
            JMo_Error e = new JMo_Error((Throwable)ioe);
            this.eventRun(cr, "@error", e);
        });
    }

    private JMo_List iToByteList(byte[] bytes) {
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            al.add(new JMo_Byte(b));
            ++n2;
        }
        return new JMo_List(al);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected ObjectCallResult callMethod(CallRuntime cr, String method) {
        switch (method) {
            case "send": {
                I_Object[] oa = cr.argsExt(this, {Str.class}, {A_IntNumber.class}, {A_Chars.class, JMo_Byte.class, JMo_List.class});
                String address = Lib_Convert.getStringValue(cr, oa[0]);
                int port = Lib_Convert.getIntValue(cr, oa[1]);
                I_Object datax = oa[2];
                try {
                    if (datax instanceof A_Chars) {
                        String datas = Lib_Convert.getStringValue(cr, datax);
                        UDP_Packet paket = new UDP_Packet(address, port, datas);
                        this.udp.send(paket);
                        return A_Object.stdResult(this);
                    } else if (datax instanceof JMo_Byte) {
                        byte data = ((JMo_Byte)datax).getValue();
                        UDP_Packet paket = new UDP_Packet(address, port, new byte[]{data});
                        this.udp.send(paket);
                        return A_Object.stdResult(this);
                    } else {
                        if (!(datax instanceof JMo_List)) throw new ExecError(cr, "Invalid type of data", "Allowed are Chars,Byte and List, but got: " + datax.getTypeName());
                        Collection al = ((JMo_List)datax).getInternalCollection();
                        byte[] ba = new byte[((ArrayList)al).size()];
                        int i = 0;
                        while (i < ((ArrayList)al).size()) {
                            ba[i] = Lib_Convert.getByteValue(cr, (I_Object)((ArrayList)al).get(i));
                            ++i;
                        }
                        UDP_Packet paket = new UDP_Packet(address, port, ba);
                        this.udp.send(paket);
                    }
                    return A_Object.stdResult(this);
                }
                catch (IOException e) {
                    throw new ExtError(cr, "UDP-Network error", e.getMessage());
                }
            }
            case "start": {
                cr.args();
                this.udp.start();
                return A_Object.stdResult(this);
            }
            case "stop": {
                cr.args();
                this.udp.stop();
                return A_Object.stdResult(Nil.NIL);
            }
        }
        return null;
    }

    @Override
    protected ObjectCallResult callEvent(CallRuntime cr, String event) {
        return null;
    }

    @Override
    protected boolean validateEvent(CallRuntime cr, String event) {
        switch (event) {
            case "@recieve": 
            case "@error": {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "(" + this.par_port.get() + ")";
    }
}

