/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.lib.tcp;

import de.mn77.lib.tcp.TCP_Connection;
import de.mn77.lib.tcp.TCP_Server1;
import java.io.IOException;
import org.jmo_lang.core.ArgCallBuffer;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.ExtError;
import org.jmo_lang.lib.tcp.JMo_TcpConnection;
import org.jmo_lang.object.A_EventObject;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.pseudo.JMo_Error;
import org.jmo_lang.tools.Lib_Convert;

public class JMo_TcpServer
extends A_EventObject {
    private TCP_Server1 server;
    private final ArgCallBuffer par_port;

    public JMo_TcpServer(Call port) {
        this.par_port = new ArgCallBuffer(1, port);
    }

    @Override
    public void init(CallRuntime cr) {
        int p = Lib_Convert.getIntValue(cr, this.par_port.init(cr, this, A_IntNumber.class));
        try {
            this.server = new TCP_Server1(p);
        }
        catch (IOException e) {
            throw new ExtError(cr, "TCP-Network error", e.getMessage());
        }
        this.server.onConnect(verb -> {
            JMo_TcpConnection con = new JMo_TcpConnection((TCP_Connection)verb);
            this.eventRun(cr, "@connect", con);
        });
        this.server.onTimeOut(ste -> {
            JMo_Error e = new JMo_Error((Throwable)ste);
            this.eventRun(cr, "@timeout", e);
        });
        this.server.onError(ioe -> {
            JMo_Error e = new JMo_Error((Throwable)ioe);
            this.eventRun(cr, "@error", e);
        });
    }

    @Override
    protected ObjectCallResult callMethod(CallRuntime cr, String method) {
        switch (method) {
            case "wait": {
                I_Object o = cr.args(this, A_IntNumber.class)[0];
                int timeout = Lib_Convert.getIntValue(cr, o);
                this.server.waitForConnection(timeout * 1000);
                return A_Object.stdResult(Nil.NIL);
            }
            case "close": {
                cr.args();
                this.server.close();
                return A_Object.stdResult(Nil.NIL);
            }
        }
        return null;
    }

    @Override
    protected ObjectCallResult callEvent(CallRuntime cr, String event) {
        return null;
    }

    @Override
    protected boolean validateEvent(CallRuntime cr, String event) {
        switch (event) {
            case "@timeout": 
            case "@connect": 
            case "@error": {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "(" + this.par_port.get() + ")";
    }
}

