/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.lib.swing;

import de.mn77.base.error.Err;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.lib.swing.A_Swing_Frame;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.tools.Lib_Convert;

public class JMo_Swing_Main
extends A_Swing_Frame {
    private boolean run = false;

    public JMo_Swing_Main() {
    }

    public JMo_Swing_Main(Call title) {
        super(title);
    }

    public JMo_Swing_Main(Call dx, Call dy) {
        super(dx, dy);
    }

    public JMo_Swing_Main(Call dx, Call dy, Call title) {
        super(dx, dy, title);
    }

    @Override
    protected I_Object callMethod3(CallRuntime cr, String method) {
        switch (method) {
            case "run": 
            case "start": {
                this.run(cr);
                return this;
            }
            case "stop": 
            case "close": {
                this.close(cr);
                return Nil.NIL;
            }
            case "look": 
            case "setLook": {
                this.setLook(cr);
                return this;
            }
            case "looks": 
            case "getLooks": {
                return this.getLooks(cr.call);
            }
        }
        return null;
    }

    private void run(final CallRuntime cr) {
        cr.args();
        if (this.run) {
            throw new ExecError(cr, "App already started", null);
        }
        this.run = true;
        cr.getApp().registerFork();
        SwingUtilities.invokeLater(() -> {
            this.frame.setLocationRelativeTo(null);
            this.frame.setDefaultCloseOperation(2);
            this.frame.setVisible(true);
            Dimension sizeDim = this.frame.getSize();
            if (!(this.frame.isMinimumSizeSet() || this.frame.isPreferredSizeSet() || this.frame.isMaximumSizeSet() || sizeDim.height != 0 || sizeDim.width != 0)) {
                this.frame.setExtendedState(this.frame.getExtendedState() | 6);
            }
        });
        cr.getApp().doAtCalledExit(() -> {
            Frame[] frameArray = Frame.getFrames();
            int n = frameArray.length;
            int n2 = 0;
            while (n2 < n) {
                Frame f = frameArray[n2];
                f.setVisible(false);
                f.dispose();
                ++n2;
            }
        });
        this.frame.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                cr.getApp().checkExit(true);
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(e -> {
            if (e.getID() != 402) {
                return false;
            }
            if (e.getKeyCode() == 10 && e.getModifiersEx() == 0) {
                this.eventRun(cr, "@exec", this);
            } else {
                ArrayList<I_Object> al = new ArrayList<I_Object>(2);
                al.add(new Char(e.getKeyChar()));
                al.add(new Int(e.getModifiersEx()));
                this.eventRun(cr, "@key", new JMo_List(al));
            }
            return false;
        });
    }

    private void close(CallRuntime cr) {
        cr.args();
        if (!this.run) {
            throw new ExecError(cr, "Close error", "Mainframe is not running");
        }
        this.frame.dispose();
    }

    private void setLook(CallRuntime cr) {
        Str os = (Str)cr.args(this, Str.class)[0];
        String s = Lib_Convert.getStringValue(cr, os);
        this.iSetLook(s);
        this.frame.repaint();
    }

    private JMo_List getLooks(Call c) {
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = lafs;
        int n = lafs.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
            al.add(new Str(info.getName()));
            ++n2;
        }
        JMo_List list = new JMo_List(al);
        return list;
    }

    private String iGetLook(String search) {
        UIManager.LookAndFeelInfo info;
        UIManager.LookAndFeelInfo[] lafs;
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = lafs = UIManager.getInstalledLookAndFeels();
        int n = lafs.length;
        int n2 = 0;
        while (n2 < n) {
            info = lookAndFeelInfoArray[n2];
            if (info.getName().contains(search)) {
                return info.getClassName();
            }
            ++n2;
        }
        lookAndFeelInfoArray = lafs;
        n = lafs.length;
        n2 = 0;
        while (n2 < n) {
            info = lookAndFeelInfoArray[n2];
            if (info.getClassName().contains(search)) {
                return info.getClassName();
            }
            ++n2;
        }
        return null;
    }

    private void iSetLook(String s) {
        try {
            String name = this.iGetLook(s);
            if (name == null) {
                Err.invalid("Look not found", s, name);
            }
            UIManager.setLookAndFeel(name);
        }
        catch (Exception ex) {
            Err.exit(ex);
        }
    }

    @Override
    protected ObjectCallResult callEvent(CallRuntime cr, String event) {
        return null;
    }

    @Override
    protected boolean validateEvent(CallRuntime cr, String event) {
        switch (event) {
            case "@key": 
            case "@exec": {
                return true;
            }
        }
        return false;
    }
}

