/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.lib.bricklink;

import de.mn77.base.data.Lib_String;
import de.mn77.base.error.Err;
import de.mn77.lib.json.JsonObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.lib.bricklink.BLAuthSigner;
import org.jmo_lang.lib.bricklink.BL_Auth;
import org.jmo_lang.lib.bricklink.BL_METHOD;

public class Lib_Bricklink {
    public static String checkOrderState(CallRuntime cr, String s) {
        String s2;
        switch (s2 = s.toLowerCase()) {
            case "completed": 
            case "packed": 
            case "purged": 
            case "received": 
            case "pending": 
            case "updated": 
            case "npb": 
            case "npx": 
            case "nrs": 
            case "nss": 
            case "ocr": 
            case "paid": 
            case "ready": 
            case "processing": 
            case "cancelled": 
            case "shipped": {
                return s2;
            }
        }
        throw new ExecError(cr, "Invalid order state", "Unknown order state: " + s);
    }

    public static String checkPaymentState(CallRuntime cr, String s) {
        String s2;
        switch (s2 = Lib_String.capitalizeWords(s.toLowerCase())) {
            case "Received": 
            case "Returned": 
            case "None": 
            case "Sent": 
            case "Completed": 
            case "Clearing": 
            case "Bounced": {
                return s2;
            }
        }
        throw new ExecError(cr, "Invalid payment state", "Unknown payment state: " + s);
    }

    public static String checkItemType(CallRuntime cr, String type) {
        String s2;
        switch (s2 = type.toUpperCase()) {
            case "INSTRUCTION": 
            case "UNSORTED_LOT": 
            case "SET": 
            case "BOOK": 
            case "GEAR": 
            case "PART": 
            case "ORIGINAL_BOX": 
            case "CATALOG": 
            case "MINIFIG": {
                return s2;
            }
        }
        throw new ExecError(cr, "Invalid item type", "Unknown item type: " + type);
    }

    public static String checkStockRoomID(CallRuntime cr, String id) {
        String s2;
        switch (s2 = id.toUpperCase()) {
            case "A": 
            case "B": 
            case "C": {
                return s2;
            }
        }
        throw new ExecError(cr, "Invalid stockroom id", "Valid are ('A','B','C') but got: " + id);
    }

    public static String checkSetCompleteness(CallRuntime cr, String id) {
        String s2;
        switch (s2 = id.toUpperCase()) {
            case "B": 
            case "C": 
            case "S": {
                return s2;
            }
        }
        throw new ExecError(cr, "Invalid set complete status", "Valid are ('C','B','S') but got: " + id);
    }

    public static String checkInventoryStatus(CallRuntime cr, String id) {
        String s2;
        switch (s2 = id.toUpperCase()) {
            case "B": 
            case "C": 
            case "N": 
            case "R": 
            case "S": 
            case "Y": {
                return s2;
            }
        }
        throw new ExecError(cr, "Invalid set inventory status", "Valid are ('Y','S','B','C','N','R') but got: " + id);
    }

    public static String checkCouponState(CallRuntime cr, String s) {
        String s2;
        switch (s2 = s.toUpperCase()) {
            case "D": 
            case "E": 
            case "O": 
            case "S": {
                return s2;
            }
        }
        throw new ExecError(cr, "Invalid coupon status", "Valid are ('O','S','D','E') but got: " + s);
    }

    public static int checkInteger(CallRuntime cr, String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new ExecError(cr, "Invalid integer number", "Got: " + value);
        }
    }

    static String getBricklinkUrl(CallRuntime cr, BL_METHOD method, String url, BL_Auth auth, Map<String, String> propertys) {
        Map<String, String> params = Lib_Bricklink.getBricklinkMap(cr, method, url, auth, propertys);
        JsonObject obj = new JsonObject();
        obj.addAll(params);
        String jsonString = obj.toString();
        String args = "?";
        if (propertys != null) {
            for (Map.Entry<String, String> e : propertys.entrySet()) {
                args = String.valueOf(args) + e.getKey() + "=" + e.getValue() + "&";
            }
        }
        try {
            URI uri = new URI("https", "//api.bricklink.com/api/store/v1" + url + args + "Authorization=" + jsonString, null);
            String urlString = uri.toASCIIString();
            return urlString;
        }
        catch (URISyntaxException e) {
            throw Err.exit(e);
        }
    }

    private static Map<String, String> getBricklinkMap(CallRuntime cr, BL_METHOD method, String url, BL_Auth auth, Map<String, String> propertys) {
        if (auth == null) {
            throw new ExecError(cr, "Authentification-Error", "No authentification informations set.");
        }
        BLAuthSigner signer = new BLAuthSigner(auth.consumerKey(cr), auth.consumerSecret(cr));
        signer.setToken(auth.tokenValue(cr), auth.tokenSecret(cr));
        signer.setVerb(method.getString());
        signer.setURL("https://api.bricklink.com/api/store/v1" + url);
        if (propertys != null) {
            for (Map.Entry<String, String> e : propertys.entrySet()) {
                signer.addParameter(e.getKey(), e.getValue());
            }
        }
        Map<String, String> params = Collections.emptyMap();
        try {
            params = signer.getFinalOAuthParams();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }

    public static Map<String, Object> convertDotToTree(Map<String, String> props) {
        HashMap<String, Object> target = new HashMap<String, Object>();
        for (Map.Entry<String, String> e : props.entrySet()) {
            Lib_Bricklink.iconvertDotAdd(target, e.getKey(), e.getValue());
        }
        return target;
    }

    private static void iconvertDotAdd(Map<String, Object> target, String key, String value) {
        if (!key.contains(".")) {
            target.put(key, value);
        } else {
            int dotIdx = key.indexOf(46);
            String base = key.substring(0, dotIdx);
            String next = key.substring(dotIdx + 1);
            HashMap<String, Object> target2 = null;
            if (target.containsKey(base)) {
                target2 = (Map)target.get(base);
            } else {
                target2 = new HashMap();
                target.put(base, target2);
            }
            Lib_Bricklink.iconvertDotAdd(target2, next, value);
        }
    }

    public static String getImageURL(String type, String no, Integer color_id) {
        boolean nc = color_id == null;
        switch (type) {
            case "PART": {
                return nc ? "https://www.bricklink.com/PL/" + no + ".jpg" : "https://img.bricklink.com/ItemImage/PN/" + color_id + "/" + no + ".png";
            }
            case "MINIFIG": {
                return "https://www.bricklink.com/ML/" + no + ".jpg";
            }
            case "SET": {
                return "https://img.bricklink.com/ItemImage/SN/0/" + no + ".png";
            }
            case "BOOK": {
                return "https://www.bricklink.com/BL/" + no + ".jpg";
            }
            case "GEAR": {
                return "https://img.bricklink.com/ItemImage/GN/0/" + no + ".png";
            }
            case "CATALOG": {
                return "https://img.bricklink.com/ItemImage/CN/0/" + no + ".png";
            }
            case "INSTRUCTION": {
                return "https://img.bricklink.com/ItemImage/IN/0/" + no + ".png";
            }
            case "UNSORTED_LOT": {
                return null;
            }
            case "ORIGINAL_BOX": {
                return "https://img.bricklink.com/ItemImage/ON/0/" + no + ".png";
            }
        }
        return null;
    }
}

