/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.ide.swing.edit.styler;

import de.mn77.base.data.group.Section;
import java.util.ArrayList;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;
import org.jmo_lang.ide.swing.defs.FileEditor;
import org.jmo_lang.ide.swing.edit.styler.I_Styler;
import org.jmo_lang.ide.swing.edit.styler.Scanner;
import org.jmo_lang.ide.swing.edit.styler.styles.SECTION_TYPE;
import org.jmo_lang.ide.swing.edit.styler.styles.Styles;

public class Styler
implements DocumentListener,
I_Styler {
    private final FileEditor editor;
    private final StyledDocument doc;
    private final Styles styles;
    private boolean scanNeeded = false;
    private final Scanner scanner;

    public Styler(FileEditor editor) {
        this.editor = editor;
        this.doc = (StyledDocument)editor.getDocument();
        this.doc.addDocumentListener(this);
        this.styles = new Styles();
        this.styles.initStyles(editor);
        this.scanner = new Scanner(this.doc, this.styles);
    }

    @Override
    public void paintStyles() {
        if (this.scanNeeded) {
            this.scanner.update();
            this.scanNeeded = false;
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.scanNeeded = true;
        this.editor.setChanged(true);
        this.editor.repaint();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.scanNeeded = true;
        this.editor.setChanged(true);
        this.editor.repaint();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void paintFind(String find) {
        this.scanNeeded = true;
        this.scanner.update();
        StyledDocument doc = this.editor.getStyledDocument();
        String text = this.editor.getText().toLowerCase();
        find = find.toLowerCase();
        int fLen = find.length();
        Style style = this.styles.styles[SECTION_TYPE.FOUND.ordinal()];
        int i = 0;
        while (i < text.length() - fLen) {
            if (text.startsWith(find, i)) {
                doc.setCharacterAttributes(i, fLen, style, true);
                i += fLen;
            }
            ++i;
        }
        if (text.endsWith(find)) {
            doc.setCharacterAttributes(text.length() - fLen, fLen, style, true);
        }
        this.scanNeeded = false;
    }

    @Override
    public void paintOccurrences(ArrayList<Section> marks) {
        this.scanNeeded = true;
        this.scanner.update();
        StyledDocument doc = this.editor.getStyledDocument();
        Style style = this.styles.styles[SECTION_TYPE.OCCUR.ordinal()];
        for (Section mark : marks) {
            doc.setCharacterAttributes(mark.start, mark.end, style, false);
        }
        this.scanNeeded = false;
    }

    @Override
    public void repaint() {
        this.scanNeeded = true;
        this.paintStyles();
    }
}

