/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.core.runtime;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import org.jmo_lang.core.App;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.Function;
import org.jmo_lang.core.I_AutoBlockDo;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.Type;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.core.runtime.VarConstEnv;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.A_EventObject;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.magic.var.MV_THIS;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Exec;

public class Instance
extends A_EventObject
implements I_AutoBlockDo {
    private final Type type;
    private final App app;
    private final Call[] args;
    private VarConstEnv main_env = null;
    private I_Object parent = null;

    public Instance(App app, Type type, Call[] args) {
        this.type = type;
        this.app = app;
        this.args = args;
    }

    @Override
    public void init(CallRuntime crOld) {
        CallRuntime crNew = new CallRuntime(this, crOld.call);
        this.main_env = crNew.vce;
        I_Object[] argObjs = null;
        if (this.type.isControl()) {
            int parLen = this.type.getVars() == null ? 0 : this.type.getVars().length;
            argObjs = new I_Object[parLen];
            crNew.vce.initTypeSet(crOld, crNew);
        } else if (this.args != null) {
            argObjs = new I_Object[this.args.length];
            int i = 0;
            while (i < argObjs.length) {
                argObjs[i] = crOld.execInit(this.args[i], this);
                ++i;
            }
        } else {
            argObjs = new I_Object[]{};
        }
        this.type.getBlock().execTypeBlock(crOld, crNew, argObjs);
        this.parent = this.type.getParent();
        if (this.parent != null) {
            Call parentCall = new Call(crOld.getSurrBlock(), this.parent, crOld.getDebugInfo());
            CallRuntime crParent = crNew.copyCall(parentCall, true);
            this.parent = crParent.exec(this, true);
        }
    }

    @Override
    protected ObjectCallResult callMethod(CallRuntime crOld, String method) {
        switch (method) {
            case "_init": {
                return this.iInit(crOld);
            }
        }
        CallRuntime crNew = crOld.copyVCE(this, this.main_env, true);
        if (!this.type.getFunctions().knows(method) && this.parent != null) {
            Call cParent = new Call(crOld.getSurrBlock(), this.parent, method, crOld.call.argCalls, crOld.getDebugInfo());
            if (crOld.call.hasBlock()) {
                cParent.setBlock(crOld.call.getBlock());
            }
            CallRuntime crParent = crNew.copyCall(cParent, false);
            I_Object result = crParent.exec(Nil.NIL, true);
            return new ObjectCallResult(result, false);
        }
        Function f = this.type.getFunctions().get(crNew, method);
        if (f.isPrivate() && !(crOld.call.object instanceof MV_THIS)) {
            throw new ExecError(crOld, "Invalid access to private function", "This function is only accessable within the type definition: " + f.getNames()[0]);
        }
        try {
            return new ObjectCallResult(f.getBlock().execFunction(crOld, crNew, f), f.hasControl());
        }
        catch (ReturnException r) {
            Lib_Exec.checkExceptionIsEnd(crNew, r.get());
            return new ObjectCallResult(r.get().getResult(), f.hasControl());
        }
    }

    @Override
    protected ObjectCallResult callEvent(CallRuntime cr, String event) {
        I_Object[] args = cr.argsFlex(this, 0, 1);
        cr.instance.eventRunRaw(cr, event, args.length == 1 ? args[0] : this);
        return new ObjectCallResult(this, false);
    }

    @Override
    protected boolean validateEvent(CallRuntime cr, String event) {
        return this.type.getEvents().knows(event.substring(1));
    }

    private ObjectCallResult iInit(CallRuntime crOld) {
        Lib_Error.ifNotControl(crOld, this.type);
        Lib_Error.ifNotBetween(crOld, 0, 2, crOld.argCount(), "Arguments for _init");
        Group2<CallRuntime, CallRuntime> init = crOld.vce.initTypeGet();
        switch (crOld.argCount()) {
            case 0: {
                I_Object[] parObjs = null;
                if (this.args != null) {
                    parObjs = new I_Object[this.args.length];
                    int i = 0;
                    while (i < parObjs.length) {
                        parObjs[i] = ((CallRuntime)init.o1).execInit(this.args[i], this);
                        ++i;
                    }
                } else {
                    parObjs = new I_Object[]{};
                }
                this.type.getBlock().reInit((CallRuntime)init.o1, (CallRuntime)init.o2, parObjs);
                break;
            }
            case 1: {
                int parLen1 = this.type.getVars().length;
                if (parLen1 == 0) {
                    throw new ExecError(crOld, "Invalid call of _init", "This type has no parameters to initialize");
                }
                I_Object funcPars1 = crOld.args(this, A_IntNumber.class)[0];
                int parToInit1 = Lib_Convert.getIntValue(crOld, funcPars1);
                Lib_Error.ifArgs(parToInit1, 1, (Integer)parLen1, crOld, this);
                I_Object parObj1 = ((CallRuntime)init.o1).execInit(this.args[parToInit1 - 1], this);
                this.type.getBlock().reInit((CallRuntime)init.o1, (CallRuntime)init.o2, this.args.length, parToInit1, parObj1);
                break;
            }
            case 2: {
                int parLen2 = this.type.getVars().length;
                if (parLen2 == 0) {
                    throw new ExecError(crOld, "Invalid call of _init", "This type has no parameters to initialize");
                }
                I_Object[] funcPars2 = crOld.args(this, A_IntNumber.class, I_Object.class);
                int parToInit2 = Lib_Convert.getIntValue(crOld, funcPars2[0]);
                Lib_Error.ifArgs(parToInit2, 1, (Integer)parLen2, crOld, this);
                I_Object eachValue2 = funcPars2[1];
                I_Object parObj2 = ((CallRuntime)init.o1).execEachInit(this.args[parToInit2 - 1], this, eachValue2);
                this.type.getBlock().reInit((CallRuntime)init.o1, (CallRuntime)init.o2, this.args.length, parToInit2, parObj2);
            }
        }
        return new ObjectCallResult(this, false);
    }

    public App getApp() {
        return this.app == null ? (App)this : this.app;
    }

    public Type getType() {
        return this.type;
    }

    public VarConstEnv getMainEnv() {
        return this.main_env;
    }

    @Override
    public String toString() {
        return this.type.getName();
    }

    public String toStrString(CallRuntime cr) {
        if (this.type.getFunctions().knows("toStr")) {
            Function f = this.getType().getFunctions().get(cr, "toStr");
            CallRuntime cr2 = cr.copyNil();
            I_Object result = f.getBlock().execOverwrite(cr2, this, f);
            return Lib_Convert.getStringValue(cr, result);
        }
        return this.toString();
    }

    public String toStringShort() {
        return this.type.getName();
    }

    protected void setMainEnv(VarConstEnv vce) {
        if (this.main_env != null) {
            Err.forbidden("Is already set!");
        }
        this.main_env = vce;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        if (this.type == null || this.type.getAutoBlockFunction() == null) {
            throw new ExecError(cr, "This type has no auto-block-function!", "Type: " + this.type.getName());
        }
        String newMethod = this.type.getAutoBlockFunction();
        Call call2 = new Call(cr.getSurrBlock(), this, newMethod, cr.call.argCalls, cr.getDebugInfo());
        if (cr.hasBlock()) {
            call2.setBlock(cr.getCallBlock());
        }
        if (cr.hasStream()) {
            call2.setStream(cr.getStream());
        }
        CallRuntime crNew = cr.copyCall(call2, false);
        return this.callMethod((CallRuntime)crNew, (String)newMethod).obj;
    }
}

