/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.core;

import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.parser.PARSER_LEVEL;
import org.jmo_lang.parser.ParseManagerFunc;
import org.jmo_lang.parser.ParseManagerObj;

public class StrictManager {
    private static boolean limitDec = true;
    private final ParseManagerObj parsemanager_obj;
    private final ParseManagerFunc parsemanager_func;
    private boolean strictAutoBlock = false;
    private boolean strictFuncResultType = false;
    private boolean strictAutoProperty = false;
    private boolean strictFuncParType = false;
    private boolean strictShortenMethod = false;
    private boolean strict_GroupIf = false;
    private boolean strictShortImports = false;
    private boolean strictVarConstShortcut = false;
    private boolean strictAutoVarLet = false;
    private boolean strictSave = false;
    private boolean strictWebstart = false;
    private boolean strictAnotherScript = false;
    private boolean strictOpenArg = false;
    private PARSER_LEVEL parserLevel = PARSER_LEVEL.OPEN;
    private boolean lazyErrors = false;
    private boolean unsafeHotCode = false;
    private boolean clearFlow = false;

    public static boolean limitDec() {
        return limitDec;
    }

    public StrictManager(ParseManagerObj parsemanager_obj, ParseManagerFunc parsemanager_func) {
        this.parsemanager_obj = parsemanager_obj;
        this.parsemanager_func = parsemanager_func;
        limitDec = true;
    }

    public void set(PARSER_LEVEL level, DebugInfo debug) {
        if (this.parserLevel != PARSER_LEVEL.OPEN && level != this.parserLevel) {
            throw new ParseError("Parser-Level already set!", level.name().toLowerCase(), debug);
        }
        this.parserLevel = level;
        this.parsemanager_obj.strictLevel(level);
        this.parsemanager_func.strictLevel(level);
        switch (level) {
            case HIGH: 
            case INSANE: {
                this.strictAutoProperty = true;
                this.strictAutoBlock = true;
                this.strictFuncResultType = true;
            }
            case MEDIUM: {
                this.strictVarConstShortcut = true;
                this.strictShortImports = true;
                this.strictOpenArg = true;
            }
            case LOW: {
                this.strictAutoVarLet = true;
                this.strictFuncParType = true;
                this.strictShortenMethod = true;
                this.strict_GroupIf = true;
            }
        }
    }

    public void setSave() {
        this.strictSave = true;
        this.parsemanager_obj.strictSave();
        this.parsemanager_func.strictSave();
    }

    public void setWebstart() {
        this.strictWebstart = true;
    }

    public void setAnotherScript() {
        this.strictAnotherScript = true;
    }

    public void setLazyErrors() {
        this.lazyErrors = true;
    }

    public boolean getLazyErrors() {
        return this.lazyErrors;
    }

    public void setUnsafeHotCode() {
        this.unsafeHotCode = true;
    }

    public void setClearFlow() {
        this.clearFlow = true;
    }

    public void checkUnsafeHotCode(CallRuntime cr, String infoTypeCall) {
        if (!this.unsafeHotCode) {
            throw new CodeError(cr, "Execution of unsafe hot code is prohibited.", "Forbidden call: " + infoTypeCall);
        }
    }

    public void setOpenDec() {
        limitDec = false;
    }

    public void checkSave(CallRuntime cr, String of) {
        if (this.strictSave) {
            throw new CodeError(cr, "Save-Mode! This object/function is forbidden!", of);
        }
    }

    public void checkSave(DebugInfo debug, String of) {
        if (this.strictSave) {
            throw new ParseError("Save-Mode! This object/function is forbidden!", of, debug);
        }
    }

    public void checkWebstart(CallRuntime cr, String of) {
        if (this.strictWebstart) {
            throw new CodeError(cr, "Webstart-Mode! This object/function is not available!", of);
        }
    }

    public void checkAutoBlock(CallRuntime cr) {
        if (this.strictAutoBlock) {
            throw new CodeError(cr, "Strict! Auto-Block-Function and .do are forbidden!", "Use it with the correct function, for example '.each'");
        }
    }

    public void checkFuncParType(String pType, String pName, DebugInfo debug) {
        if (this.strictFuncParType && pType == null) {
            throw new ParseError("Strict! Missing type of parameter!", pName, debug);
        }
    }

    public void checkFuncResultType(String fType, String fName, DebugInfo debug) {
        if (this.strictFuncResultType && fType == null) {
            throw new ParseError("Strict! Missing return-type for function!", fName, debug);
        }
    }

    public void checkGroupIf(CallRuntime cr) {
        if (this.strict_GroupIf) {
            throw new CodeError(cr, "Strict! Auto-Block-Function for Group is forbidden!", "Use If()");
        }
    }

    public void checkParseTimeSwitch(String s, DebugInfo debug) {
        if (this.strictAnotherScript) {
            throw new ParseError("Strict! This command is invalid or only allowed at the top of the first files!", s, debug);
        }
        if (this.strictSave) {
            throw new ParseError("Strict! All parse-time-commands are forbidden!", s, debug);
        }
    }

    public void checkShortImports(DebugInfo debug) {
        if (this.strictShortImports) {
            throw new CodeError("Strict! Short imports are forbidden!", "Use >import() and >java()", debug);
        }
    }

    public void checkVarConstShortcut(DebugInfo debug, String raw, String full) {
        if (this.strictVarConstShortcut) {
            throw new CodeError("Strict! Shortcut of variables and constants are not allowed!", "Please write '" + full + "' instead of '" + raw + "'!", debug);
        }
    }

    public void checkClearFlow(DebugInfo debug) {
        if (this.clearFlow) {
            throw new CodeError("Strict! Clear flow enforced!", "Function.return, Loop.break and Loop.next are unavailable.", debug);
        }
    }

    public void checkOpenArg(DebugInfo debug) {
        if (this.strictOpenArg) {
            throw new CodeError("Strict! Open argument is forbidden!", "Please put the argument in brackets.", debug);
        }
    }

    public boolean isValid_ShortenMethod() {
        return !this.strictShortenMethod;
    }

    public boolean isValid_AutoProperty() {
        return !this.strictAutoProperty;
    }

    public boolean isValid_AutoVarLet() {
        return !this.strictAutoVarLet;
    }
}

