/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.core;

import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import java.util.Collection;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.ConstManager;
import org.jmo_lang.core.Function;
import org.jmo_lang.core.FunctionPar;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.Type;
import org.jmo_lang.core.VarManager;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.core.runtime.Instance;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.magic.var.MV_THIS;
import org.jmo_lang.object.passthrough.Const;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.NonAtomic;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.pseudo.VarLet;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.tools.Lib_AtomConv;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_MagicVar;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_Type;

public class Block
extends A_Object {
    private static int counter = 0;
    private final int nr;
    private ArrayList<Call> items = null;
    private final Block parent;
    private final Function func;
    private final Type typ;
    private final VarManager vars;
    private final ConstManager consts;

    public Block(Type typ) {
        this(typ, null, null);
    }

    public Block(Type typ, Function func, Block parent) {
        this.typ = typ;
        this.func = func;
        this.parent = parent;
        this.nr = ++counter;
        this.vars = new VarManager(parent == null ? null : parent.getVarManager());
        this.consts = new ConstManager(parent == null ? null : parent.getConstManager());
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        throw Err.forbidden(cr);
    }

    public final void add(Call m) {
        Err.ifNull(m);
        if (this.items == null) {
            this.items = new ArrayList();
        }
        this.items.add(m);
    }

    @Override
    public void describe(CallRuntime cr, int left) {
        String space = Lib_Parser.space(left);
        String space2 = Lib_Parser.space(left + 1);
        MOut.print(String.valueOf(space) + this.toStringExt(cr));
        if (this.vars != null && this.vars.getCount() > 0) {
            MOut.print(String.valueOf(space2) + "Variables:");
            this.vars.describe(cr, left + 2);
        }
        if (this.consts != null && this.consts.getCount() > 0) {
            MOut.print(String.valueOf(space2) + "Constants:");
            this.consts.describe(cr, left + 2);
        }
        if (this.items != null && this.items.size() > 0) {
            MOut.print(String.valueOf(space2) + "Items:");
            for (Call c : this.items) {
                c.describe(cr, left + 2);
            }
        }
    }

    public final I_Object execAppRoot(CallRuntime cr) throws ReturnException {
        return this.iExec(cr, null, true);
    }

    public final I_Object exec(CallRuntime cr, I_Object blockIT) throws ReturnException {
        cr = cr.copyCall(cr.call, true);
        return this.iExec(cr, blockIT, false);
    }

    public void reInit(CallRuntime crOut, CallRuntime crIn, I_Object[] args) {
        this.initPars(crOut, crIn, crIn.instance.getType().getVars(), args);
    }

    public void reInit(CallRuntime crOut, CallRuntime crIn, int parsGiven, int parToInit, I_Object parValue) {
        I_Object[] args = new I_Object[parsGiven];
        args[parToInit - 1] = parValue;
        this.initPars(crOut, crIn, crIn.instance.getType().getVars(), args);
    }

    public I_Object execOverwrite(CallRuntime cr, Instance instance, Function f) {
        CallRuntime crInside = cr.copyVCE(instance, instance.getMainEnv(), true);
        if (f.hasControl()) {
            throw new CodeError(crInside, "Invalid function overwrite", "Function has control-functionality: " + f.getNames()[0]);
        }
        try {
            return f.getBlock().execFunction(cr, crInside, f);
        }
        catch (ReturnException e) {
            if (e.get().getLevel() != Return.LEVEL.END) {
                throw new ExecError(crInside, "Invalid return from overwritten function!", "Function " + f.toStringExt(crInside) + " returns " + (Object)((Object)e.get().getLevel()));
            }
            return e.get().getResult();
        }
    }

    public I_Object execFunction(CallRuntime crOutside, CallRuntime crInside, Function f) throws ReturnException {
        boolean throw_return;
        I_Object checkValue;
        I_Object returnValue;
        CallRuntime crNew;
        block15: {
            if (!f.hasControl() && crInside.hasBlock()) {
                throw new CodeError(crInside, "No Block allowed", "Function has no control functionality: " + crInside.call.toString());
            }
            crNew = crInside.copyFunction(crOutside);
            if (!f.hasControl()) {
                this.initPars(crOutside, crNew, f.getVars(), crOutside.getArgs(null));
            } else {
                crNew.vce.setFuncInit(this, crOutside, crNew, f.getVars());
            }
            returnValue = null;
            checkValue = null;
            throw_return = false;
            try {
                checkValue = returnValue = this.iExec(crNew, Nil.NIL, false);
            }
            catch (ReturnException e) {
                Return r = e.get();
                returnValue = r;
                checkValue = r.getResult();
                throw_return = true;
                if (r.getLevel() == Return.LEVEL.END) break block15;
                Err.todo(r);
            }
        }
        if (checkValue == null && this.isEmpty()) {
            checkValue = returnValue = Lib_AtomConv.getDefaultValue(f.getReturnType());
        }
        if (f.getReturnType() != null) {
            if (f.getReturnType().equals("Same")) {
                if (throw_return && checkValue != Nil.NIL && !(checkValue instanceof MV_THIS) && !(checkValue instanceof Instance)) {
                    throw new CodeError(crNew, "Invalid value for return type 'Same'", "Got " + Lib_Type.getTypeString(checkValue.getClass(), checkValue) + ", need '" + "this" + "'");
                }
                Instance newValue = crNew.instance;
                returnValue = throw_return ? new Return(((Return)returnValue).getLevel(), newValue) : newValue;
            } else {
                String resultType = Lib_Type.getTypeString(checkValue.getClass(), checkValue);
                String wantedType = f.getReturnType();
                if (!Lib_Type.isInstanceOf(checkValue, wantedType)) {
                    if (resultType.equals("<Nil>")) {
                        if (!f.getReturnNil()) {
                            throw new CodeError(crNew, "Invalid return value", "Return value is nil");
                        }
                    } else {
                        throw new CodeError(crNew, "Invalid return type", "Got " + resultType + ", need <" + wantedType + ">");
                    }
                }
            }
        }
        if (throw_return) {
            throw new ReturnException((Return)returnValue);
        }
        return returnValue;
    }

    public void execTypeBlock(CallRuntime cpOutside, CallRuntime cpInside, I_Object[] args) {
        CallRuntime cpNew2 = cpInside.copyCall(cpInside.call, false);
        this.initPars(cpOutside, cpNew2, cpInside.instance.getType().getVars(), args);
        try {
            this.iExec(cpNew2, null, false);
        }
        catch (ReturnException e) {
            throw new CodeError(cpOutside, "Invalid condition", "'" + e.get().toString() + "' in Type-Body is forbidden.");
        }
    }

    public ConstManager getConstManager() {
        return this.consts;
    }

    public Function getFunction(CallRuntime cr) {
        return this.func;
    }

    public Collection<Call> getItems() {
        return this.items;
    }

    public Block getParent() {
        return this.parent;
    }

    public Type getType() {
        return this.typ;
    }

    public boolean isEmpty() {
        return this.items == null || this.items.size() == 0;
    }

    public VarManager getVarManager() {
        return this.vars;
    }

    @Override
    public String toStringExt(CallRuntime cr) {
        return "<Block_" + this.nr + ">";
    }

    @Override
    public String toString() {
        return "Block_" + this.nr;
    }

    private final I_Object iExec(CallRuntime cr, I_Object blockIT, boolean returnLast) throws ReturnException {
        Var var = new Var("it??");
        cr.vce.vars.set(cr, var, blockIT == null ? Nil.NIL : blockIT, false, true, false);
        if (this.items == null) {
            return null;
        }
        I_Object last_result = null;
        for (Call c : this.items) {
            I_Object result;
            CallRuntime crCall = cr.copyBlockItem(c);
            last_result = result = crCall.exec(blockIT, false);
            if (!(result instanceof Return)) continue;
            throw new ReturnException((Return)result);
        }
        return returnLast ? last_result : cr.vce.vars.get(cr, var);
    }

    public void initPars(CallRuntime crOld, CallRuntime crNew, FunctionPar[] pars, I_Object[] args) {
        block22: {
            int fDefaults;
            boolean hasVarArgs;
            int argsLen = args == null ? 0 : args.length;
            int parsLen = pars == null ? 0 : pars.length;
            boolean bl = hasVarArgs = this.func != null && this.func.isVarArgs() || this.func == null && this.typ != null && this.typ.isVarArgs();
            int n = this.func != null ? this.func.getDefaultArgs() : (fDefaults = this.typ != null ? this.typ.getDefaultArgs() : 0);
            if (argsLen > parsLen && !hasVarArgs) {
                throw new CodeError(crOld, "Too much arguments", "Got " + argsLen + ", need " + parsLen + " argument(s).");
            }
            int parsNeeded = parsLen - fDefaults - (hasVarArgs ? 1 : 0);
            if (argsLen < parsNeeded) {
                throw new CodeError(crOld, "Missing argument or default value", "Got " + argsLen + ", need " + parsNeeded + " argument(s).");
            }
            if (pars == null) break block22;
            Err.ifNull(new Object[]{args});
            int offset = parsLen - argsLen;
            int i = parsLen - 1;
            while (i >= 0) {
                block26: {
                    I_Object arg;
                    boolean useVarArgs;
                    FunctionPar par;
                    block24: {
                        I_Object par1;
                        int parIdx;
                        block25: {
                            block23: {
                                boolean useDefault;
                                par = pars[i];
                                boolean bl2 = useDefault = offset > 0 && par.defaultValue != null;
                                if (useDefault) {
                                    --offset;
                                }
                                boolean bl3 = useVarArgs = hasVarArgs && i == parsLen - 1;
                                if (useVarArgs) {
                                    offset = argsLen >= parsLen - 1 ? 0 : --offset;
                                }
                                if ((parIdx = i - offset) < 0) {
                                    throw new CodeError(crOld, "Missing argument or default value", "Got " + argsLen + ", need " + parsLen + " argument(s).");
                                }
                                arg = null;
                                if (!useDefault) break block23;
                                arg = Lib_MagicVar.replace(par.defaultValue, crOld, crNew.instance, null);
                                break block24;
                            }
                            if (!useVarArgs) break block25;
                            if (argsLen >= 1 && parsLen == argsLen && parIdx == argsLen - 1 && args[parIdx] instanceof VarLet) {
                                I_Object paro = ((VarLet)args[parIdx]).getVar().get(crOld);
                                if (!Lib_Type.typeIs(crOld, paro, JMo_List.class)) {
                                    throw new ExecError(crOld, "Invalid type of variable for varargs", "To use Var-Args with a VarLet, the variable must be a <List>");
                                }
                                arg = paro;
                            } else {
                                ArrayList<I_Object> al = new ArrayList<I_Object>();
                                int v = parsLen - 1;
                                while (v < argsLen) {
                                    I_Object p = args[v];
                                    if (p != null) {
                                        if (par.typeName != null && arg != Nil.NIL && !Lib_Type.isInstanceOf(p, par.typeName)) {
                                            throw new CodeError(crOld, "Invalid type of argument in VarArgs", "Got " + p.getType(crNew).toString() + ", need <" + par.typeName + '>');
                                        }
                                        al.add(p);
                                    }
                                    ++v;
                                }
                                arg = new JMo_List(al);
                            }
                            break block24;
                        }
                        if (parIdx > argsLen - 1) {
                            Err.invalid(parIdx, argsLen, parsLen);
                        }
                        if ((par1 = args[parIdx]) == null) break block26;
                        arg = Lib_Convert.getValue(crOld, par1);
                        if (par.typeName != null && !(arg instanceof VarLet) && par1 instanceof Var && crOld.getStrict().isValid_AutoVarLet() && par.typeName.equals(Lib_Type.getName(VarLet.class, null))) {
                            arg = new VarLet((Var)par1);
                        }
                    }
                    if (!useVarArgs && par.typeName != null && arg != Nil.NIL && !Lib_Type.isInstanceOf(arg, par.typeName)) {
                        throw new CodeError(crOld, "Invalid type of argument", "Got " + arg.getType(crNew).toString() + ", need <" + par.typeName + '>');
                    }
                    if (this.vars.parentKnowsRaw(par.name)) {
                        throw new CodeError(crOld, "Can't create Var/Const with this name!", "Name is already used/known in this block: " + par.name);
                    }
                    if (par.isConst) {
                        Const con = (Const)this.consts.use_RunTime(crOld, par.name);
                        con.set(crOld, crNew, arg);
                    } else {
                        Var var = (Var)this.vars.use_RunTime(crOld, par.name);
                        if (arg instanceof NonAtomic) {
                            arg = ((NonAtomic)arg).create(crNew);
                        }
                        var.let(crOld, crNew, arg);
                    }
                }
                --i;
            }
            Err.ifNot(offset, 0);
        }
    }
}

