/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.core;

import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.tools.Lib_Output;
import org.jmo_lang.tools.Lib_Parser;

public class ArgCallBuffer {
    private Call call;
    private I_Object obj = null;
    private boolean init = false;
    private Class<? extends I_Object>[] typecheck = null;
    private final int argPos;

    public ArgCallBuffer(int argPos, Call c) {
        Err.ifNull(c);
        this.call = c;
        this.argPos = argPos;
    }

    public I_Object init(CallRuntime cr, I_Object streamIt, Class<? extends I_Object> type) {
        if (this.init) {
            Err.todo("Already init!", this.obj, type);
        }
        this.obj = cr.instanceArgType(this.argPos, cr.execInit(this.call, streamIt), type);
        this.typecheck = new Class[]{type};
        this.init = true;
        return this.obj;
    }

    @SafeVarargs
    public final I_Object initExt(CallRuntime cr, I_Object streamIt, Class<? extends I_Object> ... types) {
        if (this.init) {
            Err.todo("Already init!", this.obj, this.call, streamIt, types);
        }
        this.obj = cr.instanceArgTypeExt(this.argPos, cr.execInit(this.call, streamIt), types);
        this.typecheck = types;
        this.init = true;
        return this.obj;
    }

    public I_Object get() {
        if (!this.init) {
            Err.invalid("ParCallBuffer not initialized!", this.call);
        }
        return this.obj;
    }

    @SafeVarargs
    public final I_Object getInitLoop(CallRuntime cr, I_Object streamIt, Class<? extends I_Object> ... types) {
        if (!this.init) {
            this.typecheck = types;
            this.init = true;
        }
        return cr.argTypeExt(cr.execInit(this.call, streamIt), this.typecheck);
    }

    @SafeVarargs
    public final I_Object getInitEach(CallRuntime cr, I_Object streamIt, I_Object each, Class<? extends I_Object> ... types) {
        if (!this.init) {
            this.typecheck = types;
            this.init = true;
        }
        return cr.argTypeExt(cr.execEachInit(this.call, streamIt, each), this.typecheck);
    }

    public void replace(Call c) {
        this.call = c;
    }

    public void describe(CallRuntime cr, int left) {
        String space = Lib_Parser.space(left);
        MOut.print(String.valueOf(space) + this.call.toStringExt(cr));
    }

    public String toStringExt(CallRuntime cr) {
        return Lib_Output.toStringExt(cr, this.call);
    }

    public String toString() {
        return this.obj != null ? Lib_Output.toString(this.obj, true) : Lib_Output.toString(this.call, false);
    }

    public Call getInternalCall() {
        return this.call;
    }
}

