/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.json;

import de.mn77.lib.json.KeyValue;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;

public class Lib_JsonDeserialize {
    public static Object parse(String s) throws ParseException {
        KeyValue entry = new KeyValue();
        int end = Lib_JsonDeserialize.parseValue(entry, s, 0);
        if ((end = Lib_JsonDeserialize.jumpOverWhitespace(s, end)) < s.length() - 1) {
            throw new ParseException("Trailing content: " + s.substring(end), end);
        }
        return entry.value;
    }

    public static HashMap<String, Object> parseMap(String s) throws ParseException {
        if (s.charAt(0) != '{') {
            throw new ParseException("Invalid opening char for JSON-object: " + s.charAt(0), -1);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        int len = s.length();
        KeyValue entry = null;
        int i = 1;
        while (i < len) {
            i = Lib_JsonDeserialize.jumpOverWhitespace(s, i);
            char c = s.charAt(i);
            if (entry == null) {
                if (c != ',') {
                    if (c == '}') {
                        return result;
                    }
                    entry = new KeyValue();
                    i = Lib_JsonDeserialize.parseKey(entry, s, i);
                }
            } else if (c == ':') {
                i = Lib_JsonDeserialize.parseValue(entry, s, i + 1);
                result.put(entry.key, entry.value);
                entry = null;
            } else {
                throw new ParseException("Invalid value, missing ':', but got" + c, i);
            }
            ++i;
        }
        return result;
    }

    private static int parseValue(KeyValue entry, String s, int i) throws ParseException {
        char c = s.charAt(i = Lib_JsonDeserialize.jumpOverWhitespace(s, i));
        if (c == '-' || c >= '0' && c <= '9') {
            return Lib_JsonDeserialize.parseNumber(entry, s, i);
        }
        if (c == '\"') {
            int end = Lib_JsonDeserialize.parseString(s, i);
            entry.value = Lib_JsonDeserialize.jsonToString(s, i, end);
            return end;
        }
        if (c == 'n' && s.startsWith("null", i)) {
            entry.value = null;
            return i + 4;
        }
        if (c == 't' && s.startsWith("true", i)) {
            entry.value = true;
            return i + 4;
        }
        if (c == 'f' && s.startsWith("false", i)) {
            entry.value = false;
            return i + 5;
        }
        if (c == '[') {
            int end = Lib_JsonDeserialize.parseGroup(s, i, '[', ']');
            entry.value = Lib_JsonDeserialize.parseList(s.substring(i, end + 1));
            return end + 1;
        }
        if (c == '{') {
            int end = Lib_JsonDeserialize.parseGroup(s, i, '{', '}');
            entry.value = Lib_JsonDeserialize.parseMap(s.substring(i, end + 1));
            return end + 1;
        }
        throw new ParseException("Invalid value: " + s.substring(i), i);
    }

    private static boolean isWhitespace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    private static int jumpOverWhitespace(String s, int idx) {
        if (idx > s.length() - 1) {
            return idx;
        }
        char c = s.charAt(idx);
        while (idx < s.length() - 1 && Lib_JsonDeserialize.isWhitespace(c)) {
            c = s.charAt(++idx);
        }
        return idx;
    }

    private static Object parseList(String s) throws ParseException {
        ArrayList<Object> al = new ArrayList<Object>();
        KeyValue entry = new KeyValue();
        if (s.charAt(0) != '[') {
            throw new ParseException("Leading bracket '[' is missing", -1);
        }
        int i = 1;
        while (i < s.length()) {
            char c = s.charAt(i = Lib_JsonDeserialize.jumpOverWhitespace(s, i));
            if (c != ',') {
                if (c == ']') {
                    return al;
                }
                i = Lib_JsonDeserialize.parseValue(entry, s, i);
                al.add(entry.value);
                entry.value = null;
            }
            ++i;
        }
        if (s.charAt(s.length() - 1) != ']') {
            throw new ParseException("Closing bracket ']' is missing", -1);
        }
        return al;
    }

    private static int parseNumber(KeyValue entry, String s, int start) {
        boolean hasDot = false;
        int i = start;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c != '-' && (c < '0' || c > '9') && c != '+' && c != 'E' && c != 'e') {
                if (c != '.') break;
                hasDot = true;
            }
            ++i;
        }
        String num = s.substring(start, i);
        entry.value = hasDot ? (Number)Double.parseDouble(num) : (Number)Long.parseLong(num);
        return i;
    }

    private static int parseKey(KeyValue entry, String s, int i) throws ParseException {
        i = Lib_JsonDeserialize.jumpOverWhitespace(s, i);
        int end = Lib_JsonDeserialize.parseString(s, i);
        entry.key = s.substring(i + 1, end);
        return end;
    }

    private static int parseString(String s, int i) throws ParseException {
        if (s.charAt(i) != '\"') {
            throw new ParseException("Invalid start for String, got: " + s.charAt(i), i);
        }
        int idx = i + 1;
        while (idx < s.length()) {
            char c = s.charAt(idx);
            if (c == '\\') {
                ++idx;
            } else if (c == '\"') {
                return idx;
            }
            ++idx;
        }
        throw new ParseException("Invalid end of String", i);
    }

    private static int parseGroup(String s, int i, char open, char close) throws ParseException {
        if (s.charAt(i) != open) {
            throw new ParseException("Invalid opening for Group. Missing " + open + ", but got: " + s.charAt(i), i);
        }
        boolean openString = false;
        int level = 1;
        int idx = i + 1;
        while (idx < s.length()) {
            char c = s.charAt(idx);
            if (c == '\\') {
                ++idx;
            } else if (c == '\"') {
                openString = !openString;
            } else if (!openString) {
                if (c == close && --level == 0) {
                    return idx;
                }
                if (c == open) {
                    ++level;
                }
            }
            ++idx;
        }
        String message = openString ? "Unclosed String." : "Group ends without closing '" + close + "'";
        throw new ParseException(message, i);
    }

    private static String jsonToString(String s, int i, int end) throws ParseException {
        s = s.substring(i + 1, end);
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        while (idx < s.length()) {
            block13: {
                char c0;
                block12: {
                    c0 = s.charAt(idx);
                    if (c0 != '\\' || idx + 1 >= s.length()) break block12;
                    char c1 = s.charAt(++idx);
                    switch (c1) {
                        case '\"': {
                            sb.append('\"');
                            break block13;
                        }
                        case '\\': {
                            sb.append('\\');
                            break block13;
                        }
                        case 'b': {
                            sb.append('\b');
                            break block13;
                        }
                        case 'f': {
                            sb.append('\f');
                            break block13;
                        }
                        case 'n': {
                            sb.append('\n');
                            break block13;
                        }
                        case 'r': {
                            sb.append('\r');
                            break block13;
                        }
                        case 't': {
                            sb.append('\t');
                            break block13;
                        }
                        case '/': {
                            sb.append('/');
                            break block13;
                        }
                        case 'u': {
                            String unicode = s.substring(idx + 1, idx + 5);
                            char cx = (char)Integer.parseInt(unicode, 16);
                            idx += 4;
                            sb.append(cx);
                            break block13;
                        }
                        default: {
                            throw new ParseException("Invalid escape char: " + c1, i);
                        }
                    }
                }
                sb.append(c0);
            }
            ++idx;
        }
        return sb.toString();
    }
}

