/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys.file;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.stream.Lib_Stream;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.file.MFile;
import de.mn77.base.sys.file.MFileSys;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class Lib_Jar {
    public static InputStream getJarStream(String file) throws Err_FileSys {
        Lib_Jar.iCheckFile(file);
        try {
            URL url = Lib_Jar.class.getResource(file);
            if (url == null) {
                Err.fsAccess("File is missing", file);
            }
            return Lib_Jar.class.getResourceAsStream(file);
        }
        catch (Err_FileSys e) {
            throw Lib_Jar.iError(e, file);
        }
    }

    public static File getFileCopy(String jarPath, String jarFilename, String jarSuffix) throws IOException, Err_FileSys {
        if (jarPath.endsWith("/")) {
            jarPath = jarPath.substring(0, jarPath.length() - 1);
        }
        InputStream is = Lib_Jar.getJarStream(String.valueOf(jarPath) + "/" + jarFilename + "." + jarSuffix);
        MFile tempFile = MFileSys.createTemp(jarFilename, jarSuffix);
        Lib_Stream.connect(is, tempFile.write(), false, true);
        return tempFile.getFile();
    }

    private static void iCheckFile(String file) {
        Err.ifEmpty(file);
        if (file.charAt(0) != '/') {
            Err.invalid(file, "Jar-Path must start with a '/'!");
        }
    }

    private static Err_FileSys iError(Err_FileSys e, String file) {
        MOut.print("File-Error: " + file);
        if (file.indexOf(47) < 0) {
            MOut.print("Maybe used '.' instead of '/' for pathseparator?!");
        }
        e.addDetail(file);
        return e;
    }
}

