/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct;

import de.mn77.base.data.Lib_Array;
import de.mn77.base.data.convert.ConvObject;
import de.mn77.base.data.struct.I_ListSet;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.data.struct.sort.Sort;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;

public abstract class A_ListSet<T>
implements Iterable<T>,
I_ListSet<T> {
    protected ArrayList<T> data = new ArrayList();

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public int getWidth() {
        return 1;
    }

    @Override
    public T get(int position) {
        Err.ifToSmall(1.0, this.size());
        Err.ifOutOfBounds(1.0, this.size(), position);
        return this.data.get(position - 1);
    }

    @Override
    public T getFirst() {
        return this.get(1);
    }

    @Override
    public T getLast() {
        return this.get(this.size());
    }

    @Override
    public T get(int col, int row) {
        Err.ifNot(1, col, "There's only 1 column available");
        return this.get(row);
    }

    @Override
    public I_List<T> getSelection(int ... positions) {
        MList result = new MList();
        int[] nArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            int p = nArray[n2];
            result.add(this.get(p));
            ++n2;
        }
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return this.data.iterator();
    }

    @Override
    public Stream<T> stream() {
        return this.data.stream();
    }

    @Override
    public boolean contains(Object o) {
        for (T t : this.data) {
            if (!o.equals(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public T[] toArray(Class<T> klasse) {
        T[] ta = Lib_Array.newArray(klasse, this.size());
        int i = 0;
        while (i < this.size()) {
            ta[i++] = this.get(i);
        }
        return ta;
    }

    @Override
    public String toStringDebug() {
        return this.toString();
    }

    public String toString() {
        if (this.size() <= 80) {
            boolean ok = true;
            for (T t : this) {
                if (ConvObject.toTextDebug(t).length() <= 80) continue;
                ok = false;
                break;
            }
            if (ok) {
                String result = "[";
                int i = 1;
                while (i <= this.size()) {
                    result = String.valueOf(result) + (i == 1 ? "" : ",") + ConvObject.toTextDebug(this.get(i));
                    ++i;
                }
                result = String.valueOf(result) + "]";
                return result;
            }
        }
        StringBuffer sb = new StringBuffer();
        int i = 1;
        while (i <= this.size()) {
            sb.append(i == 1 ? "[\n " : " ");
            sb.append(ConvObject.toTextDebug(this.get(i)));
            sb.append("\n");
            if (i == this.size()) {
                sb.append("]");
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public void describe() {
        MOut.debugOffset(1, this);
    }

    @Override
    public void sort(int ... columnOrder) {
        Sort.sort(this, columnOrder);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = false;
        for (T obj : c) {
            if (!this.add(obj)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public void addAllItems(T ... objects) {
        T[] TArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            T object = TArray[n2];
            this.add(object);
            ++n2;
        }
    }

    @Override
    public void exchange(int pos_a, int pos_b) {
        Err.ifOutOfBounds(1.0, this.data.size(), pos_a);
        Err.ifOutOfBounds(1.0, this.data.size(), pos_b);
        if (pos_a == pos_b) {
            MOut.warnung("Change of " + pos_a + " and " + pos_b + " not necessary!");
            return;
        }
        T buffer = this.data.get(--pos_a);
        this.data.set(pos_a, this.data.get(--pos_b));
        this.data.set(pos_b, buffer);
    }

    @Override
    public T removePosition(int pos) {
        Err.ifOutOfBounds(1.0, this.data.size(), pos);
        return this.data.remove(pos - 1);
    }

    @Override
    public T removeFirst() {
        return this.removePosition(1);
    }

    @Override
    public T removeLast() {
        return this.removePosition(this.size());
    }

    @Override
    public void set(int position, T obj) {
        Err.ifOutOfBounds(1.0, this.data.size(), position);
        this.data.set(position - 1, obj);
    }

    @Override
    public void clear() {
        this.data = new ArrayList();
    }

    @Override
    public void sortLike(int[] positions) {
        int size = this.data.size();
        Err.ifNot(size, positions.length, "List-items and order-positions must be equal");
        Object[] buffer = new Object[size];
        int i = 0;
        while (i < size) {
            buffer[i] = this.data.get(positions[i] - 1);
            ++i;
        }
        i = 0;
        while (i < buffer.length) {
            this.data.set(i, buffer[i]);
            ++i;
        }
    }

    @Override
    public void sortRandom() {
        Sort.random(this);
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        Err.ifNot(a.length, this.size());
        int i = 0;
        while (i < this.size()) {
            a[i] = this.data.get(i);
            ++i;
        }
        return a;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Err.todo(new Object[0]);
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.data.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Err.todo(new Object[0]);
        return false;
    }
}

