/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.data.type.datetime.MDate;
import de.mn77.base.error.Err;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Byte;
import org.jmo_lang.object.atom.JMo_Float;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.JMo_Short;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.immute.datetime.JMo_Date;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.object.struct.JMo_Map;
import org.jmo_lang.object.sys.JMo_Java;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;

public class Lib_Java {
    public static boolean assignment(Class<?> java, Class<?> jmo_object) {
        if (java == Object.class || jmo_object == Nil.class || jmo_object == Str.class && java == String.class) {
            return true;
        }
        if (jmo_object == Int.class && (java == Integer.TYPE || java == Integer.class)) {
            return true;
        }
        if (jmo_object == JMo_Byte.class && (java == Byte.TYPE || java == Byte.class)) {
            return true;
        }
        if (jmo_object == JMo_Short.class && (java == Short.TYPE || java == Short.class)) {
            return true;
        }
        if (jmo_object == JMo_Long.class && (java == Long.TYPE || java == Long.class)) {
            return true;
        }
        if (jmo_object == JMo_Float.class && (java == Float.TYPE || java == Float.class)) {
            return true;
        }
        if (jmo_object == Dec.class && (java == Double.TYPE || java == Double.class)) {
            return true;
        }
        if (jmo_object == Char.class && (java == Character.TYPE || java == Character.class || java == Integer.TYPE)) {
            return true;
        }
        if (jmo_object == Bool.class && (java == Boolean.TYPE || java == Boolean.class)) {
            return true;
        }
        return jmo_object == JMo_Java.class;
    }

    public static I_Object javaToJmo(Object java) {
        if (java == null) {
            return Nil.NIL;
        }
        if (java instanceof I_Object) {
            return (I_Object)java;
        }
        if (java instanceof Boolean) {
            return Bool.getObject((Boolean)java);
        }
        if (java instanceof Byte) {
            return new JMo_Byte((Byte)java);
        }
        if (java instanceof Short) {
            return new JMo_Short((Short)java);
        }
        if (java instanceof Integer) {
            return new Int((Integer)java);
        }
        if (java instanceof Long) {
            return new JMo_Long((Long)java);
        }
        if (java instanceof Float) {
            return new JMo_Float(((Float)java).floatValue());
        }
        if (java instanceof Double) {
            return new Dec((Double)java);
        }
        if (java instanceof Character) {
            return new Char(((Character)java).charValue());
        }
        if (java instanceof String) {
            return new Str((String)java);
        }
        if (java instanceof String[]) {
            ArrayList<I_Object> al = new ArrayList<I_Object>();
            String[] stringArray = (String[])java;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                al.add(new Str(s));
                ++n2;
            }
            return new JMo_List(al);
        }
        if (java instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String ds = sdf.format(java);
            return new JMo_Date(new MDate(ds));
        }
        if (java instanceof ArrayList) {
            ArrayList source = (ArrayList)java;
            ArrayList<I_Object> target = new ArrayList<I_Object>(source.size());
            for (Object o : source) {
                target.add(Lib_Java.javaToJmo(o));
            }
            return new JMo_List(target);
        }
        if (java instanceof HashMap) {
            HashMap source = (HashMap)java;
            JMo_Map target = new JMo_Map();
            for (Map.Entry e : source.entrySet()) {
                target.internalAdd(Lib_Java.javaToJmo(e.getKey()), Lib_Java.javaToJmo(e.getValue()));
            }
            return target;
        }
        return new JMo_Java(java);
    }

    public static Object jmoToJava(I_Object jmo) {
        if (jmo == Nil.NIL) {
            return null;
        }
        if (jmo instanceof JMo_Java) {
            return ((JMo_Java)jmo).getJavaObject();
        }
        if (jmo instanceof I_AtomicValue) {
            return ((I_AtomicValue)jmo).getValue();
        }
        if (jmo instanceof JMo_List) {
            Collection source = ((JMo_List)jmo).getInternalCollection();
            ArrayList<Object> al = new ArrayList<Object>(((ArrayList)source).size());
            for (I_Object o : source) {
                al.add(Lib_Java.jmoToJava(o));
            }
            return al;
        }
        if (jmo instanceof JMo_Map) {
            HashMap<I_Object, I_Object> source = ((JMo_Map)jmo).copyToHashMap();
            HashMap<Object, Object> target = new HashMap<Object, Object>();
            for (Map.Entry<I_Object, I_Object> e : source.entrySet()) {
                target.put(Lib_Java.jmoToJava(e.getKey()), Lib_Java.jmoToJava(e.getValue()));
            }
            return target;
        }
        throw Err.todo(jmo.getClass().getSimpleName(), jmo);
    }

    public static Object[] jmoToJava(I_Object[] args) {
        int len = args.length;
        Object[] result = new Object[len];
        int p = 0;
        while (p < len) {
            result[p] = Lib_Java.jmoToJava(args[p]);
            ++p;
        }
        return result;
    }

    public static Class<?> toJavaType(Object object) {
        if (object == null) {
            return Nil.class;
        }
        if (object instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (object instanceof Byte) {
            return Byte.TYPE;
        }
        if (object instanceof Short) {
            return Short.TYPE;
        }
        if (object instanceof Integer) {
            return Integer.TYPE;
        }
        if (object instanceof Long) {
            return Long.TYPE;
        }
        if (object instanceof Float) {
            return Float.TYPE;
        }
        if (object instanceof Double) {
            return Double.TYPE;
        }
        if (object instanceof Character) {
            return Character.TYPE;
        }
        return object.getClass();
    }

    public static boolean testPar(Parameter parameter, I_Object object) {
        Class<?> pClass = parameter.getType();
        int parModif = parameter.getModifiers();
        Class<?> oClass = object.getClass();
        if (parModif != 0) {
            Err.todo(pClass, parModif, oClass);
        }
        return Lib_Java.assignment(pClass, oClass);
    }

    public static boolean testPars(Parameter[] parameters, I_Object[] args) {
        if (parameters.length != args.length) {
            return false;
        }
        int pn = 0;
        while (pn < parameters.length) {
            if (!Lib_Java.testPar(parameters[pn], args[pn])) {
                return false;
            }
            ++pn;
        }
        return true;
    }

    public static ObjectCallResult exec(CallRuntime cr, Object instance, Class<?> instance_class, String m, I_Object streamIt) {
        String instanceClassName;
        Method[] methods;
        Err.ifNull(streamIt);
        I_Object[] args = cr.argsVar(streamIt, 0, 0);
        int parsLen = args.length;
        Method[] methodArray = methods = instance_class.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(m) && method.getParameterCount() == parsLen && Lib_Java.testPars(method.getParameters(), args)) {
                Object[] invokePars = Lib_Java.jmoToJava(args);
                method.setAccessible(true);
                Object result = null;
                try {
                    result = method.invoke(instance, invokePars);
                }
                catch (NullPointerException e) {
                    return null;
                }
                try {
                    return A_Object.stdResult(Lib_Java.javaToJmo(result));
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    String methodString = "Java(\"" + method.getDeclaringClass().getSimpleName() + "\")." + method.getName();
                    String msg = e instanceof IllegalAccessException ? "Illegal access to Java-method" : (e instanceof IllegalArgumentException ? "Illegal argument for Java-method" : "Invocation error");
                    throw new ExecError(cr, String.valueOf(msg) + ": " + methodString, Lib_Error.collectMessages(e));
                }
            }
            ++n2;
        }
        if (instance != null && (instanceClassName = instance.getClass().getName()).charAt(0) == '[') {
            int idx;
            if (m.equals("length")) {
                return A_Object.stdResult(new Int(Array.getLength(instance)));
            }
            if (m.equals("get") && args.length == 1) {
                I_Object paro = cr.argType(args[0], A_IntNumber.class);
                idx = Lib_Convert.getIntValue(cr, paro);
                Object result = Array.get(instance, idx);
                I_Object jmo = Lib_Java.javaToJmo(result);
                return A_Object.stdResult(jmo);
            }
            if (m.equals("set") && args.length == 2) {
                I_Object idxo = cr.argType(args[1], A_IntNumber.class);
                idx = Lib_Convert.getIntValue(cr, idxo);
                I_Object obj = args[0];
                Object javaObject = Lib_Java.jmoToJavaType(instanceClassName.charAt(1), obj);
                Array.set(instance, idx, javaObject);
                return A_Object.stdResult(streamIt);
            }
        }
        try {
            Field f = instance_class.getField(m);
            if (f != null) {
                Object value = f.get(instance);
                I_Object jmoValue = Lib_Java.javaToJmo(value);
                return A_Object.stdResult(jmoValue);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return null;
        }
        return null;
    }

    private static Object jmoToJavaType(char type, I_Object obj) {
        Object java = Lib_Java.jmoToJava(obj);
        if (java instanceof Number) {
            if (type == 'I') {
                return ((Number)java).intValue();
            }
            if (type == 'B') {
                return ((Number)java).byteValue();
            }
            if (type == 'S') {
                return ((Number)java).shortValue();
            }
            if (type == 'J') {
                return ((Number)java).longValue();
            }
            if (type == 'F') {
                return Float.valueOf(((Number)java).floatValue());
            }
            if (type == 'D') {
                return ((Number)java).doubleValue();
            }
        }
        return java;
    }
}

