/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.data.type.Lib_Class;
import de.mn77.base.error.Err;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jmo_lang.api.JMo_Object;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;

public class ClassFinder {
    private static ClassFinder singleton = null;
    private HashMap<String, Class<?>> javaJMoClasses = null;
    private final ArrayList<String> javaImportPackage = new ArrayList();
    private final ArrayList<String> javaImportClass = new ArrayList();

    public static ClassFinder getInstance() {
        if (singleton == null) {
            singleton = new ClassFinder();
        }
        return singleton;
    }

    private ClassFinder() {
        this.javaImportPackage.add("java.lang");
        this.javaImportPackage.add("java.util");
    }

    public Class<?> searchJMoClass(String name) {
        if (this.javaJMoClasses == null) {
            try {
                this.javaJMoClasses = this.iSearchJMoClasses();
            }
            catch (Exception e) {
                throw Err.exit(e);
            }
        }
        return this.javaJMoClasses.get(name);
    }

    public Class<?> searchJavaClass(String name) {
        Class<?> result = Lib_Class.getClassByPath(this.javaImportClass, name);
        if (result != null) {
            return result;
        }
        result = Lib_Class.getClassByPackage(this.javaImportPackage, name);
        if (result != null) {
            this.javaImportClass.add(result.getCanonicalName());
        }
        return result;
    }

    public void addJavaImport(String path, DebugInfo debug) {
        int len = path.length();
        boolean isPackage = false;
        if (len >= 2 && path.charAt(len - 1) == '*') {
            if (path.charAt(len - 2) != '.') {
                throw new ParseError("Invalid Java-Import", "Import must end with '.*', but got: " + path, debug);
            }
            isPackage = true;
            path = path.substring(0, len - 2);
            len -= 2;
        }
        if (len < 2) {
            throw new ParseError("Invalid Java-Package", "Got: " + path, debug);
        }
        int i = 0;
        while (i < len - 1) {
            char c = path.charAt(i);
            if (i == 0) {
                if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_')) {
                    throw new ParseError("Invalid Java-Package", "Got: " + path, debug);
                }
            } else {
                if (i == len - 1 && c == '.') {
                    throw new ParseError("Invalid Java-Package", "Got: " + path, debug);
                }
                if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '.' || c >= '0' && c <= '9' || c == '_')) {
                    throw new ParseError("Invalid Java-Package", "Got: " + path, debug);
                }
            }
            ++i;
        }
        if (isPackage) {
            this.javaImportPackage.add(path);
        } else {
            this.javaImportClass.add(path);
        }
    }

    private HashMap<String, Class<?>> iSearchJMoClasses() throws Exception {
        ArrayList classList = new ArrayList();
        try {
            CodeSource src = ClassFinder.class.getProtectionDomain().getCodeSource();
            Consumer<String> add = line -> {
                String filename = line.substring(line.lastIndexOf(47) + 1);
                if (filename.endsWith(".class") && !filename.contains("$") && filename.startsWith("JMo_")) {
                    try {
                        Class<?> c = Class.forName(this.iPathConvert((String)line));
                        if (I_Object.class.isAssignableFrom(c) || JMo_Object.class.isAssignableFrom(c)) {
                            classList.add(c);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        Err.show(e);
                        return;
                    }
                    catch (NoClassDefFoundError e) {
                        return;
                    }
                }
            };
            if (src.getLocation().toString().toLowerCase().endsWith(".jar")) {
                this.searchClassesFromJar(add);
            } else {
                this.searchClassesDirect(add);
            }
        }
        catch (Exception e) {
            Err.exit(e);
        }
        HashMap map = new HashMap();
        for (Class c : classList) {
            map.put(c.getSimpleName(), c);
        }
        return map;
    }

    private String iPathConvert(String line) {
        int start = 0;
        if (line.startsWith("/")) {
            start = 1;
        }
        line = line.replace('/', '.');
        return line.substring(start, line.lastIndexOf(46));
    }

    private void searchClassesDirect(Consumer<String> add) throws IOException, URISyntaxException, ClassNotFoundException {
        Enumeration<URL> eu = ClassFinder.class.getClassLoader().getResources("");
        while (eu.hasMoreElements()) {
            URI uri = eu.nextElement().toURI();
            Path myPath = Paths.get(uri);
            String base = myPath.toString();
            Stream<Path> walk = Files.walk(myPath, Integer.MAX_VALUE, new FileVisitOption[0]);
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                String line = ((Path)it.next()).toString();
                line = line.substring(base.length());
                add.accept(line);
            }
            walk.close();
        }
    }

    private void searchClassesFromJar(Consumer<String> add) throws IOException, ClassNotFoundException {
        String classpath = System.getProperty("java.class.path");
        String[] paths = classpath.split(System.getProperty("path.separator"));
        ArrayList<String> scanned = new ArrayList<String>();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (!scanned.contains(path)) {
                scanned.add(path);
                File file = new File(path);
                if (file.isFile()) {
                    ZipEntry e;
                    FileInputStream is = new FileInputStream(file);
                    ZipInputStream zip = new ZipInputStream(is);
                    while ((e = zip.getNextEntry()) != null) {
                        add.accept(e.getName());
                    }
                    zip.close();
                }
            }
            ++n2;
        }
    }
}

