/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser.obj;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import org.jmo_lang.core.Block;
import org.jmo_lang.core.Call;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.passthrough.Count;
import org.jmo_lang.object.passthrough.Group;
import org.jmo_lang.object.pseudo.NonAtomic;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.object.struct.JMo_Set;
import org.jmo_lang.parser.Parser_Call;
import org.jmo_lang.parser.Parser_Script;
import org.jmo_lang.parser.obj.I_ParseObject;
import org.jmo_lang.tools.Lib_Parser;

public class ParseObj_ShortCuts
implements I_ParseObject {
    private boolean group_ok = true;
    private boolean list_ok = true;
    private boolean for_ok = true;

    public void strict(boolean group_ok, boolean list_ok, boolean for_ok) {
        this.group_ok = group_ok;
        this.list_ok = list_ok;
        this.for_ok = for_ok;
    }

    @Override
    public boolean hits(char c0, Block current, String s) {
        switch (c0) {
            case '(': 
            case '[': 
            case '{': {
                return true;
            }
        }
        return false;
    }

    @Override
    public Group2<I_Object, String> parse(Parser_Script parser, Block current, String s) {
        switch (s.charAt(0)) {
            case '(': {
                return this.parseGroup(parser, current, s);
            }
            case '[': {
                return this.parseList(parser, current, s);
            }
            case '{': {
                return this.parseCount(parser, current, s);
            }
        }
        throw Err.impossible(s);
    }

    private Group2<I_Object, String> parseGroup(Parser_Script parser, Block current, String s) {
        if (!this.group_ok) {
            throw new ParseError("Strict: Shortcut of group is forbidden. Use Group()!", s, parser.getDebugInfo());
        }
        String group = Lib_Parser.group('(', ')', s, parser.getDebugInfo());
        String rem = s.substring(group.length() + 2);
        if ((group = group.trim()).length() == 0) {
            throw new ParseError("Missing argument for Group", s, parser.getDebugInfo());
        }
        Call arg = Parser_Call.parseCall(parser, current, group, true);
        return new Group2<I_Object, String>(new NonAtomic(Group.class, new Call[]{arg}), ".get()" + rem);
    }

    private Group2<I_Object, String> parseList(Parser_Script parser, Block current, String s) {
        if (!this.list_ok) {
            throw new ParseError("Strict: Shortcut of list is forbidden. Use List()!", s, parser.getDebugInfo());
        }
        String list = Lib_Parser.group('[', ']', s, parser.getDebugInfo());
        String rem = s.substring(list.length() + 2);
        Call[] args = Parser_Call.parseArguments(parser, current, list);
        Class cl = JMo_List.class;
        if (rem.length() > 0 && rem.charAt(0) == '?') {
            rem = rem.substring(1);
            cl = JMo_Set.class;
        }
        return new Group2<I_Object, String>(new NonAtomic(cl, args), rem);
    }

    private Group2<I_Object, String> parseCount(Parser_Script parser, Block current, String s) {
        if (!this.for_ok) {
            throw new ParseError("Strict: Shortcut of For is forbidden. Use For()!", s, parser.getDebugInfo());
        }
        String part = Lib_Parser.group('{', '}', s, parser.getDebugInfo());
        String rem = s.substring(1 + part.length() + 1);
        Call[] args = Parser_Call.parseArguments(parser, current, part);
        if (args.length == 0) {
            throw new ParseError("Missing argument", s, parser.getDebugInfo());
        }
        if (args.length > 3) {
            throw new ParseError("Too many arguments", s, parser.getDebugInfo());
        }
        Call from = args[0];
        Call to = args.length >= 2 ? args[1] : null;
        Call step = args.length == 3 ? args[2] : null;
        return new Group2<I_Object, String>(new NonAtomic(Count.class, new Call[]{from, to, step}), ".each()" + rem);
    }
}

