/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser.obj;

import de.mn77.base.data.filter.FilterString;
import de.mn77.base.data.group.Group2;
import org.jmo_lang.core.Block;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.ObjectManager;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.parser.Parser_Call;
import org.jmo_lang.parser.Parser_Script;
import org.jmo_lang.parser.obj.I_ParseObject;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_Prefix;
import org.jmo_lang.tools.Lib_Type;

public class ParseObj_NewWithOpenArg
implements I_ParseObject {
    public static final String NOT = ".=+-*/!<&>|^~\u2248";

    @Override
    public boolean hits(char c0, Block current, String s) {
        if (c0 != '_' && (c0 < 'A' || c0 > 'Z')) {
            return false;
        }
        int state = 0;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (state) {
                case 0: {
                    if (c == ' ' || c == '\t') {
                        state = 1;
                        break;
                    }
                    if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_') break;
                    return false;
                }
                case 1: {
                    if (NOT.indexOf(c) != -1) {
                        return false;
                    }
                    if (c == ' ' || c == '\t') break;
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Group2<I_Object, String> parse(Parser_Script parser, Block current, String s) {
        parser.app.strict.checkOpenArg(parser.getDebugInfo());
        String m = Lib_Parser.getName(s);
        String ps = s.substring(m.length());
        String rem = "";
        ps = FilterString.trimSpace(ps, true, true);
        if (parser.buffer.nextLevelDiff() > 0) {
            throw new ParseError("Invalid use of open argument", "Open argument is only allowed without a block. Please use brackets: " + m + "( " + ps + " )", parser.getDebugInfo());
        }
        if (ps.charAt(0) == '\t') {
            throw new ParseError("Invalid arguments for type", "Please remove tabulator char after: " + m, parser.getDebugInfo());
        }
        m = Lib_Prefix.addPrefix(m, parser);
        Lib_Type.checkValidity(m, parser);
        Call[] args = Parser_Call.parseArguments(parser, current, ps);
        if (args.length != 1) {
            throw new ParseError("Invalid amount of arguments", "Only 1 argument is allowed without brackets. Try it this way: " + m + '(' + ps + ')', parser.getDebugInfo());
        }
        I_Object o = ObjectManager.createNew(parser.app, current, m, args, parser.getDebugInfo());
        return new Group2<I_Object, String>(o, "");
    }
}

