/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.magic.var;

import de.mn77.base.error.Err;
import org.jmo_lang.core.Function;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.magic.I_Magic;
import org.jmo_lang.object.magic.I_MagicGet;
import org.jmo_lang.object.magic.var.A_MagicVar;

public class MagicVar
extends A_MagicVar
implements I_Magic,
I_MagicGet {
    private final MAGICVAR type;

    public MagicVar(MAGICVAR type) {
        super(false);
        this.type = type;
    }

    @Override
    public I_Object get(CallRuntime cr) {
        switch (this.type) {
            case FUNC: {
                Function f = cr.getSurrBlock().getFunction(cr);
                if (f != null) {
                    return f;
                }
                throw new ExecError(cr, "Invalid access to 'func'", "Can't call 'func' outside a function definition!");
            }
            case LOOP: {
                return cr.vce.loopGet(cr);
            }
        }
        throw Err.impossible(new Object[]{this.type});
    }

    @Override
    public String toStringExt(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public String toString() {
        if (this.type == MAGICVAR.LOOP) {
            return "loop";
        }
        if (this.type == MAGICVAR.FUNC) {
            return "func";
        }
        return "_" + (Object)((Object)this.type);
    }

    public static enum MAGICVAR {
        FUNC,
        LOOP;

    }
}

