/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.immute.datetime;

import de.mn77.base.data.convert.ConvSequence;
import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.data.type.datetime.I_Time;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.data.type.datetime.MTime;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.immute.datetime.A_DateTimeBase;
import org.jmo_lang.object.immute.datetime.JMo_Date;
import org.jmo_lang.object.immute.datetime.JMo_DateTime;
import org.jmo_lang.object.immute.datetime.Lib_DateTime_Format;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Type;

public class JMo_Time
extends A_DateTimeBase {
    private I_Time time = null;
    private final Call[] init;

    public JMo_Time(I_Time time) {
        this.init = null;
        this.time = time;
    }

    public JMo_Time() {
        this.init = null;
    }

    public JMo_Time(Call str) {
        this.init = new Call[]{str};
    }

    public JMo_Time(Call h, Call m) {
        this.init = new Call[]{h, m};
    }

    public JMo_Time(Call h, Call m, Call s) {
        this.init = new Call[]{h, m, s};
    }

    @Override
    public void init(CallRuntime cr) {
        block10: {
            if (this.time != null) {
                return;
            }
            String errPars = "";
            try {
                if (this.init == null) {
                    this.time = new MTime();
                    break block10;
                }
                if (this.init.length == 1) {
                    String s;
                    I_Object o = cr.execInit(this.init[0], this);
                    if (o instanceof A_IntNumber) {
                        int ih = Lib_Convert.getIntValue(cr, o);
                        errPars = "" + ih;
                        this.time = new MTime(ih, 0, 0);
                        break block10;
                    }
                    errPars = s = Lib_Convert.getStringValue(cr, o);
                    try {
                        this.time = new MTime(s);
                        break block10;
                    }
                    catch (Err_Runtime err) {
                        throw new ExecError(cr, "Can't create Time-Object", String.valueOf(err.getMessage()) + " Got: Time(" + s + ")");
                    }
                }
                if (this.init.length == 2) {
                    int ih = Lib_Convert.getIntValue(cr, cr.execInit(this.init[0], this));
                    int im = Lib_Convert.getIntValue(cr, cr.execInit(this.init[1], this));
                    errPars = String.valueOf(ih) + "," + im;
                    this.time = new MTime(ih, im, 0);
                } else {
                    int ih = Lib_Convert.getIntValue(cr, cr.execInit(this.init[0], this));
                    int im = Lib_Convert.getIntValue(cr, cr.execInit(this.init[1], this));
                    int is = Lib_Convert.getIntValue(cr, cr.execInit(this.init[2], this));
                    errPars = String.valueOf(ih) + "," + im + "," + is;
                    this.time = new MTime(ih, im, is);
                }
            }
            catch (Err_Runtime err) {
                throw new ExecError(cr, "Invalid time: " + ConvSequence.toText(", ", err.getDetails()), "Time(" + errPars + ")");
            }
        }
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "getHour": 
            case "getHours": {
                return A_Object.stdResult(this.getHours(cr));
            }
            case "getMin": 
            case "getMinutes": {
                return A_Object.stdResult(this.getMinutes(cr));
            }
            case "getSeconds": 
            case "getSec": {
                return A_Object.stdResult(this.getSeconds(cr));
            }
            case "addSec": 
            case "addSeconds": {
                return A_Object.stdResult(this.add(cr, true));
            }
            case "addMin": 
            case "addMinutes": {
                return A_Object.stdResult(this.addsubMinutes(cr, true));
            }
            case "addHours": {
                return A_Object.stdResult(this.addsubHours(cr, true));
            }
            case "subSec": 
            case "subSeconds": {
                return A_Object.stdResult(this.sub(cr, true));
            }
            case "subMin": 
            case "subMinutes": {
                return A_Object.stdResult(this.addsubMinutes(cr, false));
            }
            case "subHours": {
                return A_Object.stdResult(this.addsubHours(cr, false));
            }
            case "setHours": 
            case "setHour": {
                return A_Object.stdResult(this.setHour(cr));
            }
            case "setMinutes": 
            case "setMinute": {
                return A_Object.stdResult(this.setMinute(cr));
            }
            case "setSecond": 
            case "setSeconds": {
                return A_Object.stdResult(this.setSecond(cr));
            }
            case "diffHours": {
                return A_Object.stdResult(this.diffHours(cr));
            }
            case "diffMinutes": {
                return A_Object.stdResult(this.diffMinutes(cr));
            }
            case "diffSeconds": 
            case "diff": {
                return A_Object.stdResult(this.diffSeconds(cr));
            }
        }
        return null;
    }

    @Override
    public String toStringExt(CallRuntime cr) {
        if (this.time == null) {
            return "Time";
        }
        return "Time(" + this.toString() + ")";
    }

    @Override
    public String toString() {
        if (this.time == null) {
            return "Time";
        }
        return this.time.toString();
    }

    @Override
    public boolean equalsLazy(Object other) {
        if (other instanceof Str) {
            return ((Str)other).getValue().equals(this.time.toString());
        }
        return this.equals(other);
    }

    @Override
    protected boolean[] compare2(CallRuntime cr) {
        JMo_Time other = (JMo_Time)cr.args(this, JMo_Time.class)[0];
        boolean isEqual = this.time.isEqual(other.getInternalValue());
        boolean isGreater = this.time.isGreater(other.getInternalValue());
        return new boolean[]{isEqual, isGreater};
    }

    @Override
    public boolean equals(Object arg) {
        return arg instanceof JMo_Time ? this.time.isEqual(((JMo_Time)arg).getInternalTime()) : false;
    }

    private Int diffSeconds(CallRuntime cr) {
        JMo_Time arg = (JMo_Time)cr.args(this, JMo_Time.class)[0];
        int diff = this.time.diffSeconds(arg.getInternalValue());
        return new Int(diff);
    }

    private Int diffMinutes(CallRuntime cr) {
        JMo_Time arg = (JMo_Time)cr.args(this, JMo_Time.class)[0];
        int diff = this.time.diffMinutes(arg.getInternalValue());
        return new Int(diff);
    }

    private Int diffHours(CallRuntime cr) {
        JMo_Time arg = (JMo_Time)cr.args(this, JMo_Time.class)[0];
        int diff = this.time.diffHours(arg.getInternalValue());
        return new Int(diff);
    }

    private Int getSeconds(CallRuntime cr) {
        cr.args();
        return new Int(this.time.getSeconds());
    }

    private Int getMinutes(CallRuntime cr) {
        cr.args();
        return new Int(this.time.getMinutes());
    }

    private Int getHours(CallRuntime cr) {
        cr.args();
        return new Int(this.time.getHours());
    }

    private I_Object add(CallRuntime cr, boolean seconds) {
        I_Object arg;
        I_Object i_Object = arg = seconds ? cr.args(this, A_IntNumber.class)[0] : cr.argsExt(this, new Class[][]{{A_IntNumber.class, A_DateTimeBase.class}})[0];
        if (arg instanceof A_IntNumber) {
            int pari = Lib_Convert.getIntValue(cr, arg);
            I_Time date2 = this.time.getAddSeconds(pari);
            return new JMo_Time(date2);
        }
        if (arg instanceof JMo_Time) {
            I_Time part = ((JMo_Time)arg).getInternalTime();
            I_Time temp = this.time;
            temp = temp.getAddHours(part.getHours());
            temp = temp.getAddMinutes(part.getMinutes());
            temp = temp.getAddSeconds(part.getSeconds());
            return new JMo_Time(temp);
        }
        if (arg instanceof JMo_Date) {
            I_Date d = ((JMo_Date)arg).getInternalDate();
            MDateTime dt = new MDateTime(d, this.time);
            return new JMo_DateTime(dt);
        }
        if (arg instanceof JMo_DateTime) {
            I_DateTime temp = ((JMo_DateTime)arg).getInternalDateTime();
            temp = temp.getAddHours(this.time.getHours());
            temp = temp.getAddMinutes(this.time.getMinutes());
            temp = temp.getAddSeconds(this.time.getSeconds());
            return new JMo_DateTime(temp);
        }
        throw Err.impossible(Lib_Type.getName(arg));
    }

    private JMo_Time sub(CallRuntime cr, boolean seconds) {
        I_Object arg;
        I_Object i_Object = arg = seconds ? cr.args(this, A_IntNumber.class)[0] : cr.argsExt(this, new Class[][]{{A_IntNumber.class, JMo_Time.class}})[0];
        if (arg instanceof A_IntNumber) {
            int pari = Lib_Convert.getIntValue(cr, arg);
            I_Time date2 = this.time.getAddSeconds(-pari);
            return new JMo_Time(date2);
        }
        if (arg instanceof JMo_Time) {
            I_Time part = ((JMo_Time)arg).getInternalTime();
            I_Time temp = this.time;
            temp = temp.getAddHours(-part.getHours());
            temp = temp.getAddMinutes(-part.getMinutes());
            temp = temp.getAddSeconds(-part.getSeconds());
            return new JMo_Time(temp);
        }
        throw Err.impossible(Lib_Type.getName(arg));
    }

    private JMo_Time addsubMinutes(CallRuntime cr, boolean add) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        if (!add) {
            pari = -pari;
        }
        I_Time date2 = this.time.getAddMinutes(pari);
        return new JMo_Time(date2);
    }

    private JMo_Time addsubHours(CallRuntime cr, boolean add) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        if (!add) {
            pari = -pari;
        }
        I_Time date2 = this.time.getAddHours(pari);
        return new JMo_Time(date2);
    }

    private JMo_Time setHour(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_Time time2 = this.time.getSetHour(pari);
        return new JMo_Time(time2);
    }

    private JMo_Time setMinute(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_Time time2 = this.time.getSetMinute(pari);
        return new JMo_Time(time2);
    }

    private JMo_Time setSecond(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_Time time2 = this.time.getSetSecond(pari);
        return new JMo_Time(time2);
    }

    @Override
    protected JMo_Time incdec2(boolean inc, int amount) {
        if (inc) {
            I_Time date2 = this.time.getAddSeconds(amount);
            return new JMo_Time(date2);
        }
        I_Time date2 = this.time.getAddSeconds(-amount);
        return new JMo_Time(date2);
    }

    @Override
    protected JMo_Time limit(CallRuntime cr) {
        I_Object[] args = cr.args(this, JMo_Time.class, JMo_Time.class);
        I_Time min = ((JMo_Time)args[0]).time;
        I_Time max = ((JMo_Time)args[1]).time;
        if (this.time.isGreater(max)) {
            return (JMo_Time)args[1];
        }
        if (min.isGreater(this.time)) {
            return (JMo_Time)args[0];
        }
        return this;
    }

    @Override
    protected I_Object style(CallRuntime cr, A_DateTimeBase.COUNTRY country) {
        cr.args();
        switch (country) {
            case DE: {
                return Lib_DateTime_Format.format(cr, "hh:mm:ss", this.getInternalDate(), this.getInternalTime());
            }
            case EN: {
                return Lib_DateTime_Format.format(cr, "hh:mm:ss", this.getInternalDate(), this.getInternalTime());
            }
            case US: {
                return Lib_DateTime_Format.format(cr, "i:mm:ss p", this.getInternalDate(), this.getInternalTime());
            }
        }
        throw Err.impossible(new Object[]{country});
    }

    @Override
    protected Str toStr(CallRuntime cr) {
        cr.args();
        return new Str(this.time.toString());
    }

    private I_Time getInternalValue() {
        return this.time;
    }

    @Override
    protected I_Date getInternalDate() {
        return null;
    }

    @Override
    protected I_Time getInternalTime() {
        return this.time;
    }

    @Override
    protected I_Object addsub(CallRuntime cr, boolean add) {
        return add ? this.add(cr, false) : this.sub(cr, false);
    }
}

