/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.filesys;

import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.Sys;
import de.mn77.base.sys.file.Lib_FileSys;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.ExtError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.filesys.JMo_File;
import org.jmo_lang.object.filesys.JMo_Path;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.tools.Lib_Convert;

public class JMo_Dir
extends JMo_Path
implements I_Object {
    public JMo_Dir() {
        super(new File(Sys.getCurrentDir()));
    }

    public JMo_Dir(Call arg) {
        super(arg);
    }

    public JMo_Dir(File f) {
        super(f);
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        ObjectCallResult result = super.call2(cr, method);
        if (result != null) {
            return result;
        }
        switch (method) {
            case "list": {
                return A_Object.stdResult(this.iList(cr, true, true));
            }
            case "files": {
                return A_Object.stdResult(this.iList(cr, true, false));
            }
            case "dirs": {
                return A_Object.stdResult(this.iList(cr, false, true));
            }
            case "createDir": {
                return A_Object.stdResult(this.makeDir(cr, false));
            }
            case "makeDir": {
                return A_Object.stdResult(this.makeDir(cr, true));
            }
            case "deleteDir": {
                return A_Object.stdResult(this.deleteSub(cr, true));
            }
            case "deleteFile": {
                return A_Object.stdResult(this.deleteSub(cr, false));
            }
            case "create": {
                return A_Object.stdResult(this.create(cr, false));
            }
            case "make": {
                return A_Object.stdResult(this.create(cr, true));
            }
            case "rename": {
                return A_Object.stdResult(this.rename(cr));
            }
            case "move": {
                return A_Object.stdResult(this.move(cr));
            }
            case "delete": {
                return A_Object.stdResult(this.delete(cr));
            }
        }
        return null;
    }

    @Override
    public String toStringExt(CallRuntime cr) {
        if (this.getInternalFile() == null) {
            return "Dir()";
        }
        return "Dir(\"" + this.getInternalFile().getAbsolutePath().toString() + '\"' + ")";
    }

    @Override
    public String toString() {
        if (this.getInternalFile() == null) {
            return "Dir";
        }
        return this.getInternalFile().getAbsolutePath().toString();
    }

    private JMo_List iList(CallRuntime cr, boolean files, boolean dirs) {
        I_Object[] args = cr.argsVar(this, 0, 1);
        String filter = args.length == 0 ? null : ((Str)cr.argType(args[0], Str.class)).getValue();
        return this.iDirList(cr, files, dirs, filter);
    }

    private JMo_List iDirList(CallRuntime cr, boolean files, boolean dirs, String filter) {
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        if (filter == null) {
            File[] dirContent;
            File[] fileArray = dirContent = this.getInternalFile().listFiles();
            int n = dirContent.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.iDirListAdd(al, files, dirs, f);
                ++n2;
            }
        } else {
            DirectoryStream<Path> content = this.searchFiles(cr, filter);
            for (Path d : content) {
                this.iDirListAdd(al, files, dirs, d.toFile());
            }
        }
        return new JMo_List(al);
    }

    private void iDirListAdd(ArrayList<I_Object> al, boolean files, boolean dirs, File f) {
        boolean isf = f.isFile();
        if (isf && files) {
            al.add(new JMo_File(f));
        }
        if (!isf && dirs) {
            al.add(new JMo_Dir(f));
        }
    }

    private JMo_Dir create(CallRuntime cr, boolean lazy) {
        File f;
        cr.args();
        String path = this.getInternalFile().getAbsolutePath();
        if (!lazy && (f = new File(path)).exists()) {
            throw new ExtError(cr, "Can't create Directory", "Directory already exists: " + path);
        }
        try {
            Lib_FileSys.createPathStructure(path);
        }
        catch (Err_FileSys e) {
            throw new ExtError(cr, "Can't create Directory", path);
        }
        return this;
    }

    private JMo_Dir makeDir(CallRuntime cr, boolean lazy) {
        File f;
        Str arg = (Str)cr.args(this, Str.class)[0];
        String newDirName = arg.getValue();
        if (newDirName.contains(Sys.getSeperatorDir())) {
            throw new ExtError(cr, "Can't create Directory", "No target-path allowed");
        }
        String newDir = this.getInternalFile() + Sys.getSeperatorDir() + newDirName;
        if (!lazy && (f = new File(newDir)).exists()) {
            throw new ExtError(cr, "Can't create Directory", "Directory already exists: " + newDir);
        }
        try {
            Lib_FileSys.createPathStructure(newDir);
        }
        catch (Err_FileSys e) {
            throw new ExtError(cr, "Can't create Directory", newDirName);
        }
        return new JMo_Dir(new File(newDir));
    }

    private Bool deleteSub(CallRuntime cr, boolean dir) {
        String sep;
        Str arg = (Str)cr.args(this, Str.class)[0];
        String dirName = arg.getValue();
        if (dirName.contains(sep = Sys.getSeperatorDir())) {
            throw new ExtError(cr, "Invalid directory name", "Name contains directory separator: " + sep);
        }
        File f = new File(String.valueOf(this.getInternalFile().getAbsolutePath()) + sep + dirName);
        if (dir && f.isFile()) {
            throw new ExtError(cr, "Delete error", "The given name is not a directory: " + f.getAbsolutePath());
        }
        if (!dir && f.isDirectory()) {
            throw new ExtError(cr, "Delete error", "The given name is not a file: " + f.getAbsolutePath());
        }
        if (f.exists()) {
            boolean deleted = f.delete();
            return Bool.getObject(deleted);
        }
        return Bool.TRUE;
    }

    protected I_Object rename(CallRuntime cr) {
        Str arg = (Str)cr.args(this, Str.class)[0];
        String newName = Lib_Convert.getStringValue(cr, arg);
        if (newName.contains(Sys.getSeperatorDir())) {
            throw new ExtError(cr, "Directory-Rename failed", "No target-path allowed");
        }
        newName = String.valueOf(this.getInternalFile().getParent()) + Sys.getSeperatorDir() + newName;
        File newFile = new File(newName);
        boolean done = this.getInternalFile().renameTo(newFile);
        if (!done) {
            throw new ExtError(cr, "Directory-Rename failed", String.valueOf(this.getInternalFile().getAbsolutePath()) + " --> " + newFile.getAbsolutePath());
        }
        this.changeFile(newFile);
        return this;
    }

    private Bool delete(CallRuntime cr) {
        cr.args();
        File f = this.getInternalFile();
        if (f.exists()) {
            boolean deleted = f.delete();
            return Bool.getObject(deleted);
        }
        return Bool.TRUE;
    }

    private JMo_Path move(CallRuntime cr) {
        Str arg = (Str)cr.args(this, Str.class)[0];
        String newPath = Lib_Convert.getStringValue(cr, arg);
        File target = new File(newPath);
        try {
            Files.move(this.getInternalFile().toPath(), target.toPath(), new CopyOption[0]);
            this.changeFile(target);
            return this;
        }
        catch (IOException e) {
            throw new ExtError(cr, "Directory-Move-Error", String.valueOf(this.getInternalFile().getAbsolutePath()) + " --> " + target.getAbsolutePath());
        }
    }

    private DirectoryStream<Path> searchFiles(CallRuntime cr, String filter) {
        String path = super.getInternalFile().getAbsolutePath();
        try {
            DirectoryStream<Path> dirStream = Files.newDirectoryStream(Paths.get(path, new String[0]), filter);
            return dirStream;
        }
        catch (IOException e) {
            throw new ExtError(cr, "In/Out-Error", e.getMessage());
        }
    }
}

