/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.classic;

import de.mn77.base.data.Lib_Array;
import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import org.jmo_lang.core.ArgCallBuffer;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.I_AutoBlockDo;
import org.jmo_lang.core.I_AutoBlockList;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_ControlObject;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Range;
import org.jmo_lang.object.LoopHandle;
import org.jmo_lang.object.atom.A_Number;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_Decimal;
import org.jmo_lang.object.atom.I_Integer;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Byte;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.JMo_Short;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Exec;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_Type;

public class JMo_Count
extends A_Object
implements I_AutoBlockDo,
I_AutoBlockList,
I_ControlObject {
    private static final Class<? extends I_Object>[] typesStart = new Class[]{A_Number.class, Bool.class, Char.class, JMo_Range.class};
    private static final Class<? extends I_Object>[] typesEnd = new Class[]{A_Number.class, Bool.class, Char.class};
    private static final Class<? extends I_Object>[] typesStep = new Class[]{A_Number.class};
    private ArgCallBuffer start;
    private ArgCallBuffer end;
    private ArgCallBuffer step;

    public JMo_Count(Call end_or_range) {
        this(end_or_range, null, null);
    }

    public JMo_Count(Call start, Call end) {
        this(start, end, null);
    }

    public JMo_Count(Call start, Call end, Call step) {
        this.start = new ArgCallBuffer(1, start);
        this.end = end == null ? null : new ArgCallBuffer(2, end);
        this.step = step == null ? null : new ArgCallBuffer(3, step);
    }

    @Override
    public void init(CallRuntime cr) {
        this.start.initExt(cr, this, typesStart);
        if (this.end != null) {
            this.end.initExt(cr, this, typesEnd);
        }
        if (this.step != null) {
            this.step.init(cr, this, A_Number.class);
        }
        if (this.start != null && this.start.get() instanceof JMo_Range && this.step != null) {
            Lib_Error.ifArgs(3, 1, (Integer)2, cr, this);
        }
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "each": {
                return this.each(cr, false, true);
            }
            case "toList": {
                return this.each(cr, true, true);
            }
        }
        return null;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.each((CallRuntime)cr, (boolean)false, (boolean)true).obj;
    }

    @Override
    public ArrayList<I_Object> autoBlockToList(CallRuntime cr) {
        return ((JMo_List)this.each((CallRuntime)cr, (boolean)true, (boolean)false).obj).getInternalCollection();
    }

    @Override
    public void describe(CallRuntime cr, int left) {
        MOut.print(String.valueOf(Lib_Parser.space(left)) + this.toStringExt(cr));
    }

    public ObjectCallResult each(CallRuntime crOld, boolean toList, boolean execBlockStream) {
        ArrayList<I_Object> list;
        if (crOld.call == null && execBlockStream) {
            Err.invalid(crOld.call, toList, execBlockStream);
        }
        crOld.args();
        I_Object result = this;
        ArrayList<I_Object> arrayList = list = toList ? new ArrayList<I_Object>() : null;
        if (Lib_Type.typeIs(crOld, this.start.get(), JMo_Range.class)) {
            if (this.step != null) {
                throw new CodeError(crOld, "Invalid amount of arguments", "With Range, only 1 or 2 args are allowed.");
            }
            Group2<ArgCallBuffer, ArgCallBuffer> range = ((JMo_Range)this.start.get()).getInternalValues();
            this.start = (ArgCallBuffer)range.o1;
            if (this.end != null) {
                this.step = this.end;
            }
            this.end = (ArgCallBuffer)range.o2;
        }
        if (this.start != null && this.end == null && this.step == null) {
            this.end = this.start;
            this.start = new ArgCallBuffer(1, new Call(crOld.getSurrBlock(), new Int(1), crOld.getDebugInfo()));
            this.start.init(crOld, this, Int.class);
        }
        if (execBlockStream && crOld.getStream() == null && crOld.getCallBlock() == null) {
            return new ObjectCallResult(this.end.get(), true);
        }
        LoopHandle handle = new LoopHandle(this);
        CallRuntime crNew = crOld.copyLoop(handle);
        if (Lib_Type.typeIs(crNew, this.start.get(), I_Integer.class, Char.class) && Lib_Type.typeIs(crNew, this.end.get(), I_Integer.class, Char.class) && (this.step == null || Lib_Type.typeIs(crNew, this.step.get(), I_Integer.class))) {
            int i3;
            boolean desc;
            int i1 = Lib_Convert.getIntValue(crNew, this.start.get(), true);
            int i2 = Lib_Convert.getIntValue(crNew, this.end.get(), true);
            boolean bl = desc = i2 < i1;
            int n = this.step == null ? (desc ? -1 : 1) : (i3 = Lib_Convert.getIntValue(crNew, this.step.get()));
            if (desc && i3 > 0 || !desc && i3 < 0) {
                throw new ExecError(crNew, "Endless running loop", "From " + i1 + " to " + i2 + " with stepping " + i3);
            }
            int i = 0;
            I_Object it = null;
            i = i1;
            while (!(desc ? i < i2 : i > i2)) {
                handle.startLap();
                boolean last = desc ? i <= i2 : i >= i2;
                it = this.iEachIntToObject(Lib_Type.getType(crNew, this.start.get()), Lib_Type.getType(crNew, this.end.get()), i);
                if (toList) {
                    list.add(it);
                } else if (execBlockStream) {
                    result = Lib_Exec.execBlockStream(crNew, it);
                    if ((result = Lib_Exec.loopResult(result)) instanceof Return) {
                        return ((Return)result).getLoopResult();
                    }
                }
                if (!last) {
                    i1 = Lib_Convert.getIntValue(crNew, this.start.getInitLoop(crNew, this, typesStart), true);
                    i2 = Lib_Convert.getIntValue(crNew, this.end.getInitLoop(crNew, this, typesEnd), true);
                    boolean bl2 = desc = i2 < i1;
                    i3 = this.step == null ? (desc ? -1 : 1) : Lib_Convert.getIntValue(crNew, crNew.argType(this.step.getInitLoop(crNew, this, typesStep), Int.class));
                }
                i += i3;
            }
        } else if (Lib_Type.typeIs(crNew, this.start.get(), I_Decimal.class, I_Integer.class) && Lib_Type.typeIs(crNew, this.end.get(), I_Decimal.class, I_Integer.class) && (this.step == null || Lib_Type.typeIs(crNew, this.step.get(), I_Decimal.class, I_Integer.class))) {
            double d3;
            boolean desc;
            double d1 = Lib_Convert.getDoubleValue(crNew, this.start.get());
            double d2 = Lib_Convert.getDoubleValue(crNew, this.end.get());
            boolean bl = desc = d2 < d1;
            double d = this.step == null ? (double)(desc ? -1 : 1) : (d3 = Lib_Convert.getDoubleValue(crNew, this.step.get()));
            if (desc && d3 > 0.0 || !desc && d3 < 0.0) {
                throw new ExecError(crNew, "Endless running Counter", "From " + d1 + " to " + d2 + " with stepping " + d3);
            }
            double d4 = d1;
            while (!(desc ? !(d4 >= d2) : !(d4 <= d2))) {
                handle.startLap();
                boolean last = desc ? d4 <= d2 : d4 >= d2;
                Dec it = new Dec(d4);
                if (toList) {
                    list.add(it);
                } else if (execBlockStream) {
                    result = Lib_Exec.execBlockStream(crNew, it);
                    if ((result = Lib_Exec.loopResult(result)) instanceof Return) {
                        return ((Return)result).getLoopResult();
                    }
                }
                if (!last) {
                    d1 = Lib_Convert.getDoubleValue(crNew, this.start.getInitLoop(crNew, this, new Class[0]));
                    d2 = Lib_Convert.getDoubleValue(crNew, this.end.getInitLoop(crNew, this, new Class[0]));
                    boolean bl3 = desc = d2 < d1;
                    d3 = this.step == null ? (double)(desc ? -1 : 1) : Lib_Convert.getDoubleValue(crNew, crNew.argTypeExt(this.step.getInitLoop(crNew, this, new Class[0]), typesStep));
                }
                d4 += d3;
            }
        } else {
            throw new CodeError(crNew, "Invalid parameters", this.toStringExt(crNew));
        }
        return toList ? new ObjectCallResult(new JMo_List(list), false) : new ObjectCallResult(result, true);
    }

    @Override
    public String toStringExt(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public String toString() {
        String arg = this.start.toString();
        if (this.end != null) {
            arg = String.valueOf(arg) + "," + this.end.toString();
        }
        if (this.step != null) {
            arg = String.valueOf(arg) + "," + this.step.toString();
        }
        return "Count(" + arg + ")";
    }

    private I_Object iEachIntToObject(Class<?> start, Class<?> end, int i) {
        int idx_end;
        Class[] arr = new Class[]{Bool.class, JMo_Byte.class, JMo_Short.class, Int.class, JMo_Long.class, Char.class};
        int idx_start = Lib_Array.indexOf(start, arr);
        Class typ = arr[Math.max(idx_start, idx_end = Lib_Array.indexOf(end, arr))];
        if (typ == Bool.class) {
            return Bool.getObject(i != 0);
        }
        if (typ == JMo_Byte.class) {
            return new JMo_Byte((byte)i);
        }
        if (typ == JMo_Short.class) {
            return new JMo_Short((short)i);
        }
        if (typ == Int.class) {
            return new Int(i);
        }
        if (typ == JMo_Long.class) {
            return new JMo_Long(i);
        }
        if (typ == Char.class) {
            return new Char((char)i);
        }
        throw Err.todo(typ, i);
    }
}

