/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.lib.swing.layout;

import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JPanel;
import org.jmo_lang.core.ArgCallBuffer;
import org.jmo_lang.core.Call;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.lib.swing.A_Swing_Object;
import org.jmo_lang.lib.swing.I_SwingObj;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;

public class JMo_Swing_LayoutGrid
extends A_Swing_Object {
    private final JPanel container = new JPanel();
    private GridLayout grid;
    private final ArgCallBuffer par_dx;
    private final ArgCallBuffer par_dy;
    private int calc_dx;
    private int calc_dy;
    private int itemcount = 0;

    public JMo_Swing_LayoutGrid(Call dx, Call dy) {
        this.par_dx = new ArgCallBuffer(1, dx);
        this.par_dy = new ArgCallBuffer(2, dy);
    }

    @Override
    public void init(CallRuntime cr) {
        this.calc_dx = Lib_Convert.getIntValue(cr, this.par_dx.init(cr, this, A_IntNumber.class));
        this.calc_dy = Lib_Convert.getIntValue(cr, this.par_dy.init(cr, this, A_IntNumber.class));
        Lib_Error.ifTooSmall(cr, 0L, this.calc_dx);
        Lib_Error.ifTooSmall(cr, 0L, this.calc_dy);
        if (this.calc_dx == 0 && this.calc_dy == 0) {
            throw new ExecError(cr, "Invalid parameters", "Either X or Y can be 0, but not both!");
        }
        this.grid = new GridLayout(this.calc_dy, this.calc_dx);
        this.container.setLayout(this.grid);
    }

    @Override
    public Component getSwing() {
        return this.container;
    }

    @Override
    public I_Object callMethod2(CallRuntime cr, String method) {
        switch (method) {
            case "add": {
                return this.add(cr);
            }
            case "setColumns": {
                if (this.calc_dy > 0) {
                    throw new ExecError(cr, "Invalid call", "New column number cannot be set because rows are not 0");
                }
                int cols = Lib_Convert.getIntValue(cr, cr.args(this, A_IntNumber.class)[0]);
                this.grid.setColumns(cols);
                this.container.doLayout();
                return this;
            }
            case "setRows": {
                if (this.calc_dx > 0) {
                    throw new ExecError(cr, "Invalid call", "New row number cannot be set because columns are not 0");
                }
                int rows = Lib_Convert.getIntValue(cr, cr.args(this, A_IntNumber.class)[0]);
                this.grid.setRows(rows);
                this.container.doLayout();
                return this;
            }
        }
        return null;
    }

    private JMo_Swing_LayoutGrid add(CallRuntime cr) {
        I_Object[] oa;
        I_Object[] i_ObjectArray = oa = cr.argsFlex(this, 1, Integer.MAX_VALUE);
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            I_SwingObj so = (I_SwingObj)cr.argType(o, I_SwingObj.class);
            if (this.calc_dx > 0 && this.calc_dy > 0) {
                if (this.itemcount >= this.calc_dx * this.calc_dy) {
                    throw new ExecError(cr, "Too much Items", this.calc_dx + " x " + this.calc_dy + " = " + this.calc_dx * this.calc_dy + " Max! Got " + (this.itemcount + 1));
                }
                ++this.itemcount;
            }
            this.container.add(so.getSwing());
            ++n2;
        }
        return this;
    }

    @Override
    protected ObjectCallResult callEvent(CallRuntime cr, String event) {
        return null;
    }

    @Override
    protected boolean validateEvent(CallRuntime cr, String event) {
        return false;
    }
}

