/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.core.runtime;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.HashMap;
import java.util.Map;
import org.jmo_lang.core.ObjectManager;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_DecNumber;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_Decimal;
import org.jmo_lang.object.atom.I_Integer;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Byte;
import org.jmo_lang.object.atom.JMo_Float;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.JMo_Short;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.passthrough.Const;
import org.jmo_lang.object.passthrough.I_VarConst;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_Type;

public class VarEnv {
    private final VarEnv parent;
    private final boolean isConst;
    private HashMap<String, Group2<String, I_Object>> map = null;
    private I_Object itValue = Nil.NIL;

    public VarEnv(VarEnv parent, boolean isConst) {
        this.parent = parent;
        this.isConst = isConst;
    }

    public void describe(int left) {
        this.init();
        String space = Lib_Parser.space(left);
        MOut.print(String.valueOf(space) + this.toString());
        for (Map.Entry<String, Group2<String, I_Object>> g : this.map.entrySet()) {
            MOut.print(String.valueOf(space) + "  " + g.getKey() + " --> " + ((I_Object)g.getValue().o2).toString());
        }
        MOut.print(String.valueOf(space) + "Parent:");
        if (this.parent == null) {
            MOut.print(String.valueOf(space) + "  nil");
        } else {
            this.parent.describe(left + 1);
        }
    }

    public I_Object get(CallRuntime cr, I_VarConst vc) {
        if (vc.getName().equals("it")) {
            return this.itValue;
        }
        this.init();
        if (this.map.containsKey(vc.getName())) {
            I_Object result = (I_Object)this.map.get((Object)vc.getName()).o2;
            return result == null ? Nil.NIL : result;
        }
        if (this.parent != null && this.parent.knows(vc)) {
            return this.parent.get(cr, vc);
        }
        throw new CodeError(cr, "Access to uninitialized " + this.getTypeString(), vc.getName());
    }

    public I_Object get(CallRuntime cr, I_VarConst vc, I_Object ifNotSet) {
        this.init();
        return this.knows(vc) ? this.get(cr, vc) : ifNotSet;
    }

    public Group2<String, I_Object> getToCopy(String name, DebugInfo debug) {
        if (name.equals("it")) {
            Err.invalid(name);
        }
        this.init();
        if (this.map.containsKey(name)) {
            return this.map.get(name);
        }
        if (this.parent != null) {
            return this.parent.getToCopy(name, debug);
        }
        throw new CodeError("Access to uninitialized " + this.getTypeString(), name, debug);
    }

    public String getType(I_VarConst vc) {
        Group2 g = this.map.getOrDefault(vc, null);
        return g == null ? null : (String)g.o1;
    }

    public void setType(CallRuntime cr, I_VarConst vc, String type) {
        if (!ObjectManager.isTypeKnown(cr, type)) {
            throw new CodeError(cr, "Unknown type name", "Got: '" + type + "'");
        }
        Group2 g = this.map.getOrDefault(vc, null);
        if (g != null) {
            Err.invalid("Type already set!");
        }
        this.map.put(vc.getName(), new Group2<String, Object>(type, null));
    }

    public boolean isInitialized(I_VarConst vc) {
        return this.knows(vc);
    }

    public boolean knows(I_VarConst vc) {
        String name = vc.getName();
        if (name.equals("it")) {
            return true;
        }
        this.init();
        return this.map.containsKey(name) ? true : (this.parent != null ? this.parent.knows(vc) : false);
    }

    public void remove(Var v) {
        if (this.map == null) {
            return;
        }
        this.map.remove(v.getName());
    }

    public void set(CallRuntime cr, I_VarConst vc, I_Object obj, boolean typesafe, boolean nilable, boolean convert) {
        String vcName = vc.getName();
        if (obj == null) {
            throw new CodeError(cr, "No Object to set", vcName);
        }
        if (vcName.equals("it")) {
            this.itValue = Lib_Convert.getValue(cr, obj);
            return;
        }
        this.init();
        if (!this.map.containsKey(vcName) && this.parent != null && this.parent.knows(vc)) {
            this.parent.set(cr, vc, obj, typesafe, nilable, convert);
            return;
        }
        String objType = Lib_Type.getName(obj.getClass(), obj);
        String safedType = null;
        boolean isKnown = this.map.containsKey(vcName);
        if (isKnown) {
            safedType = (String)this.map.get((Object)vcName).o1;
        }
        obj = Lib_Convert.getValue(cr, obj);
        if (vc instanceof Const && this.map.get(vcName) != null && this.map.get((Object)vcName).o2 != null) {
            throw new ExecError(cr, "Constant value is already set and cannot be changed.", String.valueOf(vcName) + "=" + obj.toString());
        }
        if (!nilable && obj == Nil.NIL) {
            throw new ExecError(cr, "Invalid value for " + this.getTypeString(), "'" + vcName + " = " + Nil.NIL.toString() + "' is not valid, maybe try '" + vcName + "? = " + Nil.NIL.toString() + "'");
        }
        if (obj != null) {
            if (!isKnown) {
                if (typesafe && !objType.equals("Nil")) {
                    safedType = objType;
                }
            } else {
                String defType = (String)this.map.get((Object)vcName).o1;
                if (defType != null && convert) {
                    obj = this.iConvert(defType, objType, obj);
                    objType = Lib_Type.getName(obj);
                }
                if (typesafe && !objType.equals("Nil") && defType != null && !Lib_Type.isInstanceOf(obj, defType)) {
                    throw new ExecError(cr, "Invalid type for " + this.getTypeString() + ": " + vcName, "Need: <" + defType + ">, but got: " + Lib_Type.toStringExtWithType(cr, obj));
                }
            }
        }
        this.map.put(vcName, new Group2<String, I_Object>(safedType, obj));
    }

    public String toStringExt(CallRuntime cr, I_VarConst var, String ifNotSet) {
        this.init();
        return this.map.containsKey(var.getName()) ? this.get(cr, var).toStringExt(cr) : ifNotSet;
    }

    public String toString() {
        String sll = this.map == null ? "null" : "" + this.map.size();
        String sp = this.parent == null ? "" : " --> Parent: " + this.parent;
        return "VarEnv (Size:" + sll + ")" + sp;
    }

    private void init() {
        if (this.map == null) {
            this.map = new HashMap();
        }
    }

    private I_Object iConvert(String defType, String objType, I_Object obj) {
        block28: {
            boolean objIsInt;
            block26: {
                boolean objIsDec = obj instanceof I_Decimal;
                if (!objIsDec) break block26;
                switch (defType) {
                    case "Byte": {
                        return new JMo_Byte(((Number)((A_DecNumber)obj).getValue()).byteValue());
                    }
                    case "Short": {
                        return new JMo_Short(((Number)((A_DecNumber)obj).getValue()).shortValue());
                    }
                    case "Int": {
                        return new Int(((Number)((A_DecNumber)obj).getValue()).intValue());
                    }
                    case "Long": {
                        return new JMo_Long(((Number)((A_DecNumber)obj).getValue()).longValue());
                    }
                }
            }
            if (!(objIsInt = obj instanceof I_Integer)) break block28;
            switch (defType) {
                case "Float": {
                    return new JMo_Float(((Number)((A_IntNumber)obj).getValue()).floatValue());
                }
                case "Dec": {
                    return new Dec(((Number)((A_IntNumber)obj).getValue()).doubleValue());
                }
            }
        }
        return obj;
    }

    private final String getTypeString() {
        return this.isConst ? "constant" : "variable";
    }

    public void setCopy(String name, Group2<String, I_Object> g) {
        this.init();
        this.map.put(name, g);
    }
}

