/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.core;

import de.mn77.base.sys.MOut;
import java.util.HashMap;
import org.jmo_lang.core.Block;
import org.jmo_lang.core.EventManager;
import org.jmo_lang.core.FuncManager;
import org.jmo_lang.core.FunctionPar;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.parser.Parser_Script;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_Prefix;
import org.jmo_lang.tools.Lib_Type;

public class Type {
    private final String name;
    private final Block mainblock;
    private final FuncManager functions;
    private final EventManager events;
    private final FunctionPar[] args;
    private final String autoBlockFunction;
    private final boolean control;
    private final boolean varargs;
    private final int defaultArgs;
    private final HashMap<String, Type> selfTypes = new HashMap();
    private final I_Object parent;

    public Type(String name, FunctionPar[] args, String abf, boolean control, boolean varargs, Parser_Script parser, DebugInfo debug) {
        this(name, args, abf, control, varargs, parser, null, debug);
    }

    public Type(String name, FunctionPar[] args, String abf, boolean control, boolean varargs, Parser_Script parser, I_Object parent, DebugInfo debug) {
        this.name = Lib_Prefix.addPrefix(name, parser);
        if (parser != null) {
            Lib_Type.checkValidity(this.name, parser);
        }
        this.autoBlockFunction = abf;
        this.mainblock = new Block(this);
        this.parent = parent;
        this.functions = new FuncManager();
        this.events = new EventManager();
        this.control = control;
        this.varargs = varargs;
        this.args = args;
        int defArgCounter = 0;
        if (this.args != null) {
            FunctionPar[] functionParArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                FunctionPar arg = functionParArray[n2];
                if (arg.isConst) {
                    this.mainblock.getConstManager().define(arg.name, debug);
                } else {
                    this.mainblock.getVarManager().define(arg.name, debug);
                }
                if (arg.defaultValue != null) {
                    ++defArgCounter;
                }
                ++n2;
            }
        }
        this.defaultArgs = defArgCounter;
    }

    public void addType(Type typ, DebugInfo debug) {
        String newName = typ.getName();
        String newNameLower = newName.toLowerCase();
        for (String s : this.selfTypes.keySet()) {
            if (!newNameLower.equals(s.toLowerCase())) continue;
            String m2 = newName.equals(s) ? "You cannot redefine: " : "You cannot redefine '" + s + "' with: ";
            throw new ParseError("Type-Name already used!", String.valueOf(m2) + newName, debug);
        }
        this.selfTypes.put(newName, typ);
    }

    public void describe(CallRuntime cr, int depth) {
        String space = Lib_Parser.space(depth);
        MOut.print(String.valueOf(space) + this.toStringExt());
        if (this.functions != null) {
            this.functions.describe(cr, depth + 1);
        }
        if (this.events != null) {
            this.events.describe(cr, depth + 1);
        }
        if (this.mainblock != null) {
            this.mainblock.describe(cr, depth + 1);
        }
        if (this.selfTypes != null) {
            for (Type t : this.selfTypes.values()) {
                t.describe(cr, depth + 1);
            }
        }
    }

    public Block getBlock() {
        return this.mainblock;
    }

    public Type getType(String type) {
        return this.selfTypes.getOrDefault(type, null);
    }

    public EventManager getEvents() {
        return this.events;
    }

    public FuncManager getFunctions() {
        return this.functions;
    }

    public String getName() {
        return this.name;
    }

    public boolean isVarArgs() {
        return this.varargs;
    }

    public FunctionPar[] getVars() {
        return this.args;
    }

    public String getAutoBlockFunction() {
        return this.autoBlockFunction;
    }

    public boolean isControl() {
        return this.control;
    }

    public String toString() {
        return this.name;
    }

    public String toStringExt() {
        return "::" + this.name;
    }

    public int getDefaultArgs() {
        return this.defaultArgs;
    }

    public I_Object getParent() {
        return this.parent;
    }
}

