/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.core;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import org.jmo_lang.core.Block;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.I_ObjectToString;
import org.jmo_lang.tools.Lib_Function;
import org.jmo_lang.tools.Lib_Output;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_Prio;

public class Call
implements I_ObjectToString {
    public final DebugInfo debugInfo;
    public final I_Object object;
    public final String method;
    public final byte prio;
    public final Call[] argCalls;
    public final Block surrounding;
    private Block ownBlock = null;
    private Call stream = null;
    private String[] varsToCopy = null;

    public Call(Block surrBlock, I_Object obj, DebugInfo debugInfo) {
        this(surrBlock, obj, null, null, debugInfo);
    }

    public Call(Block surrBlock, I_Object obj, String met, Call[] args, DebugInfo debugInfo) {
        if (met != null && met.length() == 0) {
            Err.invalid(met);
        }
        Err.ifNull(surrBlock);
        this.surrounding = surrBlock;
        this.object = obj;
        this.method = met;
        this.argCalls = args;
        this.prio = (byte)(met == null || args != null && args.length != 1 ? 99 : (int)Lib_Prio.streamPrio(met, debugInfo));
        this.debugInfo = debugInfo;
    }

    public void describe(CallRuntime cr, int left) {
        String space = Lib_Parser.space(left);
        MOut.print(String.valueOf(space) + this.toStringExt(cr));
        if (this.ownBlock != null) {
            this.ownBlock.describe(cr, left + 1);
        }
        if (this.stream != null) {
            this.stream.describe(cr, left);
        }
    }

    public Call searchLastCall() {
        if (this.method != null && Lib_Function.isVarFunction(this.method) > -1 && this.argCalls != null && this.argCalls.length > 0) {
            return this.argCalls[0].searchLastCall();
        }
        if (this.stream == null) {
            return this;
        }
        return this.stream.searchLastCall();
    }

    public int getArgCount(CallRuntime cr) {
        return this.argCalls == null ? 0 : this.argCalls.length;
    }

    public void setBlock(Block b) {
        Err.ifNull(b);
        if (this.ownBlock != null) {
            Err.invalid(this.ownBlock, b);
        }
        this.ownBlock = b;
    }

    public Block getBlock() {
        return this.ownBlock;
    }

    public void setStream(Call c) {
        Err.ifNull(c);
        if (this.stream == null) {
            this.stream = c;
        } else {
            Err.invalid(this.toStringExt(null), this.stream, c);
        }
    }

    public Call getStream() {
        return this.stream;
    }

    public boolean hasBlock() {
        return this.ownBlock != null;
    }

    public boolean hasStream() {
        return this.stream != null;
    }

    public void setEventCopyVars(String[] varsToCopy) {
        this.varsToCopy = varsToCopy;
    }

    public String[] getEventCopyVars() {
        return this.varsToCopy;
    }

    @Override
    public String toString() {
        Group2<String, Boolean> g = Lib_Output.toObjectWithFunction(this.object, this.method);
        String p = Lib_Output.toString(this.argCalls, true);
        if (p.length() != 0) {
            p = (Boolean)g.o2 != false ? " " + p : "(" + p + ")";
        }
        String a = this.ownBlock != null || this.stream != null ? "\u2026" : "";
        return String.valueOf((String)g.o1) + p + a;
    }

    @Override
    public String toStringExt(CallRuntime cr) {
        String s;
        I_Object obj = this.object != null ? this.object : cr.getCurrentObject();
        Group2<String, Boolean> g = Lib_Output.toObjectWithFunction(cr, obj, this.method, true);
        String p = Lib_Output.toStringExt(cr, this.argCalls);
        if (p.length() != 0) {
            p = (Boolean)g.o2 != false ? " " + p : "(" + p + ")";
        }
        String b = this.ownBlock == null ? "" : "{<Block>}";
        String string = s = this.stream == null ? "" : "\u2026";
        if (this.method == null && this.ownBlock == null && this.stream == null) {
            return String.valueOf((String)g.o1) + p;
        }
        return String.valueOf((String)g.o1) + p + b + s;
    }

    @Override
    public String toStringFull(CallRuntime cr) {
        return this.toStringExt(cr);
    }
}

