/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.core;

import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.keymap.I_KeyList;
import de.mn77.base.data.struct.keymap.KeyList;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.event.Procedure;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.Sys;
import de.mn77.base.sys.file.I_File;
import de.mn77.base.sys.file.Lib_TextFile;
import de.mn77.base.sys.file.MFile;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jmo_lang.core.ObjectCallResult;
import org.jmo_lang.core.StrictManager;
import org.jmo_lang.core.Type;
import org.jmo_lang.core.runtime.CallRuntime;
import org.jmo_lang.core.runtime.Instance;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.parser.ParseManagerFunc;
import org.jmo_lang.parser.ParseManagerObj;

public class App
extends Instance {
    public static final String name = "App";
    private final I_KeyList<String, Boolean> imports = new KeyList<String, Boolean>();
    private I_File outputFile = null;
    public boolean genHints = false;
    private String[] args = null;
    private Consumer<String> outputConsumer = null;
    public final ParseManagerObj parsemanager_obj = new ParseManagerObj();
    public final ParseManagerFunc parsemanager_func = new ParseManagerFunc();
    public final StrictManager strict = new StrictManager(this.parsemanager_obj, this.parsemanager_func);
    public final boolean terminalRawMode;
    private boolean debug = false;
    private boolean terminate = false;
    private boolean keep = false;
    private boolean noHardExit = false;
    private ArrayList<Procedure> doAtCalledExit = null;
    private int activeForks = 0;

    public App(boolean terminalRawMode, boolean debug) {
        super(null, new Type("Root", null, null, false, false, null, null), null);
        Sys.correctCharset();
        this.terminalRawMode = terminalRawMode;
        this.debug = debug;
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult callMethod(CallRuntime cr, String method) {
        return super.callMethod(cr, method);
    }

    public void describe() {
        MOut.print("Unknown App");
        CallRuntime cr = new CallRuntime(this, null);
        this.getType().describe(cr, 0);
    }

    @Override
    protected boolean validateEvent(CallRuntime cr, String event) {
        if (event.equals("@exit")) {
            return true;
        }
        return super.validateEvent(cr, event);
    }

    public String execToExt(String[] args) {
        CallRuntime cr = new CallRuntime(this, null);
        this.args = args;
        I_Object result = this.iExec(cr, this);
        return result == null ? "" : result.toStringExt(cr);
    }

    public String exec(String[] args) {
        CallRuntime cr = new CallRuntime(this, null);
        this.args = args;
        I_Object result = this.iExec(cr, this);
        return result == null ? "" : result.toString();
    }

    public String exec(CallRuntime cr, App app) {
        I_Object result = this.iExec(cr, app);
        return result == null ? "" : result.toString();
    }

    public I_Object exit(CallRuntime cr, int exitState) {
        if (this.doAtCalledExit != null) {
            for (Procedure p : this.doAtCalledExit) {
                p.execute();
            }
        }
        this.terminate = true;
        if (exitState == 0) {
            this.checkExit(false);
        } else {
            this.iRunShutdownHooks(cr);
            if (!this.noHardExit) {
                System.exit(exitState);
            }
        }
        return this;
    }

    public void terminate() {
        this.terminate = true;
        this.checkExit(false);
    }

    public boolean toBeTerminated() {
        return this.terminate;
    }

    public I_Object getArgs() {
        int size = this.args == null ? 0 : this.args.length;
        ArrayList<I_Object> al = new ArrayList<I_Object>(size);
        if (size > 0) {
            String[] stringArray = this.args;
            int n = this.args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                al.add(new Str(arg));
                ++n2;
            }
        }
        JMo_List list = new JMo_List(al);
        list.readOnly();
        return list;
    }

    public Type getRootType() {
        return this.getType();
    }

    public I_File getOutputFile() {
        return this.outputFile;
    }

    public void importsAdd(String datei) {
        if (this.imports.getKeys().contains(datei)) {
            return;
        }
        this.imports.add(datei, false);
    }

    public boolean importsHasToParse() {
        for (Boolean b : this.imports.getObjects()) {
            if (b.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public I_File importsNext() {
        for (Group2 group2 : this.imports) {
            if (((Boolean)group2.o2).booleanValue()) continue;
            this.imports.set((String)group2.o1, true);
            return new MFile((String)group2.o1);
        }
        return null;
    }

    public I_Object setOutput(CallRuntime cr) {
        I_Object[] args = cr.args(this, Str.class, Bool.class);
        String file = ((Str)args[0]).getValue();
        MFile file2 = new MFile(file);
        this.setOutputFile(file2);
        boolean clear = ((Bool)args[1]).getValue();
        if (clear) {
            try {
                Lib_TextFile.set(this.outputFile.getFile(), "", true);
            }
            catch (Err_FileSys e) {
                Err.show(e);
            }
        }
        return this;
    }

    public void setOutputFile(I_File opf) {
        this.outputFile = opf;
    }

    public void setOutputRedirection(Consumer<String> c) {
        this.outputConsumer = c;
    }

    public boolean writeOutput(String s, boolean newline) {
        if (this.outputConsumer != null) {
            this.outputConsumer.accept(newline ? String.valueOf(s) + '\n' : s);
            return true;
        }
        return false;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public final void doAtCalledExit(Procedure p) {
        if (this.doAtCalledExit == null) {
            this.doAtCalledExit = new ArrayList();
        }
        this.doAtCalledExit.add(p);
    }

    private void iRunShutdownHooks(CallRuntime cr) {
        boolean terminateState = this.terminate;
        this.terminate = false;
        this.eventRunRaw(cr, "@exit", this);
        this.terminate = terminateState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iWaitForOtherThreads() {
        while (!this.terminate && (this.activeForks != 0 || this.keep)) {
            App app = this;
            synchronized (app) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkExit(boolean fromFork) {
        if (fromFork) {
            --this.activeForks;
        }
        App app = this;
        synchronized (app) {
            this.notify();
        }
    }

    public void registerFork() {
        ++this.activeForks;
    }

    public void setKeep(CallRuntime cr) {
        this.keep = true;
    }

    public void setNoHardExit() {
        this.noHardExit = true;
    }

    private I_Object iExec(CallRuntime cr, App app) {
        app.setMainEnv(cr.vce);
        I_Object result = null;
        try {
            result = app.getType().getBlock().execAppRoot(cr);
        }
        catch (ReturnException e) {
            Return temp = e.get();
            switch (temp.getLevel()) {
                case END: {
                    return temp.getResult();
                }
            }
            throw Err.todo(new Object[]{temp.getLevel()});
        }
        this.iWaitForOtherThreads();
        this.iRunShutdownHooks(cr);
        return result;
    }
}

