/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.lang;

import de.mn77.base.data.form.FormString;
import de.mn77.base.data.type.datetime.MDate;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.file.Lib_TextFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;

public class PotCreator {
    private final HashSet<String> messages = new HashSet();
    private String author = null;
    private String email = null;
    private String title = null;

    public void add(String s) {
        s = FormString.escapeSpecialChars(s, false, true);
        this.messages.add(s);
    }

    public void setAuthor(String name, String email) {
        this.author = name;
        this.email = email;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void create(File f, boolean overwrite) throws Err_FileSys {
        Err.ifNull(f);
        if (!overwrite && f.exists()) {
            throw new Err_FileSys("File already exists: " + f.getAbsolutePath(), new Object[0]);
        }
        Iterable<String> lines = this.iProcess();
        Lib_TextFile.set(f, lines, true);
    }

    private Iterable<String> iProcess() {
        int year = new MDate().getYear();
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("# " + (this.title != null ? this.title : "SOME DESCRIPTIVE TITLE."));
        lines.add("# Copyright (C) " + year + "  " + (this.author != null ? String.valueOf(this.author) + '<' + this.email + '>' : "THE PACKAGE'S COPYRIGHT HOLDER"));
        lines.add("#");
        lines.add("# Generated with PotCreator.class by Michael Nitsche <michael@mn77.de>");
        lines.add("#");
        lines.add("#, fuzzy");
        for (String message : this.messages) {
            lines.add("");
            lines.add("msgid \"" + message + "\"");
            lines.add("msgstr \"\"");
        }
        lines.add("");
        lines.add("");
        return lines;
    }
}

