/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.version;

import de.mn77.base.data.group.Group3;
import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.error.Err;
import de.mn77.base.version.A_VersionDataExt;
import de.mn77.base.version.VERSIONTYPE;
import de.mn77.base.version.VersionFormatter;

public class VersionData_ABC
extends A_VersionDataExt {
    private Integer medium;
    private final int dev;

    public VersionData_ABC(int big, int medium, int small) {
        super(big, VERSIONTYPE.RELEASE, small);
        this.medium = medium;
        this.dev = 0;
    }

    public VersionData_ABC(int big, int medium, int small, int dev) {
        super(big, VERSIONTYPE.RELEASE, small);
        this.medium = medium;
        this.dev = Math.abs(dev);
    }

    public VersionData_ABC(int big, int medium, int small, int dev, Long build, I_DateTime zeit) {
        this(big, medium, small, dev);
        this.update(build, zeit);
        throw Err.todo("!!! Testen !!!");
    }

    public VersionData_ABC(I_DateTime time, Long build, String[] sa) {
        super(time, build, sa);
        this.medium = Integer.parseInt(sa[1]);
        this.dev = Integer.parseInt(sa[2]);
    }

    protected Integer getMedium() {
        return this.medium;
    }

    protected int getDev() {
        return this.dev;
    }

    @Override
    public String toString() {
        return this.iToString(true);
    }

    public String toString_BuildDate() {
        return this.getBuild() + " - " + this.getTime().getDate();
    }

    public String toString_Short() {
        return this.iToString(false);
    }

    public String toString_Dots() {
        return this.iToString(true);
    }

    @Override
    public String toFormat(String format) {
        return new VersionFormatter().format(this, format);
    }

    @Override
    public Object[] toFileData() {
        return new Object[]{this.getNr(), this.medium, this.getFixnr(), this.dev};
    }

    @Override
    public char getDataSign() {
        return 'b';
    }

    @Override
    protected Group3<Integer, VERSIONTYPE, Integer> update(String[] sa) {
        this.medium = Integer.parseInt(sa[1]);
        return new Group3<Integer, VERSIONTYPE, Integer>(Integer.parseInt(sa[0]), VERSIONTYPE.RELEASE, Integer.parseInt(sa[2]));
    }

    private String iToString(boolean withBuild) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getNr() + "." + this.medium);
        if (this.getFixnr() != 0) {
            sb.append(".");
            sb.append(this.getFixnr());
        }
        if (this.getDev() != 0) {
            sb.append("dev");
            sb.append(this.getDev());
        }
        if (withBuild) {
            sb.append(" (Build: ");
            sb.append(this.getBuild());
            sb.append(" - ");
            sb.append(this.getTime());
            sb.append(")");
        }
        return sb.toString();
    }
}

