/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys;

import de.mn77.base.data.Lib_Describe;
import de.mn77.base.data.convert.ConvObject;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.data.type.datetime.MTime;
import de.mn77.base.debug.DEBUG_LEVEL;
import de.mn77.base.error.Err;
import de.mn77.base.error.I_ErrorDetails;
import de.mn77.base.error.I_ErrorInfo;
import de.mn77.base.sys.Log;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;

public class MOut {
    private static final int TRACELINES_SHORT = 5;
    private static final int TRACELINES_MEDIUM = 15;
    private static DEBUG_LEVEL debugLevel = DEBUG_LEVEL.NO;
    private static boolean log = false;
    private static String linebreak = System.lineSeparator();
    private static boolean java_errors = true;

    public static void main(String[] args) {
        MOut.echo("Foo");
        MOut.print("Foo");
        MOut.echoErr("Foo");
        MOut.printErr("Foo");
        Err.show(new RuntimeException("Foo"));
        MOut.line(new Object[0]);
        MOut.line("foo");
        MOut.line("bak", "bar");
    }

    public static DEBUG_LEVEL getDebugLevel() {
        return debugLevel;
    }

    public static String getLineBreak() {
        return linebreak;
    }

    public static void setDebug(DEBUG_LEVEL di) {
        debugLevel = di;
    }

    public static void debugNo() {
        debugLevel = DEBUG_LEVEL.NO;
    }

    public static void debugMin() {
        debugLevel = DEBUG_LEVEL.MINIMAL;
    }

    public static void debugDetail() {
        debugLevel = DEBUG_LEVEL.DETAIL;
    }

    public static void debugParanoid() {
        debugLevel = DEBUG_LEVEL.PARANOID;
    }

    public static void setLineBreak(String s) {
        linebreak = s;
    }

    public static void setJavaErrors(boolean b) {
        java_errors = b;
    }

    public static void useLog() {
        if (!Log.getActive()) {
            Err.forbidden("Log not activated!");
        } else {
            log = true;
        }
    }

    public static void error(String text) {
        MOut.error(new RuntimeException(), text);
    }

    public static void error(Throwable t) {
        MOut.error(t, null);
    }

    public static void error(Throwable t, String text) {
        MOut.error(t, text, false);
    }

    private static void error(Throwable t, String text, boolean isCause) {
        if (t == null) {
            t = new RuntimeException();
        } else if (!isCause && debugLevel.ordinal() >= DEBUG_LEVEL.DETAIL.ordinal()) {
            t = new RuntimeException(t);
        }
        StackTraceElement[] sta = t.getStackTrace();
        ArrayList<Object> list = new ArrayList<Object>();
        if (text != null) {
            list.add(text);
        }
        if (t instanceof I_ErrorInfo) {
            list.add(((I_ErrorInfo)((Object)t)).toInfo());
        } else {
            String className = java_errors && debugLevel.ordinal() > DEBUG_LEVEL.MINIMAL.ordinal() ? t.getClass().getName() : t.getClass().getSimpleName();
            list.add(String.valueOf(className) + ": " + t.getMessage());
            if (t instanceof I_ErrorDetails) {
                I_ErrorDetails bf = (I_ErrorDetails)((Object)t);
                for (Object o : bf.getDetails()) {
                    list.add(o);
                }
            }
        }
        MOut.iWrite(CHANNEL.STDERR, true, true, isCause, sta, list.toArray());
        if (t.getCause() != null) {
            MOut.error(t.getCause(), null, true);
        }
    }

    public static void warnung(Object ... oa) {
        if (debugLevel == DEBUG_LEVEL.NO) {
            return;
        }
        StackTraceElement[] trace = new Throwable().getStackTrace();
        MOut.iWrite(CHANNEL.STDERR, false, true, false, trace, oa);
    }

    public static void echo(Object o) {
        String s = ConvObject.toTextOutput(o);
        if (debugLevel == DEBUG_LEVEL.NO) {
            MOut.iWrite(CHANNEL.STDOUT, false, false, false, null, s);
        } else {
            StackTraceElement[] trace = new Throwable().getStackTrace();
            MOut.iWrite(CHANNEL.STDOUT, false, false, false, trace, s);
        }
    }

    public static void print(Object ... oa) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < oa.length) {
            if (i > 0) {
                sb.append(linebreak);
            }
            sb.append(ConvObject.toTextOutput(oa[i]));
            ++i;
        }
        if (debugLevel == DEBUG_LEVEL.NO) {
            MOut.iWrite(CHANNEL.STDOUT, false, true, false, null, sb.toString());
        } else {
            StackTraceElement[] trace = new Throwable().getStackTrace();
            MOut.iWrite(CHANNEL.STDOUT, false, true, false, trace, sb.toString());
        }
    }

    public static void echoErr(Object o) {
        String s = ConvObject.toTextOutput(o);
        if (debugLevel == DEBUG_LEVEL.NO) {
            MOut.iWrite(CHANNEL.STDERR, false, false, false, null, s);
        } else {
            StackTraceElement[] trace = new Throwable().getStackTrace();
            MOut.iWrite(CHANNEL.STDERR, false, false, false, trace, s);
        }
    }

    public static void printErr(Object ... oa) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < oa.length) {
            if (i > 0) {
                sb.append(linebreak);
            }
            sb.append(ConvObject.toTextOutput(oa[i]));
            ++i;
        }
        if (debugLevel == DEBUG_LEVEL.NO) {
            MOut.iWrite(CHANNEL.STDERR, false, true, false, null, sb.toString());
        } else {
            StackTraceElement[] trace = new Throwable().getStackTrace();
            MOut.iWrite(CHANNEL.STDERR, false, true, false, trace, sb.toString());
        }
    }

    public static void debug(Object ... oa) {
        if (debugLevel == DEBUG_LEVEL.NO) {
            return;
        }
        StackTraceElement[] trace = new Throwable().getStackTrace();
        MOut.iWrite(CHANNEL.STDOUT, false, true, false, trace, oa);
    }

    public static void debugOffset(int offset, Object ... oa) {
        if (debugLevel == DEBUG_LEVEL.NO) {
            return;
        }
        StackTraceElement[] trace = new Throwable().getStackTrace();
        Err.ifOutOfBounds(0.0, Math.min(trace.length - 2, 3), offset);
        int destLen = trace.length - offset;
        StackTraceElement[] trace2 = new StackTraceElement[destLen];
        System.arraycopy(trace, offset, trace2, 0, destLen);
        MOut.iWrite(CHANNEL.STDOUT, false, true, false, trace2, oa);
    }

    public static void originLine(int offset) {
        StackTraceElement[] trace = new Throwable().getStackTrace();
        offset = Math.min(trace.length - 1, offset);
        String msg = offset >= trace.length ? "" : "   @ " + trace[offset].toString();
        MOut.iWrite(CHANNEL.STDOUT, false, true, false, trace, msg);
    }

    public static void dev(Object ... oa) {
        if (debugLevel == DEBUG_LEVEL.NO || debugLevel == DEBUG_LEVEL.MINIMAL) {
            return;
        }
        StackTraceElement[] sta = new Throwable().getStackTrace();
        MOut.iWrite(CHANNEL.STDOUT, false, true, false, sta, oa);
    }

    public static void exit(Object ... oa) {
        StackTraceElement[] sta = new Throwable().getStackTrace();
        debugLevel = DEBUG_LEVEL.DETAIL;
        MOut.iWrite(CHANNEL.STDOUT, true, true, false, null, oa);
        debugLevel = DEBUG_LEVEL.PARANOID;
        MOut.iWrite(CHANNEL.STDOUT, true, true, true, sta, "Stop for debugging!");
        System.exit(1);
    }

    public static void temp(Object ... oa) {
        StackTraceElement[] trace = new Throwable().getStackTrace();
        StringBuffer sb = new StringBuffer();
        sb.append("--- Temp-Debug-Info --- " + linebreak);
        Object[] objectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            sb.append(String.valueOf(ConvObject.toTextDebug(o)) + linebreak);
            ++n2;
        }
        sb.deleteCharAt(sb.length() - 1);
        MOut.iWrite(CHANNEL.STDERR, true, true, false, trace, sb.toString());
    }

    public static void describe(Object o) {
        StackTraceElement[] trace = new Throwable().getStackTrace();
        StringBuffer sb = new StringBuffer();
        Lib_Describe.describe(sb, o);
        MOut.iWrite(CHANNEL.STDOUT, false, true, false, trace, sb.toString());
    }

    public static void trace(Object ... oa) {
        StackTraceElement[] trace = new Throwable().getStackTrace();
        StringBuffer sb = new StringBuffer();
        sb.append("--- Trace-Debug-Info --- " + linebreak);
        Object[] objectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            sb.append(String.valueOf(ConvObject.toTextDebug(o)) + linebreak);
            ++n2;
        }
        sb.deleteCharAt(sb.length() - 1);
        DEBUG_LEVEL debug_mem = debugLevel;
        debugLevel = DEBUG_LEVEL.PARANOID;
        MOut.iWrite(CHANNEL.STDERR, true, true, false, trace, sb.toString());
        debugLevel = debug_mem;
    }

    public static void line(Object ... oa) {
        StackTraceElement[] trace = new Throwable().getStackTrace();
        StringBuffer sb = new StringBuffer();
        sb.append("--- Debug-Line");
        if (oa.length > 0) {
            sb.append(":  ");
        }
        if (oa.length > 1) {
            sb.append('\n');
        }
        Object[] objectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            sb.append(String.valueOf(ConvObject.toTextDebug(o)) + linebreak);
            ++n2;
        }
        sb.append("   ");
        if (trace.length > 2) {
            sb.append("@ ");
            sb.append(trace[2]);
            sb.append(", ");
        }
        sb.append("@ ");
        sb.append(trace[1]);
        MOut.iWrite(CHANNEL.STDOUT, false, true, false, trace, sb.toString());
    }

    public static OutputStream streamText() {
        return MOut.iStream(CHANNEL.STDOUT);
    }

    public static OutputStream streamError() {
        return MOut.iStream(CHANNEL.STDERR);
    }

    private static PrintStream iStream(final CHANNEL channel) {
        return new PrintStream(new OutputStream(){
            private final StringBuilder sb = new StringBuilder();

            @Override
            public void write(int i) throws IOException {
                this.sb.append(new String(new byte[]{(byte)i}));
            }

            @Override
            public void close() throws IOException {
                super.close();
                MOut.iWrite(channel, false, true, false, null, this.sb.toString());
            }
        });
    }

    private static synchronized void iWrite(CHANNEL channel, boolean error, boolean newline, boolean addOn, StackTraceElement[] trace, Object ... oa) {
        ArrayList<String> lines = new ArrayList<String>();
        if (addOn) {
            lines.add("");
        }
        if (!addOn && (error || debugLevel.ordinal() >= DEBUG_LEVEL.DETAIL.ordinal())) {
            lines.add(new MDateTime().toString());
        }
        Object[] objectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            lines.add(error || debugLevel.ordinal() <= DEBUG_LEVEL.MINIMAL.ordinal() ? ConvObject.toTextOutput(o) : ConvObject.toTextDebug(o));
            ++n2;
        }
        if (java_errors && trace != null) {
            String indent = "   ";
            if (error || debugLevel.ordinal() > DEBUG_LEVEL.DETAIL.ordinal()) {
                int got = 0;
                int maxLines = debugLevel.ordinal() >= DEBUG_LEVEL.DETAIL.ordinal() ? 1000 : (error ? 15 : 5);
                int traceIdx = 0;
                while (traceIdx < trace.length - 1) {
                    StackTraceElement st = trace[traceIdx];
                    String stt = st.toString();
                    if (!(debugLevel != DEBUG_LEVEL.PARANOID && (stt.matches("^(sun|java)\\..*$") || stt.matches("^.*:1\\)$")) || debugLevel.ordinal() <= DEBUG_LEVEL.MINIMAL.ordinal() && (stt.contains(MOut.class.getName()) || stt.contains(Err.class.getName()) || stt.indexOf("Err") >= 0 || stt.matches("^de.mn77.base.error.*$")))) {
                        lines.add("   @ " + stt);
                        if (++got >= maxLines) break;
                    }
                    ++traceIdx;
                }
                lines.add("   > " + trace[trace.length - 1]);
            } else if (debugLevel.ordinal() >= DEBUG_LEVEL.DETAIL.ordinal()) {
                lines.add("   @ " + trace[1].toString());
            }
        }
        String trenner = "";
        if (java_errors && debugLevel.ordinal() >= DEBUG_LEVEL.DETAIL.ordinal()) {
            trenner = String.valueOf(trenner) + new MTime().toString() + " | ";
        }
        String s = String.valueOf(trenner) + String.join((CharSequence)(String.valueOf(linebreak) + trenner), lines);
        if (!addOn && (error || debugLevel.ordinal() >= DEBUG_LEVEL.DETAIL.ordinal())) {
            s = String.valueOf(linebreak) + s;
        }
        MOut.iOutput(channel, newline, s);
    }

    private static void iOutput(CHANNEL channel, boolean newline, String s) {
        if (channel == CHANNEL.STDERR) {
            System.err.print(s);
            if (newline) {
                System.err.print(linebreak);
            }
        } else {
            System.out.print(s);
            if (newline) {
                System.out.print(linebreak);
            }
        }
        if (log) {
            Log.write(s);
        }
    }

    private static enum CHANNEL {
        STDOUT,
        STDERR;

    }
}

