/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.form;

import de.mn77.base.data.Lib_String;
import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.base.data.convert.ConvChar;
import de.mn77.base.data.filter.FilterString;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;

public class FormString {
    public static String width(int width, String s, boolean cutOverflow) {
        return FormString.width(width, ' ', s, POSITION_H.LEFT, cutOverflow);
    }

    public static String width(int width, char fill, String t, POSITION_H align, boolean cutOverflow) {
        Err.ifToSmall(0.0, width);
        Err.ifNull(t, align);
        int space = width - t.length();
        if (align == POSITION_H.CENTER) {
            if (space >= 0) {
                t = String.valueOf(Lib_String.sequence(fill, (long)((int)Math.floor((double)space / 2.0)))) + t + Lib_String.sequence(fill, (long)((int)Math.ceil((double)space / 2.0)));
            } else {
                String string = t = cutOverflow ? t.substring(0, t.length() + space) : t;
            }
        }
        if (align == POSITION_H.LEFT) {
            if (space >= 0) {
                t = String.valueOf(t) + Lib_String.sequence(fill, (long)space);
            } else {
                String string = t = cutOverflow ? t.substring(0, t.length() + space) : t;
            }
        }
        if (align == POSITION_H.RIGHT) {
            t = space >= 0 ? String.valueOf(Lib_String.sequence(fill, (long)space)) + t : (cutOverflow ? t.substring(-space, t.length()) : t);
        }
        return t;
    }

    public static String length(int length, String s, boolean cutOverflow) {
        return length >= 0 ? FormString.width(length, ' ', s, POSITION_H.LEFT, cutOverflow) : FormString.width(Math.abs(length), ' ', s, POSITION_H.RIGHT, cutOverflow);
    }

    private static String toSQL_Exec(String s) {
        Err.ifNull(s);
        s = s.replaceAll("'", "''");
        return s;
    }

    public static String toSQL_Text(String s) {
        return "'" + FormString.toSQL_Exec(s) + "'";
    }

    public static String toSQL_Identifier(String s) {
        Err.ifNull(s);
        return FilterString.only(("abcdefghijklmnopqrstuvwxyz" + "abcdefghijklmnopqrstuvwxyz".toUpperCase() + "_").toCharArray(), s);
    }

    public static String toFilename(String s) {
        Err.ifNull(s);
        String allowed = String.valueOf("abcdefghijklmnopqrstuvwxyz\u00df\u00e4\u00f6\u00fc".toUpperCase()) + "abcdefghijklmnopqrstuvwxyz\u00df\u00e4\u00f6\u00fc".toLowerCase() + "0123456789" + "_- #.,'(){}[]&";
        return FilterString.only(allowed.toCharArray(), s);
    }

    public static String toHTMLChars(String s) {
        s = s.replaceAll("&", "&amp;");
        HTML_CHARS[] hTML_CHARSArray = HTML_CHARS.values();
        int n = hTML_CHARSArray.length;
        int n2 = 0;
        while (n2 < n) {
            HTML_CHARS hc = hTML_CHARSArray[n2];
            s = s.replaceAll("" + hc.chars, hc.html);
            ++n2;
        }
        return s;
    }

    public static String fromHTMLChars(String s) {
        HTML_CHARS[] hTML_CHARSArray = HTML_CHARS.values();
        int n = hTML_CHARSArray.length;
        int n2 = 0;
        while (n2 < n) {
            HTML_CHARS hc = hTML_CHARSArray[n2];
            s = s.replaceAll(hc.html, "" + hc.chars);
            ++n2;
        }
        s = s.replaceAll("&amp;", "&");
        return s;
    }

    public static String fill(String template, String ... values) {
        Err.ifNull(template, values);
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Err.ifNull(s);
            ++n2;
        }
        Err.ifToBig(27.0, values.length);
        int i = 0;
        while (i < values.length) {
            String suche = "%" + "abcdefghijklmnopqrstuvwxyz".charAt(i);
            template = template.replaceAll(suche, values[i]);
            ++i;
        }
        return template;
    }

    public static String limit(String s, int maxLength, String finishItWith) {
        Err.ifToSmall(finishItWith.length(), maxLength);
        if (s.length() <= maxLength) {
            return s;
        }
        return String.valueOf(FilterString.cut(maxLength - finishItWith.length(), true, s)) + finishItWith;
    }

    public static String quote(String value, char quote, char insideprefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(quote);
        char[] cArray = value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == quote) {
                sb.append("" + insideprefix + quote);
            } else if (c > '\u00ff') {
                sb.append(ConvChar.getUnicode(c));
            } else {
                switch (c) {
                    case '\n': {
                        sb.append("\\n");
                        break;
                    }
                    case '\t': {
                        sb.append("\\t");
                        break;
                    }
                    case '\r': {
                        sb.append("\\r");
                        break;
                    }
                    case '\f': {
                        sb.append("\\f");
                        break;
                    }
                    case '\b': {
                        sb.append("\\b");
                        break;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            ++n2;
        }
        sb.append(quote);
        return sb.toString();
    }

    public static String unquote(String value, char quote, char insideprefix) {
        Err.ifNull(value);
        int len = value.length();
        int left = 0;
        int right = len;
        if (len > 0 && value.charAt(0) == quote) {
            left = 1;
        }
        if (len > 1 && value.charAt(len - 1) == quote) {
            --right;
        }
        value = value.substring(left, right);
        len = value.length();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < len) {
            block30: {
                String check;
                char c;
                block29: {
                    c = value.charAt(i);
                    check = value.substring(i, Math.min(len, i + 2));
                    if (!check.equals("" + insideprefix + quote)) break block29;
                    sb.append(quote);
                    ++i;
                    break block30;
                }
                switch (check) {
                    case "\\n": {
                        sb.append('\n');
                        ++i;
                        break;
                    }
                    case "\\t": {
                        sb.append('\t');
                        ++i;
                        break;
                    }
                    case "\\r": {
                        sb.append('\r');
                        ++i;
                        break;
                    }
                    case "\\f": {
                        sb.append('\f');
                        ++i;
                        break;
                    }
                    case "\\b": {
                        sb.append('\b');
                        ++i;
                        break;
                    }
                    case "\\\\": {
                        sb.append('\\');
                        ++i;
                        break;
                    }
                    case "\\u": {
                        if (len < i + 6) {
                            throw new Err_Runtime("Invalid unicode sentence", value.substring(i));
                        }
                        sb.append(ConvChar.parseUnicode(value.substring(i, i + 6)));
                        i += 5;
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String escapeSpecialChars(String s, boolean singleQuote, boolean doubleQuote) {
        Err.ifNull(s);
        StringBuffer sb = new StringBuffer((int)((double)s.length() * 1.1));
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\'': {
                    sb.append(singleQuote ? "\\'" : Character.valueOf(c));
                    break;
                }
                case '\"': {
                    sb.append(doubleQuote ? "\\\"" : Character.valueOf(c));
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String unescapeSpecialChars(String s, boolean singleQuote, boolean doubleQuote) {
        Err.ifNull(s);
        StringBuffer sb = new StringBuffer((int)((double)s.length() * 1.1));
        int i = 0;
        while (i < s.length()) {
            if (s.startsWith("\\\\", i)) {
                sb.append('\\');
                ++i;
            } else if (s.startsWith("\\n", i)) {
                sb.append('\n');
                ++i;
            } else if (s.startsWith("\\t", i)) {
                sb.append('\t');
                ++i;
            } else if (s.startsWith("\\r", i)) {
                sb.append('\r');
                ++i;
            } else if (s.startsWith("\\f", i)) {
                sb.append('\f');
                ++i;
            } else if (s.startsWith("\\b", i)) {
                sb.append('\b');
                ++i;
            } else if (singleQuote && s.startsWith("\\'", i)) {
                sb.append('\'');
                ++i;
            } else if (doubleQuote && s.startsWith("\\\"", i)) {
                sb.append('\"');
                ++i;
            } else {
                sb.append(s.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    private static enum HTML_CHARS {
        auml('\u00e4', "&auml;"),
        ouml('\u00f6', "&ouml;"),
        uuml('\u00fc', "&uuml;"),
        Auml('\u00c4', "&Auml;"),
        Ouml('\u00d6', "&Ouml;"),
        Uuml('\u00dc', "&Uuml;"),
        szlig('\u00df', "&szlig;"),
        nbsp(' ', "&nbsp;"),
        euro('\u20ac', "&euro;"),
        lt('<', "&lt;"),
        gt('>', "&gt;");

        private final char chars;
        private final String html;

        private HTML_CHARS(char c, String html) {
            this.chars = c;
            this.html = html;
        }
    }
}

