/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.edit.refactor;

import de.mn77.base.data.constant.CONDITION;
import de.mn77.base.data.group.Group3;
import de.mn77.base.data.group.Group4;
import de.mn77.base.data.group.Section;
import de.mn77.lib.swing.DIALOG_TYPE;
import de.mn77.lib.swing.Lib_SwingDialog;
import java.awt.Component;
import java.util.ArrayList;
import org.jaymo_lang.edit.editor.styler.Scanner;
import org.jaymo_lang.edit.editor.styler.styles.SECTION_TYPE;
import org.jaymo_lang.edit.lib.Lib_IDE;
import org.jaymo_lang.edit.refactor.REFACTOR;
import org.jaymo_lang.edit.refactor.RefactorDocument;
import org.jaymo_lang.edit.refactor.RefactorStyles;
import org.jaymo_lang.util.Lib_Comply;

public class JayMo_Refactor {
    public static ArrayList<Section> occurrences(String text, int caretPosition) {
        Group3<RefactorDocument, String, REFACTOR> ssr = JayMo_Refactor.iScanAndSearch(text, caretPosition);
        if (ssr == null) {
            return null;
        }
        return ((RefactorDocument)ssr.o1).getOccurences((REFACTOR)((Object)ssr.o3), (String)ssr.o2);
    }

    public static String rename(Component parent, String text, int caretPosition) {
        Group3<RefactorDocument, String, REFACTOR> ssr = JayMo_Refactor.iScanAndSearch(text, caretPosition);
        if (ssr == null) {
            return null;
        }
        if (ssr.o3 == REFACTOR.TYPE) {
            String newName = Lib_SwingDialog.input((Component)parent, (String)"Refactoring type", (String)"New name for type", (String)((String)ssr.o2));
            if (newName == null) {
                return null;
            }
            if (!Lib_Comply.checkTypeName((String)newName)) {
                Lib_SwingDialog.okay((Component)parent, (DIALOG_TYPE)DIALOG_TYPE.ERROR, (String)"Name convention error", (String)("Invalid name for type: " + newName));
                return null;
            }
            return newName == null ? null : ((RefactorDocument)ssr.o1).renameType((String)ssr.o2, newName);
        }
        if (ssr.o3 == REFACTOR.FUNCTION) {
            String newName = Lib_SwingDialog.input((Component)parent, (String)"Refactoring function", (String)"New name for function", (String)((String)ssr.o2));
            if (newName == null) {
                return null;
            }
            if (!Lib_Comply.checkFunctionName((String)newName, (CONDITION)CONDITION.MAYBE)) {
                Lib_SwingDialog.okay((Component)parent, (DIALOG_TYPE)DIALOG_TYPE.ERROR, (String)"Name convention error", (String)("Invalid name for function: " + newName));
                return null;
            }
            return newName == null ? null : ((RefactorDocument)ssr.o1).renameFunction((String)ssr.o2, newName);
        }
        if (ssr.o3 == REFACTOR.VARIABLE) {
            String newName = Lib_SwingDialog.input((Component)parent, (String)"Refactoring variable", (String)"New name for variable", (String)((String)ssr.o2));
            if (newName == null) {
                return null;
            }
            if (!Lib_Comply.checkVarName((String)newName) && !Lib_Comply.checkConstName((String)newName)) {
                Lib_SwingDialog.okay((Component)parent, (DIALOG_TYPE)DIALOG_TYPE.ERROR, (String)"Name convention error", (String)("Invalid name for variable: " + newName));
                return null;
            }
            return newName == null ? null : ((RefactorDocument)ssr.o1).renameVar((String)ssr.o2, newName);
        }
        if (ssr.o3 == REFACTOR.CONSTANT) {
            String newName = Lib_SwingDialog.input((Component)parent, (String)"Refactoring constant", (String)"New name for constant", (String)((String)ssr.o2));
            if (newName == null) {
                return null;
            }
            if (!Lib_Comply.checkVarName((String)newName) && !Lib_Comply.checkConstName((String)newName)) {
                Lib_SwingDialog.okay((Component)parent, (DIALOG_TYPE)DIALOG_TYPE.ERROR, (String)"Name convention error", (String)("Invalid name for type: " + newName));
                return null;
            }
            return newName == null ? null : ((RefactorDocument)ssr.o1).renameConst((String)ssr.o2, newName);
        }
        return null;
    }

    private static boolean iForbidden(String word) {
        return Lib_IDE.isMagicVariable(word) || Lib_IDE.isAtomicWord(word);
    }

    private static REFACTOR iGetType(String word, SECTION_TYPE sectionType) {
        boolean firstUp;
        if (word.length() == 0 || JayMo_Refactor.iForbidden(word)) {
            return REFACTOR.UNKNOWN;
        }
        char c0 = word.charAt(0);
        boolean bl = firstUp = c0 >= 'A' && c0 <= 'Z';
        if (word.equals(word.toUpperCase())) {
            return firstUp ? REFACTOR.CONSTANT : REFACTOR.UNKNOWN;
        }
        if (firstUp) {
            return REFACTOR.TYPE;
        }
        if (sectionType == SECTION_TYPE.DEFINITION) {
            return REFACTOR.FUNCTION;
        }
        return c0 >= 'a' && c0 <= 'z' ? (sectionType == SECTION_TYPE.FUNCTION || sectionType == SECTION_TYPE.LOOP_FUNCTION ? REFACTOR.FUNCTION : REFACTOR.VARIABLE) : REFACTOR.UNKNOWN;
    }

    private static Group3<RefactorDocument, String, REFACTOR> iScanAndSearch(String text, int caretPosition) {
        Group4<Integer, Integer, SECTION_TYPE, RefactorDocument> scanResult = JayMo_Refactor.scan(text, caretPosition);
        switch ((SECTION_TYPE)((Object)scanResult.o3)) {
            case DEFINITION: 
            case FUNCTION: 
            case LOOP_FUNCTION: 
            case EVENT: 
            case TYPE: 
            case CONST: 
            case VAR: {
                break;
            }
            default: {
                return null;
            }
        }
        String textpart = text.substring((Integer)scanResult.o1, (Integer)scanResult.o1 + (Integer)scanResult.o2);
        int start = caretPosition - (Integer)scanResult.o1;
        Group3<REFACTOR, Integer, Integer> g3 = JayMo_Refactor.iSearchType(textpart, start, (SECTION_TYPE)((Object)scanResult.o3));
        String word = textpart.substring((Integer)g3.o2, (Integer)g3.o3);
        if (g3.o1 == REFACTOR.UNKNOWN || word.length() == 0) {
            return null;
        }
        return new Group3((Object)((RefactorDocument)scanResult.o4), (Object)word, (Object)((REFACTOR)((Object)g3.o1)));
    }

    private static int iSearchEnd(String text, int start) {
        int i = start;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_')) {
                return i;
            }
            ++i;
        }
        return text.length();
    }

    private static Group3<REFACTOR, Integer, Integer> iSearchType(String text, int caretPosition, SECTION_TYPE sectionType) {
        int i = caretPosition - 1;
        while (i >= 0) {
            char c = text.charAt(i);
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_')) {
                int end = JayMo_Refactor.iSearchEnd(text, i + 1);
                String word = text.substring(i + 1, end);
                REFACTOR rt = JayMo_Refactor.iGetType(word, sectionType);
                return new Group3((Object)rt, (Object)(i + 1), (Object)end);
            }
            --i;
        }
        int end = JayMo_Refactor.iSearchEnd(text, 0);
        String word = text.substring(0, end);
        REFACTOR rt = JayMo_Refactor.iGetType(word, sectionType);
        return new Group3((Object)rt, (Object)0, (Object)end);
    }

    private static Group4<Integer, Integer, SECTION_TYPE, RefactorDocument> scan(String text, int caretPosition) {
        RefactorDocument doc = new RefactorDocument(text);
        RefactorStyles styles = new RefactorStyles();
        Scanner scan = new Scanner(doc, styles);
        scan.update();
        Group3<Integer, Integer, SECTION_TYPE> g3 = doc.getAt(caretPosition);
        return new Group4((Object)((Integer)g3.o1), (Object)((Integer)g3.o2), (Object)((SECTION_TYPE)((Object)g3.o3)), (Object)doc);
    }
}

