/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.edit.editor.styler.styles;

import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.awt.Color;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import org.jaymo_lang.edit.editor.CodeEditor;
import org.jaymo_lang.edit.editor.styler.styles.SECTION_TYPE;

public class Styles {
    public final Style[] styles = new Style[SECTION_TYPE.values().length];
    private CodeEditor editor = null;

    public void initStyles(CodeEditor editor) {
        this.editor = editor;
        Color blue = new Color(50, 50, 255);
        Color green = new Color(31, 122, 71);
        Color black = Color.BLACK;
        Color dark_gray = Color.DARK_GRAY;
        Color magenta = new Color(230, 50, 230);
        Color red = new Color(255, 0, 0);
        Color dark_red = new Color(164, 0, 0);
        Color orange = new Color(242, 121, 0);
        Color cyan = new Color(0, 196, 196);
        Color light_gray = new Color(175, 175, 175);
        Color light_yellow = new Color(255, 255, 0);
        Color light_green = new Color(179, 255, 220);
        this.setStyle(SECTION_TYPE.IGNORE, black);
        this.setEmpty(SECTION_TYPE.LINEBREAK);
        this.setEmpty(SECTION_TYPE.WHITESPACE);
        this.setEmpty(SECTION_TYPE.UNKNOWN_WORD);
        this.setBackground(SECTION_TYPE.WHITESPACE_LEADING, red);
        this.setBackground(SECTION_TYPE.ERROR, red);
        this.setEmpty(SECTION_TYPE.TABULATOR);
        this.setStyle(SECTION_TYPE.FUNCTION, black);
        this.setStyle(SECTION_TYPE.LOOP_FUNCTION, black, 1);
        this.setStyle(SECTION_TYPE.CHAR, magenta);
        this.setStyle(SECTION_TYPE.STRING, magenta);
        this.setStyle(SECTION_TYPE.NUMBER, magenta);
        this.setStyle(SECTION_TYPE.ATOMIC_LITERAL, magenta);
        this.setStyle(SECTION_TYPE.PUNCTUATION, dark_gray);
        this.setBackground(SECTION_TYPE.COMMAND, black, light_gray);
        this.setStyle(SECTION_TYPE.DEFINITION, dark_red, 1);
        this.setStyle(SECTION_TYPE.BRACKET, dark_gray);
        this.setStyle(SECTION_TYPE.MAGIC_SHORT, cyan);
        this.setStyle(SECTION_TYPE.MAGIC_LONG, cyan);
        this.setStyle(SECTION_TYPE.EVENT, cyan);
        this.setStyle(SECTION_TYPE.TYPE, green, 1);
        this.setStyle(SECTION_TYPE.CONST, blue, 1);
        this.setStyle(SECTION_TYPE.VAR, blue);
        this.setStyle(SECTION_TYPE.PARSERSETTING, orange);
        this.setStyle(SECTION_TYPE.COMMENT_LINE, light_gray, 2);
        this.setStyle(SECTION_TYPE.COMMENT_BLOCK, light_gray, 2);
        this.setStyle(SECTION_TYPE.COMMENT_SCRIPT, light_gray, 2);
        this.setBackground(SECTION_TYPE.FOUND, light_yellow);
        this.setBackground(SECTION_TYPE.OCCUR, light_green);
        int i = 0;
        while (i < this.styles.length) {
            if (this.styles[i] == null) {
                MOut.temp((Object[])new Object[]{"Missing style for: " + SECTION_TYPE.values()[i].name()});
                Err.invalid((Object[])new Object[]{"Missing style"});
            }
            ++i;
        }
    }

    private void setBackground(SECTION_TYPE type, Color color) {
        Style style = this.editor.addStyle(type.name(), null);
        StyleConstants.setBackground(style, color);
        this.styles[type.ordinal()] = style;
    }

    private void setBackground(SECTION_TYPE type, Color front, Color back) {
        Style style = this.editor.addStyle(type.name(), null);
        StyleConstants.setForeground(style, front);
        StyleConstants.setBackground(style, back);
        this.styles[type.ordinal()] = style;
    }

    private void setEmpty(SECTION_TYPE type) {
        Style style;
        this.styles[type.ordinal()] = style = this.editor.addStyle(type.name(), null);
    }

    private void setStyle(SECTION_TYPE type, Color color) {
        Style style = this.editor.addStyle(type.name(), null);
        StyleConstants.setForeground(style, color);
        this.styles[type.ordinal()] = style;
    }

    private void setStyle(SECTION_TYPE type, Color color, int fontStyle) {
        Style style = this.editor.addStyle(type.name(), null);
        StyleConstants.setForeground(style, color);
        if ((fontStyle & 1) != 0) {
            StyleConstants.setBold(style, true);
        }
        if ((fontStyle & 2) != 0) {
            StyleConstants.setItalic(style, true);
        }
        this.styles[type.ordinal()] = style;
    }
}

