/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.wiki77;

import de.mn77.base.data.struct.I_List;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.lib.wiki77.Lib_Wiki77;
import java.util.HashSet;
import java.util.List;

public class Wiki77_Words {
    private final String WORD_SPECIAL_CHARS = "_-";
    StringBuilder output = new StringBuilder();

    public String[] parse(String wikiname, String wiki) {
        List<String> lines = Lib_Wiki77.parseLines(wiki);
        HashSet<String> words = new HashSet<String>();
        for (String line : lines) {
            this.parseLine(words, line, false);
        }
        words.add(wikiname);
        return words.toArray(new String[words.size()]);
    }

    private boolean isInWordChar(char c, boolean hard) {
        if (hard && c >= '0' && c <= '9') {
            return false;
        }
        if (!this.toRemove(c, false)) {
            return true;
        }
        if (hard) {
            return false;
        }
        return "_-".indexOf(c) > -1;
    }

    private boolean isNumber(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void parseLine(HashSet<String> words, String line, boolean hard) {
        I_List<String> parts = this.split(line.trim(), hard);
        for (String part : parts) {
            String trimmed = this.trim(part);
            if (trimmed.length() <= 1 || this.isNumber(trimmed)) continue;
            words.add(trimmed.toLowerCase());
            if (trimmed.equals(trimmed.toUpperCase()) || this.split(trimmed, true).size() <= 1) continue;
            this.parseLine(words, trimmed, true);
        }
    }

    private I_List<String> split(String s, boolean hard) {
        SimpleList result = new SimpleList();
        if (s.length() == 0) {
            return result;
        }
        int wordStart = -1;
        int idx = 0;
        while (idx < s.length()) {
            boolean isOk;
            char c = s.charAt(idx);
            if (wordStart >= 0) {
                String newWord;
                isOk = this.isInWordChar(c, hard);
                if (hard && isOk && (c >= 'A' && c <= 'Z' || c >= '\u00c0' && c <= '\u00dd')) {
                    newWord = s.substring(wordStart, idx);
                    result.add((Object)newWord);
                    wordStart = idx;
                }
                if (!isOk) {
                    newWord = s.substring(wordStart, idx);
                    result.add((Object)newWord);
                    wordStart = -1;
                }
            } else {
                boolean bl = isOk = !this.toRemove(c, true);
                if (isOk) {
                    wordStart = idx;
                }
            }
            ++idx;
        }
        if (wordStart > -1) {
            String newWord = s.substring(wordStart);
            result.add((Object)newWord);
        }
        return result;
    }

    private boolean toRemove(char c, boolean left) {
        if (left && c >= '0' && c <= '9' || c < '0') {
            return true;
        }
        if (c > '9' && c < 'A' || c > 'Z' && c < 'a') {
            return true;
        }
        return c > 'z' && c < '\u00c0' || c > '\u00ff';
    }

    private String trim(String s) {
        int left = 0;
        int right = s.length() - 1;
        while (left < right && this.toRemove(s.charAt(left), true)) {
            ++left;
        }
        while (right >= left && this.toRemove(s.charAt(right), false)) {
            --right;
        }
        return s.substring(left, right + 1);
    }
}

