/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.terminal;

import de.mn77.base.error.Err;

public class CSI {
    private static final String ESC = "\u001b[";
    public static final String color_bg_Black = "\u001b[40m";
    public static final String color_bg_Red = "\u001b[41m";
    public static final String color_bg_Green = "\u001b[42m";
    public static final String color_bg_Brown = "\u001b[43m";
    public static final String color_bg_Blue = "\u001b[44m";
    public static final String color_bg_Magenta = "\u001b[45m";
    public static final String color_bg_Cyan = "\u001b[46m";
    public static final String color_bg_Gray = "\u001b[47m";
    public static final String color_bg_Default = "\u001b[49m";
    public static final String color_bg_DarkGray = "\u001b[100m";
    public static final String color_bg_LightRed = "\u001b[101m";
    public static final String color_bg_LightGreen = "\u001b[102m";
    public static final String color_bg_Yellow = "\u001b[103m";
    public static final String color_bg_LightBlue = "\u001b[104m";
    public static final String color_bg_LightMagenta = "\u001b[105m";
    public static final String color_bg_Turquise = "\u001b[106m";
    public static final String color_bg_White = "\u001b[107m";
    public static final String color_fg_Black = "\u001b[30m";
    public static final String color_fg_Red = "\u001b[31m";
    public static final String color_fg_Green = "\u001b[32m";
    public static final String color_fg_Brown = "\u001b[33m";
    public static final String color_fg_Blue = "\u001b[34m";
    public static final String color_fg_Magenta = "\u001b[35m";
    public static final String color_fg_Cyan = "\u001b[36m";
    public static final String color_fg_Gray = "\u001b[37m";
    public static final String color_fg_DarkGray = "\u001b[90m";
    public static final String color_fg_LightRed = "\u001b[91m";
    public static final String color_fg_LightGreen = "\u001b[92m";
    public static final String color_fg_Yellow = "\u001b[93m";
    public static final String color_fg_LightBlue = "\u001b[94m";
    public static final String color_fg_LightMagenta = "\u001b[95m";
    public static final String color_fg_Turquise = "\u001b[96m";
    public static final String color_fg_White = "\u001b[97m";
    public static final String color_fg_Default_Underline = "\u001b[38m";
    public static final String color_fg_Default = "\u001b[39m";

    public static String cursorDown(int ... len) {
        return ESC + CSI.par1(len) + "B";
    }

    public static String cursorLeft(int ... len) {
        return ESC + CSI.par1(len) + "D";
    }

    public static String cursorRight(int ... len) {
        return ESC + CSI.par1(len) + "C";
    }

    public static String cursorToLine(int ... row) {
        return ESC + CSI.par1(row) + "F";
    }

    public static Object cursorTopLeft() {
        return "\u001b[H";
    }

    public static String cursorToRow(int ... row) {
        return ESC + CSI.par1(row) + "G";
    }

    public static String cursorUp(int ... len) {
        return ESC + CSI.par1(len) + "A";
    }

    public static String displayClear() {
        return "\u001b[2J";
    }

    public static String eraseLineToEnd(int ... len) {
        return ESC + CSI.par1(len) + "K";
    }

    public static String reset() {
        return "\u001b[0";
    }

    private static String par1(int[] ia) {
        Err.ifOutOfBounds((int)0, (int)1, (int[])new int[]{ia.length});
        return ia.length == 1 ? "" + ia[0] : "";
    }
}

