/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.tcp;

import de.mn77.base.MN;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Network;
import de.mn77.base.event.A_EnumEventHandler;
import de.mn77.base.sys.MOut;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.util.function.Consumer;

public class TCP_Connection
extends A_EnumEventHandler {
    public static final boolean DEBUG = false;
    public static final int DEFAULT_TIMEOUT = 30000;
    private final Socket socket;
    private final InputStream in;
    private final OutputStream out;
    private final BufferedReader bin;
    private final PrintWriter writer;

    public TCP_Connection(Socket socket, boolean event_in) {
        Err.ifNull((Object)socket);
        this.socket = socket;
        try {
            this.socket.setSoTimeout(30000);
            this.in = socket.getInputStream();
            this.out = socket.getOutputStream();
            this.bin = new BufferedReader(new InputStreamReader(this.in));
            this.writer = new PrintWriter(this.out);
        }
        catch (IOException e) {
            throw Err.show((Throwable)e);
        }
        if (event_in) {
            Runnable run = () -> {
                String z = null;
                try {
                    while ((z = this.bin.readLine()) != null) {
                        this.eventStart(EVENTS.RECIEVE, z);
                    }
                }
                catch (SocketException e1) {
                    MOut.dev((Object[])new Object[]{"Connection interrupted!"});
                    Err.show((Throwable)e1);
                    return;
                }
                catch (IOException e2) {
                    this.eventStart(EVENTS.ERROR, e2);
                    Err.show((Throwable)e2);
                }
            };
            Thread t = new Thread(run);
            t.start();
        }
    }

    public void close() {
        try {
            if (!this.socket.isClosed()) {
                this.socket.setSoTimeout(1);
            }
            this.bin.close();
            this.writer.close();
            this.socket.close();
        }
        catch (IOException e) {
            Err.show((Throwable)e);
        }
        MOut.dev((Object[])new Object[]{"Connection closed!"});
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isBound() && !this.socket.isClosed();
    }

    public void onError(Consumer<IOException> z) {
        this.eventAdd(EVENTS.ERROR, z);
    }

    public void onRecieve(Consumer<String> z) {
        this.eventAdd(EVENTS.RECIEVE, z);
    }

    public boolean recieveCheck(String needed) throws IOException, Err_Network {
        String e = this.recieveString();
        boolean ok = MN.isEqual((Object)e, (Object)needed);
        if (!ok) {
            MOut.dev((Object[])new Object[]{String.valueOf(needed) + " <---> " + e});
            throw new Err_Network("Connection error", new Object[]{"Needed: " + needed, "Received: " + e});
        }
        return ok;
    }

    public int recieveInt() throws IOException {
        String e = this.recieveString();
        try {
            return Integer.parseInt(e);
        }
        catch (NumberFormatException e2) {
            throw new IOException(String.valueOf(e) + " is not a number");
        }
    }

    public String recieveString() throws IOException {
        try {
            String s = this.bin.readLine();
            return s;
        }
        catch (SocketException e) {
            MOut.dev((Object[])new Object[]{"Connection interrupted!"});
            Err.show((Throwable)e);
        }
        catch (IOException e) {
            this.eventStart(EVENTS.ERROR, e);
            Err.show((Throwable)e);
        }
        return null;
    }

    public void send(int i) throws IOException {
        this.send("" + i);
    }

    public void send(String s) throws IOException {
        s = s.replace("\n", "");
        this.writer.println(s);
        this.writer.flush();
    }

    private static enum EVENTS {
        ERROR,
        RECIEVE;

    }
}

