/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.struct;

import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import de.mn77.base.sys.MOut;
import java.util.HashMap;

public class RelationSet<TA> {
    private final double[] relations;
    public TA[] objects;
    private final int size;
    private int used = 0;

    public static void main(String[] args) {
        RelationSet<Object> rq = new RelationSet<Object>(8);
        rq.put("Foo");
        rq.put("Bar");
        rq.put("Bop");
        rq.put("Qwe");
        rq.link("Foo", "Qwe");
        rq.link(2, 1);
        rq.relation(0, 2, 0.3);
        rq.setRelation("Bar", "Bop", 0.6);
        rq.unlink(2, 0);
        rq.show();
        MOut.print((Object[])new Object[]{rq.linked(0, 1)});
        MOut.print((Object[])new Object[]{rq.linked(0, 3)});
        MOut.print((Object[])new Object[]{rq.relation(0, 1)});
        MOut.print((Object[])new Object[]{rq.relation(0, 3)});
        MOut.print((Object[])new Object[]{rq.linkedWith(false)});
        MOut.print((Object[])new Object[]{rq.relationWith(0)});
    }

    public RelationSet(int size) {
        this.size = size;
        this.relations = new double[this.iCalc(size - 1, size)];
        this.objects = new Object[size];
    }

    public double getRelation(TA o1, TA o2) {
        int i1 = this.iSearch(o1);
        int i2 = this.iSearch(o2);
        return this.relation(i1, i2);
    }

    public void link(int index1, int index2) {
        this.iCheckIndex(index1);
        this.iCheckIndex(index2);
        int i = this.iCalc(index1, index2);
        this.relations[i] = 1.0;
    }

    public void link(TA o1, TA o2) {
        int i1 = this.iSearch(o1);
        int i2 = this.iSearch(o2);
        this.link(i1, i2);
    }

    public boolean linked(int index1, int index2) {
        this.iCheckIndex(index1);
        this.iCheckIndex(index2);
        int i = this.iCalc(index1, index2);
        return this.relations[i] > 0.0;
    }

    public boolean linked(TA o1, TA o2) {
        int i1 = this.iSearch(o1);
        int i2 = this.iSearch(o2);
        return this.linked(i1, i2);
    }

    public SimpleList<TA> linkedWith(int index) {
        this.iCheckIndex(index);
        SimpleList result = new SimpleList();
        int i = 0;
        while (i < this.used) {
            int r;
            double relation;
            if (index != i && (relation = this.relations[r = this.iCalc(index, i)]) > 0.0) {
                TA obj = this.objects[i];
                result.add(obj);
            }
            ++i;
        }
        return result;
    }

    public SimpleList<TA> linkedWith(TA o) {
        int index = this.iSearch(o);
        return this.linkedWith((TA)index);
    }

    public void put(TA o) {
        Err.ifNull(o);
        if (this.used == this.size) {
            throw new Err_Runtime("Maximum size already reached!", new Object[]{this.size});
        }
        int i = 0;
        while (i < this.used) {
            if (this.objects[i].equals(o)) {
                return;
            }
            ++i;
        }
        this.objects[this.used] = o;
        ++this.used;
    }

    public HashMap<TA, Double> relatedWith(TA o) {
        int index = this.iSearch(o);
        return this.relationWith(index);
    }

    public double relation(int index1, int index2) {
        this.iCheckIndex(index1);
        this.iCheckIndex(index2);
        int i = this.iCalc(index1, index2);
        return this.relations[i];
    }

    public void relation(int index1, int index2, double value) {
        this.iCheckIndex(index1);
        this.iCheckIndex(index2);
        this.iCheckValue(value);
        int i = this.iCalc(index1, index2);
        this.relations[i] = value;
    }

    public HashMap<TA, Double> relationWith(int index) {
        this.iCheckIndex(index);
        HashMap<TA, Double> result = new HashMap<TA, Double>();
        int i = 0;
        while (i < this.used) {
            int r;
            double relation;
            if (index != i && (relation = this.relations[r = this.iCalc(index, i)]) > 0.0) {
                TA obj = this.objects[i];
                result.put(obj, relation);
            }
            ++i;
        }
        return result;
    }

    public void setRelation(TA o1, TA o2, double value) {
        int i1 = this.iSearch(o1);
        int i2 = this.iSearch(o2);
        this.relation(i1, i2, value);
    }

    public void show() {
        MOut.print((String)this.toString());
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i1 = 0;
        while (i1 < this.used) {
            TA o = this.objects[i1];
            sb.append(o);
            sb.append(": ");
            boolean hasItems = false;
            int i2 = 0;
            while (i2 < this.used) {
                int r;
                double relation;
                if (i1 != i2 && (relation = this.relations[r = this.iCalc(i1, i2)]) > 0.0) {
                    TA obj = this.objects[i2];
                    if (hasItems) {
                        sb.append(", ");
                    }
                    sb.append(obj.toString());
                    sb.append("=");
                    sb.append(relation);
                    hasItems = true;
                }
                ++i2;
            }
            sb.append('\n');
            ++i1;
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public void unlink(int index1, int index2) {
        this.iCheckIndex(index1);
        this.iCheckIndex(index2);
        int i = this.iCalc(index1, index2);
        this.relations[i] = 0.0;
    }

    public void unlink(TA o1, TA o2) {
        int i1 = this.iSearch(o1);
        int i2 = this.iSearch(o2);
        this.unlink(i1, i2);
    }

    public int used() {
        return this.used;
    }

    private int iCalc(int i1, int i2) {
        if (i1 == i2) {
            throw new Err_Runtime("Loop !", new Object[]{this.size});
        }
        if (i1 > i2) {
            int b = i1;
            i1 = i2;
            i2 = b;
        }
        int a = i1 * this.size;
        return a + i2;
    }

    private void iCheckIndex(int index) {
        Err.ifOutOfBounds((int)0, (int)(this.used - 1), (int[])new int[]{index});
    }

    private void iCheckValue(double value) {
        Err.ifOutOfBounds((double)0.0, (double)1.0, (double[])new double[]{value});
    }

    private int iSearch(TA search) {
        Err.ifNull(search);
        int index = 0;
        while (index < this.used) {
            TA obj = this.objects[index];
            if (obj.equals(search)) {
                return index;
            }
            ++index;
        }
        throw new Err_Runtime("Object not found: " + search, new Object[0]);
    }
}

