/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.http;

import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Map;

public class Lib_Http {
    public static String fetch(String url) throws IOException {
        return Lib_Http.fetch(url, null, true, null);
    }

    public static String fetch(String url, int timeoutMSec) throws IOException {
        return Lib_Http.fetch(url, timeoutMSec, true, null);
    }

    public static String fetch(String url, Integer timeoutMSec, boolean follow, Map<String, String> properties) throws IOException {
        return Lib_Http.fetch(url, timeoutMSec, follow, properties, null);
    }

    public static String fetch(String url, Integer timeoutMSec, boolean follow, Map<String, String> properties, String[] login) throws IOException {
        return Lib_Http.fetch(url, timeoutMSec, follow, properties, login, 0);
    }

    public static String fetch(String url, String[] login, int timeoutMSec) throws IOException {
        return Lib_Http.fetch(url, timeoutMSec, true, null, login);
    }

    public static String fetchTitle(String url, Integer timeoutMSec) {
        int index;
        int end;
        int start;
        String low;
        String html;
        block5: {
            try {
                html = Lib_Http.fetch(url, timeoutMSec, true, null);
                low = html.toLowerCase();
                start = 0;
                end = html.length();
                index = low.indexOf("<title>");
                if (index >= 0) break block5;
                return null;
            }
            catch (IOException e) {
                Err.show((Throwable)e);
                return null;
            }
        }
        start = index + 7;
        index = low.indexOf("</title>", start);
        if (index < 0) {
            index = html.indexOf(60);
        }
        if (index >= 0) {
            end = index;
        }
        return html.substring(start, end);
    }

    private static String fetch(String url, Integer timeoutMSec, boolean follow, Map<String, String> properties, String[] login, int cycle) throws IOException {
        int i;
        URL server = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)server.openConnection();
        if (login != null) {
            Err.ifNot((Object)login.length, (Object)2, (String)"Invalid amount of Login-Data! Need 2, username+pass!");
            connection.setAuthenticator(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication("webservice", "Gx7%k9:Wrc27%L5sM,b7".toCharArray());
                }
            });
        }
        if (timeoutMSec != null) {
            connection.setConnectTimeout(timeoutMSec);
            connection.setReadTimeout(timeoutMSec);
        }
        if (follow) {
            HttpURLConnection.setFollowRedirects(follow);
        }
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        connection.connect();
        InputStream is = connection.getInputStream();
        InputStreamReader r = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(r);
        StringBuffer sb = new StringBuffer();
        while ((i = br.read()) != -1) {
            sb.append((char)i);
        }
        br.close();
        connection.disconnect();
        int responseCode = connection.getResponseCode();
        if (follow && (responseCode == 301 || responseCode == 302)) {
            MOut.dev((Object[])new Object[]{String.valueOf(responseCode) + " " + connection.getResponseMessage()});
            String newUrl = connection.getHeaderField("Location");
            if (!newUrl.equals(url) && cycle < 10) {
                return Lib_Http.fetch(newUrl, timeoutMSec, follow, properties, login, cycle + 1);
            }
        }
        return sb.toString();
    }
}

