/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.graphic;

import de.mn77.base.data.constant.position.POSITION;
import de.mn77.base.data.util.Lib_Math;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.file.I_File;
import de.mn77.lib.graphic.I_Image;
import de.mn77.lib.graphic.I_ImageX;
import de.mn77.lib.graphic.Lib_Graphic;
import de.mn77.lib.graphic.MImage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.LookupOp;
import java.awt.image.ShortLookupTable;
import java.awt.image.WritableRaster;

public class MImageX
extends MImage
implements I_ImageX {
    private boolean isGrayscale = false;

    public MImageX(I_File image) throws Err_FileSys {
        super(image);
    }

    public MImageX(I_Image copy, boolean grayscale) {
        super((BufferedImage)copy.getImage(), copy.getColorBitsOriginal());
        this.isGrayscale = grayscale;
    }

    public MImageX(int dx, int dy, int red, int green, int blue) {
        super(dx, dy, red, green, blue, 255);
    }

    public MImageX(int dx, int dy, int red, int green, int blue, int alpha) {
        super(dx, dy, red, green, blue, alpha);
    }

    public MImageX(Object image) {
        super(image);
    }

    public MImageX(Object image, int dx, int dy) throws Err_FileSys {
        super(image, dx, dy);
    }

    @Override
    public void add(I_Image image, POSITION position) {
        this.add(image, position, 0, 0);
    }

    @Override
    public void add(I_Image image, POSITION position, int offset_x, int offset_y) {
        WritableRaster raster1 = this.image.getRaster();
        WritableRaster raster2 = ((BufferedImage)image.getImage()).getRaster();
        int[] rgba1 = new int[4];
        int[] rgba2 = new int[4];
        Point pia = Lib_Graphic.position(raster1.getWidth(), raster1.getHeight(), raster2.getWidth(), raster2.getHeight(), position);
        Point p = new Point(pia.x + offset_x, pia.y + offset_y);
        int y = p.y;
        while (y < p.y + raster2.getHeight()) {
            int x = p.x;
            while (x < p.x + raster2.getWidth()) {
                if (x < raster1.getWidth() && y < raster1.getHeight() && x >= 0 && y >= 0) {
                    raster1.getPixel(x, y, rgba1);
                    raster2.getPixel(x - p.x, y - p.y, rgba2);
                    int alpha = rgba2[3];
                    rgba1[0] = (rgba1[0] * (255 - alpha) + rgba2[0] * alpha) / 255;
                    rgba1[1] = (rgba1[1] * (255 - alpha) + rgba2[1] * alpha) / 255;
                    rgba1[2] = (rgba1[2] * (255 - alpha) + rgba2[2] * alpha) / 255;
                    rgba1[3] = (rgba1[3] * (255 - alpha) + rgba2[3] * alpha) / 255;
                    raster1.setPixel(x, y, rgba1);
                }
                ++x;
            }
            ++y;
        }
    }

    @Override
    public void alphaToColor(int red, int green, int blue) {
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{red});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{green});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{blue});
        WritableRaster raster = this.image.getRaster();
        int[] rgba = new int[4];
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                raster.getPixel(x, y, rgba);
                rgba[0] = (int)Lib_Math.limit((double)0.0, (double)255.0, (double)(rgba[0] + (255 - rgba[3]) * red / 255));
                rgba[1] = (int)Lib_Math.limit((double)0.0, (double)255.0, (double)(rgba[1] + (255 - rgba[3]) * green / 255));
                rgba[2] = (int)Lib_Math.limit((double)0.0, (double)255.0, (double)(rgba[2] + (255 - rgba[3]) * blue / 255));
                raster.setPixel(x, y, rgba);
                ++x;
            }
            ++y;
        }
    }

    @Override
    public void brightness(int percent) {
        Err.ifOutOfBounds((double)100.0, (double)percent);
        short[][] colors = new short[4][256];
        int i = 0;
        while (i < 256) {
            short color = percent > 0 ? (short)(i + (255 - i) * percent / 100) : (short)((float)i * (float)(percent + 100) / 100.0f);
            colors[0][i] = color = (short)Lib_Math.limit((double)0.0, (double)255.0, (double)color);
            colors[1][i] = color;
            colors[2][i] = color;
            colors[3][i] = (short)i;
            ++i;
        }
        LookupOp op = new LookupOp(new ShortLookupTable(0, colors), null);
        BufferedImage temp = op.filter(this.image, null);
        this.iReplaceImage(temp);
    }

    @Override
    public void colorToAlpha(int rot, int gruen, int blau) {
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{rot});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{gruen});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{blau});
        WritableRaster raster = this.image.getRaster();
        int[] rgba = new int[4];
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                int abw;
                raster.getPixel(x, y, rgba);
                rgba[3] = abw = Math.abs((rot - rgba[0] + gruen - rgba[1] + blau - rgba[2]) / 3);
                raster.setPixel(x, y, rgba);
                ++x;
            }
            ++y;
        }
    }

    @Override
    public void colorToAlpha(int red, int green, int blue, int variance, boolean force) {
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{red});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{green});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{blue});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{variance});
        WritableRaster raster = this.image.getRaster();
        int[] rgba = new int[4];
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                raster.getPixel(x, y, rgba);
                int abw = Math.abs((red - rgba[0] + green - rgba[1] + blue - rgba[2]) / 3);
                if (rgba[0] == red && rgba[1] == green && rgba[2] == blue) {
                    rgba[3] = 0;
                } else if (abw <= variance) {
                    rgba[3] = force ? 0 : abw * 255 / variance;
                }
                raster.setPixel(x, y, rgba);
                ++x;
            }
            ++y;
        }
    }

    @Override
    public void contrast(int percent) {
        Err.ifOutOfBounds((double)100.0, (double)percent);
        short[][] colors = new short[4][256];
        int i = 0;
        while (i < 256) {
            short color = i < 128 ? (short)(i + -((127 - i) * percent / 100)) : (short)(i + (i - 127) * percent / 100);
            colors[0][i] = color = (short)Lib_Math.limit((double)0.0, (double)255.0, (double)color);
            colors[1][i] = color;
            colors[2][i] = color;
            colors[3][i] = (short)i;
            ++i;
        }
        LookupOp op = new LookupOp(new ShortLookupTable(0, colors), null);
        BufferedImage temp = op.filter(this.image, null);
        this.iReplaceImage(temp);
    }

    @Override
    public I_ImageX copy() {
        return new MImageX(super.copy(), this.isGrayscale);
    }

    @Override
    public void cut(int dx, int dy) {
        this.cut(dx, dy, (POSITION)POSITION.CENTER, Color.BLACK);
    }

    @Override
    public void cut(int dx, int dy, POSITION position) {
        this.cut(dx, dy, position, Color.BLACK);
    }

    @Override
    public void cut(int dx, int dy, POSITION position, Color background) {
        this.cut(dx, dy, position, 0, 0, background);
    }

    @Override
    public void cut(int dx, int dy, POSITION position, int offset_x, int offset_y, Color background) {
        Err.ifOutOfBounds((int)1, (int)4096, (int[])new int[]{dx});
        Err.ifOutOfBounds((int)1, (int)4096, (int[])new int[]{dy});
        Err.ifNull((Object[])new Object[]{dx, dy, position});
        BufferedImage neu = new BufferedImage(dx, dy, 2);
        Graphics2D g2d2 = neu.createGraphics();
        if (background != Color.BLACK) {
            g2d2.setColor(background);
            g2d2.fillRect(0, 0, dx, dy);
        }
        int x = 0;
        int y = 0;
        if (position == POSITION.TOP || position == POSITION.CENTER || position == POSITION.BOTTOM) {
            x = 0 - (this.image.getWidth() - dx) / 2;
        }
        if (position == POSITION.TOP_RIGHT || position == POSITION.RIGHT || position == POSITION.BOTTOM_RIGHT) {
            x = 0 - (this.image.getWidth() - dx);
        }
        if (position == POSITION.LEFT || position == POSITION.CENTER || position == POSITION.RIGHT) {
            y = 0 - (this.image.getHeight() - dy) / 2;
        }
        if (position == POSITION.BOTTOM_LEFT || position == POSITION.BOTTOM || position == POSITION.BOTTOM_RIGHT) {
            y = 0 - (this.image.getHeight() - dy);
        }
        g2d2.drawImage((Image)this.image, x -= offset_x, y -= offset_y, null);
        g2d2.dispose();
        this.iReplaceImage(neu);
    }

    @Override
    public void distort(int dx, int dy) {
        this.distort(dx, dy, false);
    }

    @Override
    public void distort(int dx, int dy, boolean fast) {
        Err.ifOutOfBounds((int)1, (int)4096, (int[])new int[]{dx});
        Err.ifOutOfBounds((int)1, (int)4096, (int[])new int[]{dy});
        BufferedImage neu = new BufferedImage(dx, dy, 2);
        Graphics2D g2d2 = neu.createGraphics();
        g2d2.drawImage(this.image.getScaledInstance(dx, dy, fast ? 2 : 4), 0, 0, null);
        g2d2.dispose();
        this.iReplaceImage(neu);
    }

    @Override
    public void dynamicGradient(int x, int y, int breite, int height) {
        WritableRaster raster = this.image.getRaster();
        int[] rgba = new int[4];
        int[] start = new int[4];
        int[] ziel = new int[4];
        int[] diff = new int[4];
        int zx = 0;
        while (zx < breite) {
            int ax = x + zx;
            raster.getPixel(ax, y + 0, start);
            raster.getPixel(ax, y + height - 1, ziel);
            int i = 0;
            while (i < 4) {
                diff[i] = ziel[i] - start[i];
                ++i;
            }
            int zy = 0;
            while (zy < height) {
                int ay = y + zy;
                raster.getPixel(ax, ay, rgba);
                int i2 = 0;
                while (i2 < 4) {
                    rgba[i2] = start[i2] + diff[i2] * zy / height;
                    ++i2;
                }
                raster.setPixel(x + zx, y + zy, rgba);
                ++zy;
            }
            ++zx;
        }
    }

    @Override
    public void flipX() {
        AffineTransform at = AffineTransform.getTranslateInstance(this.getWidth(), 0.0);
        at.scale(-1.0, 1.0);
        AffineTransformOp op = new AffineTransformOp(at, null);
        BufferedImage temp = op.filter(this.image, null);
        this.iReplaceImage(temp);
    }

    @Override
    public void flipY() {
        AffineTransform at = AffineTransform.getTranslateInstance(0.0, this.getHeight());
        at.scale(1.0, -1.0);
        AffineTransformOp op = new AffineTransformOp(at, null);
        BufferedImage temp = op.filter(this.image, null);
        this.iReplaceImage(temp);
    }

    @Override
    public void gamma(double gamma) {
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{(int)gamma});
        if (gamma <= 0.0) {
            gamma = 0.01;
        }
        short[][] colors = new short[4][256];
        int i = 0;
        while (i < 256) {
            short color = (short)(Math.pow((double)i / 255.0, 1.0 / gamma) * 255.0);
            colors[0][i] = color = (short)Lib_Math.limit((double)0.0, (double)255.0, (double)color);
            colors[1][i] = color;
            colors[2][i] = color;
            colors[3][i] = (short)i;
            ++i;
        }
        ShortLookupTable table = new ShortLookupTable(0, colors);
        LookupOp op = new LookupOp(table, null);
        BufferedImage temp = op.filter(this.image, null);
        this.iReplaceImage(temp);
    }

    @Override
    public void grayscale() {
        if (this.isGrayscale) {
            return;
        }
        this.isGrayscale = true;
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        BufferedImage temp = op.filter(this.image, null);
        this.iReplaceImage(temp);
    }

    @Override
    public void hsl(int hue, int saturation, int lightness) {
        if (hue != 0) {
            Err.ifOutOfBounds((double)359.0, (double)hue);
        }
        if (saturation != 0) {
            Err.ifOutOfBounds((double)100.0, (double)saturation);
        }
        if (lightness != 0) {
            Err.ifOutOfBounds((double)100.0, (double)lightness);
        }
        WritableRaster raster = this.image.getRaster();
        int[] rgb = new int[4];
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                raster.getPixel(x, y, rgb);
                float[] hsb = Lib_Graphic.RGBtoHSL(rgb[0], rgb[1], rgb[2]);
                hsb[0] = hsb[0] + (float)hue;
                while (hsb[0] >= 360.0f) {
                    hsb[0] = hsb[0] - 360.0f;
                }
                while (hsb[0] < 0.0f) {
                    hsb[0] = hsb[0] + 360.0f;
                }
                hsb[1] = hsb[1] + (float)saturation / 100.0f;
                hsb[1] = (float)Lib_Math.limit((double)0.0, (double)1.0, (double)hsb[1]);
                hsb[2] = hsb[2] + (float)lightness / 100.0f;
                hsb[2] = (float)Lib_Math.limit((double)0.0, (double)1.0, (double)hsb[2]);
                int[] ergb = Lib_Graphic.HSLtoRGB(hsb[0], hsb[1], hsb[2]);
                raster.setPixel(x, y, new int[]{ergb[0], ergb[1], ergb[2], rgb[3]});
                ++x;
            }
            ++y;
        }
    }

    @Override
    public void hsv(int hue, int saturation, int value) {
        if (hue != 0) {
            Err.ifOutOfBounds((double)359.0, (double)hue);
        }
        if (saturation != 0) {
            Err.ifOutOfBounds((double)100.0, (double)saturation);
        }
        if (value != 0) {
            Err.ifOutOfBounds((double)100.0, (double)value);
        }
        WritableRaster raster = this.image.getRaster();
        int[] rgb = new int[4];
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                raster.getPixel(x, y, rgb);
                float[] hsb = Lib_Graphic.RGBtoHSB(rgb[0], rgb[1], rgb[2]);
                hsb[0] = hsb[0] + (float)hue;
                while (hsb[0] >= 360.0f) {
                    hsb[0] = hsb[0] - 360.0f;
                }
                while (hsb[0] < 0.0f) {
                    hsb[0] = hsb[0] + 360.0f;
                }
                hsb[1] = hsb[1] + (float)saturation / 100.0f;
                hsb[1] = (float)Lib_Math.limit((double)0.0, (double)1.0, (double)hsb[1]);
                hsb[2] = hsb[2] + (float)value / 100.0f;
                hsb[2] = (float)Lib_Math.limit((double)0.0, (double)1.0, (double)hsb[2]);
                int[] ergb = Lib_Graphic.HSVtoRGB(hsb[0], hsb[1], hsb[2]);
                raster.setPixel(x, y, new int[]{ergb[0], ergb[1], ergb[2], rgb[3]});
                ++x;
            }
            ++y;
        }
    }

    @Override
    public void negative() {
        short[][] farben = new short[4][256];
        int i = 0;
        while (i < 256) {
            farben[0][i] = (short)(255 - i);
            ++i;
        }
        i = 0;
        while (i < 256) {
            farben[1][i] = (short)(255 - i);
            ++i;
        }
        i = 0;
        while (i < 256) {
            farben[2][i] = (short)(255 - i);
            ++i;
        }
        i = 0;
        while (i < 256) {
            farben[3][i] = (short)i;
            ++i;
        }
        ShortLookupTable table = new ShortLookupTable(0, farben);
        LookupOp op = new LookupOp(table, null);
        BufferedImage temp = op.filter(this.image, null);
        this.iReplaceImage(temp);
    }

    @Override
    public void removeAlpha(int red, int green, int blue) {
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{red});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{green});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{blue});
        WritableRaster raster = this.image.getRaster();
        int[] rgba = new int[4];
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                int abw;
                raster.getPixel(x, y, rgba);
                rgba[3] = abw = 255 - Math.abs((red - rgba[0] + green - rgba[1] + blue - rgba[2]) / 3);
                raster.setPixel(x, y, rgba);
                ++x;
            }
            ++y;
        }
    }

    @Override
    public void removeAlpha(int red, int green, int blue, int variance, boolean force) {
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{red});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{green});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{blue});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{variance});
        WritableRaster raster = this.image.getRaster();
        int[] rgba = new int[4];
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                raster.getPixel(x, y, rgba);
                int abw = Math.abs((red - rgba[0] + green - rgba[1] + blue - rgba[2]) / 3);
                if (rgba[0] == red && rgba[1] == green && rgba[2] == blue) {
                    rgba[3] = 255;
                } else if (abw <= variance) {
                    rgba[3] = force ? 255 : 255 - abw * 255 / variance;
                }
                raster.setPixel(x, y, rgba);
                ++x;
            }
            ++y;
        }
    }

    @Override
    public void rgb(int red, int green, int blue) {
        if (red != 0) {
            Err.ifOutOfBounds((double)255.0, (double)red);
        }
        if (green != 0) {
            Err.ifOutOfBounds((double)255.0, (double)green);
        }
        if (blue != 0) {
            Err.ifOutOfBounds((double)255.0, (double)blue);
        }
        short[][] farben = new short[4][256];
        int i = 0;
        while (i < 256) {
            farben[0][i] = (short)Lib_Math.limit((double)0.0, (double)255.0, (double)(i + red));
            ++i;
        }
        i = 0;
        while (i < 256) {
            farben[1][i] = (short)Lib_Math.limit((double)0.0, (double)255.0, (double)(i + green));
            ++i;
        }
        i = 0;
        while (i < 256) {
            farben[2][i] = (short)Lib_Math.limit((double)0.0, (double)255.0, (double)(i + blue));
            ++i;
        }
        i = 0;
        while (i < 256) {
            farben[3][i] = (short)i;
            ++i;
        }
        ShortLookupTable table = new ShortLookupTable(0, farben);
        LookupOp op = new LookupOp(table, null);
        BufferedImage temp = op.filter(this.image, null);
        this.iReplaceImage(temp);
    }

    @Override
    public void rotate(double degree) {
        this.rotate(degree, null);
    }

    @Override
    public void rotate(double degree, Color background) {
        double positiveDegrees = degree % 360.0 + (double)(degree < 0.0 ? 360 : 0);
        double degreesMod90 = positiveDegrees % 90.0;
        double radians = Math.toRadians(positiveDegrees);
        double radiansMod90 = Math.toRadians(degreesMod90);
        if (positiveDegrees == 0.0) {
            return;
        }
        int square = 0;
        if (positiveDegrees < 90.0) {
            square = 1;
        } else if (positiveDegrees >= 90.0 && positiveDegrees < 180.0) {
            square = 2;
        } else if (positiveDegrees >= 180.0 && positiveDegrees < 270.0) {
            square = 3;
        } else if (positiveDegrees >= 270.0) {
            square = 4;
        }
        int height = this.getHeight();
        int width = this.getWidth();
        double side1 = Math.sin(radiansMod90) * (double)height + Math.cos(radiansMod90) * (double)width;
        double side2 = Math.cos(radiansMod90) * (double)height + Math.sin(radiansMod90) * (double)width;
        double h = 0.0;
        int newWidth = 0;
        int newHeight = 0;
        if (square == 1 || square == 3) {
            h = Math.sin(radiansMod90) * (double)height;
            newWidth = (int)side1;
            newHeight = (int)side2;
        } else {
            h = Math.sin(radiansMod90) * (double)width;
            newWidth = (int)side2;
            newHeight = (int)side1;
        }
        int shiftX = (int)(Math.cos(radians) * h) - (square == 3 || square == 4 ? width : 0);
        int shiftY = (int)(Math.sin(radians) * h) + (square == 2 || square == 3 ? height : 0);
        BufferedImage newImage = new BufferedImage(newWidth, newHeight, 2);
        Graphics2D g2d = newImage.createGraphics();
        if (background == null && !newImage.getColorModel().hasAlpha()) {
            background = Color.black;
        }
        if (background != null) {
            g2d.setBackground(background);
            g2d.clearRect(0, 0, newWidth, newHeight);
        }
        g2d.rotate(radians);
        g2d.drawImage((Image)this.image, shiftX, -shiftY, null);
        this.iReplaceImage(newImage);
    }

    @Override
    public void scale(int dx, int dy) {
        this.scale(dx, dy, false);
    }

    @Override
    public void scale(int dx, int dy, boolean fast) {
        Err.ifOutOfBounds((int)-4096, (int)4096, (int[])new int[]{dx});
        Err.ifOutOfBounds((int)-4096, (int)4096, (int[])new int[]{dy});
        int ox = this.image.getWidth(null);
        int oy = this.image.getHeight(null);
        Point n = Lib_Graphic.calcResize(ox, oy, dx, dy);
        Err.ifOutOfBounds((int)1, (int)4096, (int[])new int[]{n.x});
        Err.ifOutOfBounds((int)1, (int)4096, (int[])new int[]{n.y});
        BufferedImage neu = new BufferedImage(n.x, n.y, 2);
        Graphics2D g2d2 = neu.createGraphics();
        g2d2.drawImage(this.image.getScaledInstance(n.x, n.y, fast ? 2 : 4), 0, 0, null);
        g2d2.dispose();
        this.iReplaceImage(neu);
    }

    private void iReplaceImage(BufferedImage neu) {
        this.dispose();
        this.image = neu;
    }
}

