/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.crypt.cipher;

import de.mn77.base.error.Err;
import de.mn77.base.stream.Lib_Stream;
import de.mn77.lib.crypt.cipher.JAVA_CIPHER;
import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;

public class JavaCipher {
    private final JAVA_CIPHER vg;

    public JavaCipher(JAVA_CIPHER vg) {
        Err.ifNull((Object)((Object)vg));
        this.vg = vg;
    }

    public byte[] decrypt(byte[] data, byte[] key) {
        return this.iByteArray(data, key, true);
    }

    public void decrypt(InputStream source, OutputStream target, byte[] key, boolean wait) throws Exception {
        this.iStream(source, target, key, wait, true);
    }

    public byte[] encrypt(byte[] data, byte[] key) {
        return this.iByteArray(data, key, false);
    }

    public void encrypt(InputStream source, OutputStream target, byte[] key, boolean wait) throws Exception {
        this.iStream(source, target, key, wait, false);
    }

    public int keyLengthMax() {
        return this.vg.keyLengthMax;
    }

    public int keyLengthMin() {
        return this.vg.keyLengthMin;
    }

    public JAVA_CIPHER type() {
        return this.vg;
    }

    private byte[] iByteArray(byte[] data, byte[] key, boolean decrypt) {
        Err.ifNull((Object[])new Object[]{data, key});
        try {
            return this.iCipher(key, decrypt).doFinal(data);
        }
        catch (Exception e) {
            throw Err.show((Throwable)e, (String)"Crypt/Decrypt error");
        }
    }

    private void iCheckKey(byte[] key) {
        Err.ifOutOfBounds((int)this.type().keyLengthMin, (int)this.type().keyLengthMax, (int[])new int[]{key.length});
    }

    private Cipher iCipher(byte[] key, boolean decrypt) throws Exception {
        this.iCheckKey(key);
        Cipher cipher = null;
        SecretKeySpec sKey = new SecretKeySpec(key, this.vg.javaName);
        cipher = Cipher.getInstance(this.vg.javaName);
        cipher.init(decrypt ? 2 : 1, sKey);
        return cipher;
    }

    private void iStream(InputStream source, OutputStream target, byte[] key, boolean wait, boolean decrypt) throws Exception {
        Err.ifNull((Object[])new Object[]{source, target, key});
        this.iCheckKey(key);
        CipherOutputStream cos = new CipherOutputStream(target, this.iCipher(key, decrypt));
        Lib_Stream.connect((InputStream)source, (OutputStream)cos, (!wait ? 1 : 0) != 0);
    }
}

